/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxSurfaceSTLWidget.h,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:18 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:
  
     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#ifndef __WX__3D__SURF__STL__WDG__
#define __WX__3D__SURF__STL__WDG__

//#include "wxVTKRenderWindowInteractor.h"
#include "vtk3DSurfaceSTLWidget.h"
#include <wx/wx.h>
#include <wx/slider.h>
#include <kernel/marInterface.h>

//----------------------------------------------------------------------------
/**
 * \brief Panel class composed of a vtk renderwindow with double click available
 * and add some buttons
 */
class wxSurfaceSTLWidget : public wxPanel
{
public:
    enum ToolBarIDs
    {
        ID_TOOL_BAR = 300,
        ID_BUTTON_NEW_AXIS,
        ID_BUTTON_DELETE_AXIS,
        ID_CHECKBOX_ISOVISIBLE,
        ID_SLIDER_ISOVAL,
        ID_SLIDER_OPACITY,
        ID_BUTTON_CHOOSE_COLOR,
        ID_BUTTON_VESSELS_CONSTRUCTION,
        ID_BUTTON_3D_CUTTER,
        ID_BUTTON_EXPORT_STL,
        ID_CHECKBOX_STL_VISIBLE,
        ID_SLIDER_STL_THRESH,
		ID_CHECKBOX_INVERT_SLICE_ORDER,
    };
    enum WidgetsIDs
    {
        ID_WORLD3D = 800
    };

public:

    wxSurfaceSTLWidget(
        wxWindow* parent,
        wxWindowID id = -1,
        const wxPoint& pos = wxDefaultPosition,
        const wxSize& size = wxDefaultSize,
        long style = wxScrolledWindowStyle,
        const wxString& name = wxPanelNameStr
        );

    ~wxSurfaceSTLWidget( );


	//vessels toolbar
    void OnVesselConstruction(wxCommandEvent& event);
    void On3DCutter(wxCommandEvent& event);
    void OnExportAsSTL(wxCommandEvent& event);

    //surface
    void OnChooseSurfaceColor(wxCommandEvent& event);
    void OnIsoVisible(wxCommandEvent& event);
    void OnSTLSurfaceVisible(wxCommandEvent& event);

    //slider isovalue
    void OnSliderIsovalueScrollThumbrelease(wxScrollEvent& event);

    //slider opacity
    void OnSliderOpacityScrollThumbrelease(wxScrollEvent& event);

	// Invers lecture order
   void OnInvertSliceOrder(wxCommandEvent& WXUNUSED(event));


    void OnSliderSTLSurfaceValueThumbrelease(wxScrollEvent& event);

    void ShowMARACASData( marInterface* mar );

    wxToolBar	*_axis_tb;
    wxToolBar	*_vessels_tb;
    wxCheckBox	*_isoVisible;
    wxSlider	*_isoValue;
    wxSlider	*_opacity;
    wxButton	*_surface_color; //mat
    wxCheckBox	*_stlIntSurfaceVisible;
    wxCheckBox	*_stlExtSurfaceVisible;
    wxSlider	*_stlSurfaceValue;
    wxCheckBox	*_chkInvertSliceOrder;

    marInterface* _mar;
    
    vtk3DSurfaceSTLWidget *_3DWorldSTL;

    DECLARE_EVENT_TABLE( );
};

#endif // __WX__3D__SURF__STL__WDG__
