/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

  Program:   wxMaracas
  Module:    $RCSfile: wxSurfaceWidget.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/15 14:15:18 $
  Version:   $Revision: 1.2 $

  Copyright: (c) 2002, 2003
  License:

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "../res/bitmaps/extract.xpm"
#include "../res/bitmaps/del_axis.xpm"
#include "../res/bitmaps/plans.xpm"
#include "wxSurfaceWidget.h"
#include "../marDictionary.h"
#include "../wxMaracas_ManualTree_MPRDlg.h"


#include <matrix.h>

#include <wx/dialog.h>
#include <wx/colordlg.h>

// PS -> #ifndef __WXMSW__
// PS -> #   include "../res/bitmaps/extract.xpm"
// PS -> #   include "../res/bitmaps/del_axis.xpm"
// PS -> #endif

//----------------------------------------------------------------------------
BEGIN_EVENT_TABLE( wxSurfaceWidget, wxPanel )

    EVT_BUTTON(ID_BUTTON_NEW_AXIS		, wxSurfaceWidget::OnExtractAxis			)
    EVT_BUTTON(ID_BUTTON_DELETE_AXIS	, wxSurfaceWidget::OnDeleteAxis				)
    EVT_BUTTON(ID_BUTTON_QUANTIFICATION , wxSurfaceWidget::OnQuantification			)
    EVT_BUTTON(ID_BUTTON_MANUAL_AXIS	, wxSurfaceWidget::OnManualAxis				)


    EVT_BUTTON(ID_BUTTON_CHOOSE_COLOR	, wxSurfaceWidget::OnChooseSurfaceColor		)
    EVT_CHECKBOX(ID_CHECKBOX_ISOVISIBLE	, wxSurfaceWidget::OnIsoVisible				)

    EVT_COMMAND_SCROLL(ID_SLIDER_OPACITY, wxSurfaceWidget::OnSliderOpacityScrollThumbrelease)
    EVT_COMMAND_SCROLL_THUMBRELEASE(ID_SLIDER_ISOVAL, wxSurfaceWidget::OnSliderIsovalueScrollThumbrelease)
END_EVENT_TABLE( );

//----------------------------------------------------------------------------
wxSurfaceWidget::wxSurfaceWidget(wxWindow* parent, wxWindowID id, const wxPoint& pos, 
								 const wxSize& size, long style, const wxString& name) 
								 : wxPanel( parent, id, pos, size, style, name )
{
printf("EED wxSurfaceWidget::wxSurfaceWidget  1 \n" );

	marDictionary marDict;
	char tmp[256];

	_id_toolbar_plans=-1;
    	_mar = NULL;

    	_3DWorld = new vtk3DSurfaceWidget( this, ID_WORLD3D );
	_3DWorld->SetInterfaceVtkPanelWidgets(this);

    // Set up axis toolbar
    wxBitmap axisToolBarBitmaps[ 3 ];
    axisToolBarBitmaps[ 0 ] = wxBITMAP( axistoolbar_extract );
    axisToolBarBitmaps[ 1 ] = wxBITMAP( axistoolbar_erase   );
    axisToolBarBitmaps[ 2 ] = wxBITMAP( toolbar_plans       );


   _bt_new_axis			= new wxBitmapButton( this, ID_BUTTON_NEW_AXIS		, axisToolBarBitmaps[ 0 ] );
   _bt_delete_axis		= new wxBitmapButton( this, ID_BUTTON_DELETE_AXIS	, axisToolBarBitmaps[ 1 ] );
   _bt_call_quantification	= new wxBitmapButton( this, ID_BUTTON_QUANTIFICATION, axisToolBarBitmaps[ 2 ],wxDefaultPosition,wxSize(70,70));

	_bt_manual_axis		= new wxButton(this, ID_BUTTON_MANUAL_AXIS, _T("Manual Axis"));	
//	_bt_manual_axis->SetSize(80,40);





    //By default the Iso value is visible.
    _isoVisible = new wxCheckBox ( this, ID_CHECKBOX_ISOVISIBLE, wxString(marDict.GetString(15), wxConvUTF8) );  //"Iso visible"
    _isoValue   = new wxSlider   ( this, ID_SLIDER_ISOVAL, 0, 0, 10000 , wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);
    _opacity    = new wxSlider   ( this, ID_SLIDER_OPACITY, 0, 0, 100 , wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL | wxSL_LABELS);
    _isoVisible->SetValue( true );
    _isoValue->SetLabel( wxString(marDict.GetString(25), wxConvUTF8) ); // "IsoValue"
    _opacity->SetLabel( wxString(marDict.GetString(0), wxConvUTF8) ); //"Surface opacity"


    //I can't get to brighten the button when mouse over:
    //_surface_color = new wxButton(this, ID_BUTTON_CHOOSE_COLOR, "", wxPoint(0,0), wxSize(150,50), wxRAISED_BORDER);
    //_surface_color->SetBackgroundColour( wxColour(250, 235, 214));


    //Set Properties:
    _isoValue->SetSize(wxSize(64, 16));
    //End set properties

    //Do the layout:
    wxStaticBoxSizer* sizer_3 = new wxStaticBoxSizer(new wxStaticBox(this, -1,wxString(marDict.GetString(10), wxConvUTF8)  ), wxVERTICAL);//"Iso Surface values"
    //Some borders are needed on wxGTK otherwise static text and slider labels collides.
    sizer_3->Add(_isoVisible, 1, wxALL|wxEXPAND, 2);
    sizer_3->Add(new wxStaticText(this, -1, wxString(marDict.GetString(20), wxConvUTF8)), 1, wxALL|wxEXPAND, 2); // "Opacity (%)"
    sizer_3->Add(_opacity, 1, wxALL|wxEXPAND, 2);
    sizer_3->Add(new wxStaticText(this, -1,wxString(marDict.GetString(25), wxConvUTF8) ), 1, wxALL|wxEXPAND, 2); // "Isovalue"
    sizer_3->Add(_isoValue, 1, wxALL|wxEXPAND, 2);

    //Do the layout:
	strcpy( tmp , marDict.GetString(30) ); 
	_st_cero	= new wxStaticText(this,-1 , wxString(tmp, wxConvUTF8),wxPoint(0,0),wxDefaultSize,wxALIGN_CENTRE );	// "0"

	strcpy( tmp , marDict.GetString(35) ); strcat( tmp , "\n" ); strcat( tmp , marDict.GetString(40) );
	_st_text	= new wxStaticText(this,-1 , wxString(tmp, wxConvUTF8),wxPoint(0,0),wxDefaultSize,wxALIGN_CENTRE);	// "Select\n artery" 

	strcpy( tmp , marDict.GetString(45) ); strcat( tmp , "\n" ); strcat( tmp , marDict.GetString(50) );
	_st_one	= new wxStaticText(this,-1 , wxString(tmp, wxConvUTF8),wxPoint(0,0),wxDefaultSize,wxALIGN_CENTRE );		// "1 \n Axis Extraction" 

	strcpy( tmp , marDict.GetString(55) ); strcat( tmp , "\n" ); strcat( tmp , marDict.GetString(60) );
	_st_two	= new wxStaticText(this,-1 , wxString(tmp, wxConvUTF8),wxPoint(0,0),wxDefaultSize,wxALIGN_CENTRE);		// " 2 \n Quantification"


//	wxFont font(12,wxDEFAULT ,wxNORMAL,wxBOLD);
//	st_blank->SetFont(font);
//	st_next1->SetFont(font);
//	st_next2->SetFont(font);
//	_st_one->SetFont(font);
//	_st_two->SetFont(font);
//	_st_cero->SetFont(font);
 
	_st_one->Disable();
	_bt_new_axis->Disable();
	_bt_delete_axis->Disable();
        _st_two->Disable();
	_bt_call_quantification->Disable();



	wxFlexGridSizer	*axis_sizer = new wxFlexGridSizer(3,5,5,5);
	axis_sizer->Add(_st_cero				,0,wxALIGN_CENTER_HORIZONTAL);
	axis_sizer->Add(new wxStaticText(this,-1 , _T(" "))				,0,wxALIGN_CENTER_HORIZONTAL);
	axis_sizer->Add(_st_one					,0,wxALIGN_CENTER_HORIZONTAL);
	axis_sizer->Add(new wxStaticText(this,-1 , _T(" "))				,0,wxALIGN_CENTER_HORIZONTAL);
	axis_sizer->Add(_st_two					,0,wxALIGN_CENTER_HORIZONTAL);

	axis_sizer->Add(_st_text				,0,wxALIGN_CENTRE_VERTICAL);
	axis_sizer->Add(new wxStaticText(this,-1 , _T(" "))     ,0,wxALIGN_CENTRE_VERTICAL);
	axis_sizer->Add(_bt_new_axis			,0,wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL);
	axis_sizer->Add(new wxStaticText(this,-1 , _T("  "))				,0,wxALIGN_CENTRE_VERTICAL);
	axis_sizer->Add(_bt_call_quantification	,0,wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL);

	axis_sizer->Add(new wxStaticText(this,-1 , _T(" "))				,0,wxALIGN_CENTRE_VERTICAL);
	axis_sizer->Add(new wxStaticText(this,-1 , _T(" "))				,0,wxALIGN_CENTRE_VERTICAL);
	axis_sizer->Add(_bt_delete_axis			,0,wxALIGN_CENTRE_VERTICAL|wxALIGN_CENTER_HORIZONTAL);
    wxBoxSizer *sizer_2 = new wxBoxSizer(wxVERTICAL);
    sizer_2->Add(sizer_3	, 1, wxEXPAND, 0);
    sizer_2->Add(new wxStaticText(this,-1 , _T(" "))	);
    sizer_2->Add(new wxStaticText(this,-1 , _T(" "))	);
    sizer_2->Add(new wxStaticText(this,-1 , _T(" "))	);
    sizer_2->Add(new wxStaticText(this,-1 , _T(" "))	);
    sizer_2->Add(axis_sizer	, 1, wxEXPAND|wxALL|wxALIGN_LEFT, 0);
    sizer_2->Add(_bt_manual_axis);


    wxBoxSizer* sizer_1 = new wxBoxSizer(wxHORIZONTAL);
    sizer_1->Add(_3DWorld, 1, wxEXPAND, 0);
    sizer_1->Add(sizer_2, 0, wxALL|wxALIGN_RIGHT, 5);

    SetSizer(sizer_1);
    SetAutoLayout(true);
    Layout();



}

//----------------------------------------------------------------------------
wxSurfaceWidget::~wxSurfaceWidget( )
{
	_3DWorld->Delete();
}

//----------------------------------------------------------------------------
void wxSurfaceWidget::ShowMARACASData( marInterface* mar )
{
  wxBusyCursor wait;

   double min, max; //backward compatibility
  _mar = mar;
  _3DWorld->ShowMARACASData( mar );
  _3DWorld->ConfigureVTK( );
  _3DWorld->InitCameraReset( );

  //GUI stuff:
  _mar->_experiment->getDynData( )->getVolume( )->getMinMax( min, max );

  _isoValue->SetRange((int)min, (int)max);
  _isoValue->SetValue( (int)(max/4) );

  _opacity->SetValue( 50 );

//EED 31 Mai 2007
//  _3DWorld->Render();

}
//----------------------------------------------------------------------------
void wxSurfaceWidget::OnChooseSurfaceColor(wxCommandEvent& WXUNUSED(event))
{
    wxColourData data;
    data.SetChooseFull( true );
    for( int i = 0; i < 16; i++ )
    {
    	wxColour colour( i * 16, i * 16, i * 16 );
    	data.SetCustomColour( i, colour );
    } // rof

    wxColourDialog dialog ( this, &data );
    dialog.SetTitle( _T("choose color") );

    if( dialog.ShowModal( ) == wxID_OK )
    {
    	wxColourData retData = dialog.GetColourData( );
    	wxColour col = retData.GetColour( );
      //_surface_color->SetBackgroundColour( col );

      _3DWorld->SetSurfaceColor(col.Red(), col.Green(), col.Blue() );

    } // fi

}
//----------------------------------------------------------------------------
void wxSurfaceWidget::OnIsoVisible(wxCommandEvent& WXUNUSED(event))
{
  _3DWorld->SetSurfaceVisibility( _isoVisible->GetValue() );
}
//----------------------------------------------------------------------------
void wxSurfaceWidget::OnSliderIsovalueScrollThumbrelease(wxScrollEvent& event)
{
  wxBusyCursor wait;
  _3DWorld->SetSurfaceIsoValue( event.GetPosition() );
}
//----------------------------------------------------------------------------
void wxSurfaceWidget::OnSliderOpacityScrollThumbrelease(wxScrollEvent& event)
{
  _3DWorld->SetSurfaceOpacity( event.GetPosition() );
}
//----------------------------------------------------------------------------
void wxSurfaceWidget::OnExtractAxis(wxCommandEvent& event)
{
  if(_3DWorld->GetInitialSphere() )
  {
// EED Borrame
long int startTimeAE = clock();;


   wxBusyCursor wait;

	gtm::TVector< double > xc( 3 );
	double data[3];
	int extent[ 6 ];
	double spc[ 3 ];
// PS -> 	vtkPolyData* allData; //PS

	vtkImageData *imageData=_mar->_experiment->getDynData( )->getVolume( )->castVtk();
    imageData->GetExtent( extent );
    imageData->GetSpacing( spc );
    _3DWorld->GetSphereCenter( data );


//EED 20 Sep 2006
//	_mar->_experiment->setStartPoint( (int)data[0] - extent[0], (int)data[1] - extent[2], (int)data[2] - extent[4]);
	double x,y,z;
	x= (data[0] - extent[0]) / spc[0];
	y= (data[1] - extent[2]) / spc[1];
	z= (data[2] - extent[4]) / spc[2];
	_mar->_experiment->setStartPoint( (int)x, (int)y, (int)z);

	_mar->_experiment->extractVascularTree( );

	_mar->_experiment->setAxis( 0 );

	AddAxisActors();
// PS -> 	 allData = temp->Draw( ); //PS
// PS ->      _3DWorld->SetAxis( allData );//PS

    //Disabling tool

//EED    _axis_tb->EnableTool(ID_BUTTON_NEW_AXIS, false);
//EED    _axis_tb->EnableTool(ID_BUTTON_DELETE_AXIS, true);

	_bt_new_axis->Disable();
    _st_two->Enable();
	_bt_delete_axis->Enable();
	_bt_call_quantification->Enable();

	event.Skip();
	wxCommandEvent ev(wxEVT_COMMAND_MENU_SELECTED,ID_BUTTON_NEW_AXIS);
	ProcessEvent( ev );

/*
//EED Borrame
FILE *ff;
ff = fopen("c:/temp/MaracasStadistics.txt","a+");
long int endtime = clock();
double sg = (double)(endtime-startTimeAE) / (double)CLK_TCK;
fprintf(ff,"EED %p wxSurfaceWidget::OnExtractAxis > AE_t = %f \n",this,sg);
fclose(ff);
*/

  }
  else
  {
    	wxMessageBox( _T("Set an initial point.\n \n (Double click over the interest artery.)"),
					  _T("DxMM : MARACAS"), wxOK | wxCENTRE | wxICON_INFORMATION, this);
  }

}
//----------------------------------------------------------------------------
void wxSurfaceWidget::AddAxisActors(){
	// Axes ...
	marAxis		*maraxis		= _mar->_experiment->getAxis( );
	vtkPolyData *vtkpolydata	= maraxis->Draw();
	vtkPoints	*vtkpoints		= vtkpolydata->GetPoints();
	int			size			= vtkpoints->GetNumberOfPoints();

// EED 22 sep 2006
// EED 07 dic 2006
	double voxelSize = _mar->_parameters->getVoxelSize();
	double pp[3];
	int i;
	for (i=0;i<size;i++)
	{
		vtkpoints->GetPoint(i,pp);
		pp[0]=pp[0] * voxelSize;
		pp[1]=pp[1] * voxelSize;
		pp[2]=pp[2] * voxelSize;
	}


	if (maraxis!=NULL) _3DWorld->SetAxis( vtkpolydata );
	// Other Actors..
	// ..
}
//----------------------------------------------------------------------------
void wxSurfaceWidget::Clean3D(){
  _3DWorld->RemoveAxis( );
}
//----------------------------------------------------------------------------
void wxSurfaceWidget::RefreshAxis() {   
	_3DWorld->Render(); 
}
//----------------------------------------------------------------------------
void wxSurfaceWidget::OnDeleteAxis(wxCommandEvent& event)
{
	wxBusyCursor wait;
	Clean3D();
	_mar->_experiment->DeleteAxis( 0 );

    //Disabling tool
    //wxToolBar::EnableTool This function should only be called after Realize.

	_bt_new_axis->Enable();
	_bt_delete_axis->Disable();
	_bt_call_quantification->Disable();
	_st_one->Enable();
	_st_two->Disable();

	event.Skip();
	wxCommandEvent ev(wxEVT_COMMAND_MENU_SELECTED,ID_BUTTON_DELETE_AXIS);
	ProcessEvent(  ev );

}
//----------------------------------------------------------------------------
void wxSurfaceWidget::CallBackOnLeftDClick( wxMouseEvent& event ){
	_3DWorld->SetInitialPoint();
	if ( _3DWorld->GetInitialSphere() ){  
		marAxis *maraxis = _mar->_experiment->getAxis( );

		if (maraxis==NULL) {
			_st_one->Enable();
			_bt_new_axis->Enable();
		} else {
			_st_one->Disable();
			_bt_new_axis->Disable();
		}

	}


	if ( !_3DWorld->GetInitialSphere() ) {
			_st_one->Disable();
			_bt_new_axis->Disable();
	}

}
//----------------------------------------------------------------------------
void wxSurfaceWidget::OnQuantification(wxCommandEvent& event){
	if (_id_toolbar_plans!=-1){
	   wxCommandEvent ev(wxEVT_COMMAND_MENU_SELECTED,_id_toolbar_plans);
	   ProcessEvent(  ev );
	}
}
//----------------------------------------------------------------------------
void wxSurfaceWidget::SetId_toolbar_plans(int id_toolbar_plans ){
	_id_toolbar_plans=id_toolbar_plans;
}
//----------------------------------------------------------------------------
int wxSurfaceWidget::GetIsovalue(){
	return _isoValue->GetValue();
}
//----------------------------------------------------------------------------
int wxSurfaceWidget::GetOpacity(){
	return _opacity->GetValue();
}
//----------------------------------------------------------------------------
vtk3DSurfaceWidget *wxSurfaceWidget::GetVtk3DSurfaceWidget(){
	return _3DWorld;
}
//----------------------------------------------------------------------------
void wxSurfaceWidget::OnManualAxis(wxCommandEvent& event)
{
	wxBusyCursor wait;
	if ( _bt_delete_axis->IsEnabled() )
	{
		OnDeleteAxis(event);
	}

	vtkImageData *imagedata =  _mar->_experiment->getDynData( )->getVolume( )->castVtk();	
	wxMaracas_ManualTree_MPRDlg  *maracasManualTreeMPRDlg = new wxMaracas_ManualTree_MPRDlg( this , new marImageData(imagedata), _mar->_parameters->getVoxelSize() );
	marAxis *maraxis = new marAxis( _mar->_experiment->getParameters() );
	maracasManualTreeMPRDlg->SetMarAxis( maraxis );
	maracasManualTreeMPRDlg->ConfigureVTK();
	if (maracasManualTreeMPRDlg->ShowModal()==wxID_OK)
	{
		if (maracasManualTreeMPRDlg->ExportPoints()==true){
			_mar->_experiment->appendAxis(maraxis);
			_bt_new_axis->Disable();
			_st_two->Enable();
			_bt_delete_axis->Enable();
			_bt_call_quantification->Enable();
			AddAxisActors();
			event.Skip();
			wxCommandEvent ev(wxEVT_COMMAND_MENU_SELECTED,ID_BUTTON_NEW_AXIS);
			ProcessEvent(  ev );
		} else {
			delete maraxis;
		}
	}
	maracasManualTreeMPRDlg->Destroy();

}
