/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "creaContoursFactory.h"

#include "manualContourControler.h"
#include "manualCircleControler.h"
#include "manualContourModelCircle.h"
#include "manualViewCircle.h"
#include "manualLineControler.h"
#include "manualContourModelLine.h"
#include "manualViewLine.h"
#include "manualRoiControler.h"
#include "manualViewRoi.h"
#include "manualContourModelRoi.h"
#include "manualViewBullEye.h"
#include "manualContourModelBullEye.h"
#include "manualViewPoints.h"
#include "manualRotationToolControler.h"
#include "manualContourModelRotationTool.h"
#include "manualViewRotationTool.h"
#include "manualContourModelPolygon.h"
#include "manualView3DContour.h"
#include "manualContour3DControler.h"
#include "manualContour3V3DControler.h"


creaContoursFactory::creaContoursFactory()
{

}


creaContoursFactory::~creaContoursFactory()
{

}

manualContourBaseControler* creaContoursFactory::getContourControler(int typeContour)
{
	manualContourBaseControler *manContourControl = NULL;
	//spline
	if (typeContour==1)
	{
		manContourControl	= new manualContourControler();
	}

	//rectangle
	if (typeContour==2)
	{
		manContourControl	= new manualRoiControler();
	}

	//circle
	if (typeContour==3)
	{
		manContourControl	= new manualCircleControler();
	}

	//bullEye
	if (typeContour==4)
	{
		manContourControl	= new manualRoiControler();
	}

	//line
	if (typeContour==6)
	{
		manContourControl	= new manualLineControler();
	}

	//points
	if (typeContour==7)
	{
		manContourControl	= new manualContourControler();
	}

	//rotationTool
	if (typeContour==8)
	{
		manContourControl	= new manualRotationToolControler();
	}
	
	//polygon
	if (typeContour==10)
	{
		manContourControl	= new manualContourControler();
	}


	//JPReyes 13/04/2010
	//Spline 3D
	if(typeContour==12)
	{
		manContourControl = new manualContour3V3DControler();
	}

	return manContourControl;

}

manualContourBaseControler* creaContoursFactory::getContourControler(std::string typeContour)
{
	manualContourBaseControler *manContourControl = NULL;
	if (typeContour.compare("spline")==0)
	{
			manContourControl = getContourControler(1);
	}

	if (typeContour.compare("rectangle")==0)
	{
		manContourControl = getContourControler(2);
	}

	if (typeContour.compare("circle")==0)
	{
		manContourControl = getContourControler(3);
	}

	if (typeContour.compare("bullEye")==0)
	{
		manContourControl = getContourControler(4);
	}

	if (typeContour.compare("line")==0)
	{
		manContourControl = getContourControler(6);
	}
	
	if (typeContour.compare("points")==0)
	{
		manContourControl = getContourControler(7);
	}

	if (typeContour.compare("rotationTool")==0)
	{
		manContourControl = getContourControler(8);
	}
	
	if (typeContour.compare("polygon")==0)
	{
		manContourControl	=  getContourControler(10);
	}

	//JPReyes 13/04/2010
	//Spline 3D
	if(typeContour.compare("spline3D")==0)
	{
		manContourControl = getContourControler(12);
	}
	return manContourControl;
}

manualViewBaseContour* creaContoursFactory::getCountourView (int typeContour)
{
	
	manualViewBaseContour *manViewerContour = NULL;
	//spline
	if (typeContour==1)
	{
		manViewerContour	= new manualViewContour();
	}

	//rectangle
	if (typeContour==2)
	{
		manViewerContour	= new manualViewRoi();
	}

	//circle
	if (typeContour==3)
	{
		manViewerContour	= new manualViewCircle();
	}

	//bullEye
	if (typeContour==4)
	{
		manViewerContour	= new manualViewBullEye();
	}

	//line
	if (typeContour==6)
	{
		manViewerContour	= new manualViewLine();
	}
	
	//points
	if (typeContour==7)
	{
		manViewerContour	= new manualViewPoints();
	}

	//rotationTool
	if (typeContour==8)
	{
		manViewerContour	= new manualViewRotationTool();
	}

	//polygon
	if (typeContour==10)
	{
		manViewerContour	= new manualViewContour();
	}

	//JPReyes 13/04/2010
	//Spline 3D
	if(typeContour==12)
	{
		manViewerContour	= new manualView3DContour();
	}
	return manViewerContour;
}

manualViewBaseContour* creaContoursFactory::getCountourView (std::string typeContour)
{

	manualViewBaseContour *manViewerContour = NULL;

	if (typeContour.compare("spline")==0)
	{
		manViewerContour = getCountourView(1);
	}

	if (typeContour.compare("rectangle")==0)
	{
		manViewerContour = getCountourView(2);
	}

	if (typeContour.compare("circle")==0)
	{
		manViewerContour = getCountourView(3);
	}

	if (typeContour.compare("bullEye")==0)
	{
		manViewerContour = getCountourView(4);
	}

	if (typeContour.compare("line")==0)
	{
		manViewerContour = getCountourView(6);
	}
	
	if (typeContour.compare("points")==0)
	{
		manViewerContour = getCountourView(7);
	}

	if (typeContour.compare("rotationTool")==0)
	{
		manViewerContour = getCountourView(8);
	}

	if (typeContour.compare("polygon")==0)
	{
		manViewerContour = getCountourView(10);
	}

	//JPReyes 13/04/2010
	//Spline 3D
	if (typeContour.compare("spline3D")==0)
	{
		manViewerContour = getCountourView(12);
	}

	return manViewerContour;

}

manualBaseModel* creaContoursFactory::getContourModel(int typeContour)
{
	manualBaseModel *manModelContour=NULL;

	// spline
	if (typeContour==1)
	{
		manModelContour = new manualContourModel();
	}

	// rectangle
	if (typeContour==2)
	{
		manModelContour = new manualContourModelRoi();
	}

	// circle
	if (typeContour==3)
	{
		manModelContour = new manualContourModelCircle();
	}

	//bullEye
	if(typeContour==4)
	{
		//Here we create a bullEye with 3 crowns and 5 sectors.
		manualContourModelBullEye *manModelContourBullEye = new manualContourModelBullEye();
			
		int iCrown,sizeCrowns,iSector,sizeSectors;
		double radioA,radioB,ang,angDelta,radioA2,radioB2 ;

		sizeCrowns = 3;
		radioA=33;
		radioB=0;
		angDelta= 72;
		for ( iCrown=0 ; iCrown<sizeCrowns ; iCrown++ )
		{
			sizeSectors = 5;
			radioB	= radioA;
			if (iCrown==sizeCrowns-1)
			{
				radioA	= 0;
			} 
			else 
			{
				radioA	= radioA+33;
			}
			radioA2=radioA/100.0;
			radioB2=radioB/100.0;
			ang=0;
			for ( iSector=0 ; iSector<sizeSectors  ; iSector++ )
			{		
				ang	= ang+angDelta;
				manModelContourBullEye->AddSector(radioA2,radioB2,ang,angDelta);
			} // for iSector
		}//for iCrown
		manModelContour		= manModelContourBullEye;
	}

	// line
	if (typeContour==6)
	{
		manModelContour = new manualContourModelLine();
	}
	
	// points
	if (typeContour==7)
	{
		manModelContour = new manualBaseModel();
	}

	//rotationTool
	if(typeContour==8)
	{
		manModelContour = new manualContourModelRotationTool();
	}

	//polygon
	if(typeContour==10)
	{
		manModelContour = new manualContourModelPolygon();
	}

	
	//JPReyes 13/04/2010
	//Spline 3D
	if(typeContour==12)
	{
		manModelContour = new manualContourModel();
	}

	return manModelContour;
}


manualBaseModel* creaContoursFactory::getContourModel(std::string typeContour)
{
	manualBaseModel *manModelContour=NULL;

	if (typeContour.compare("spline")==0)
	{
		manModelContour = getContourModel(1);
	}

	if (typeContour.compare("rectangle")==0)
	{
		manModelContour = getContourModel(2);
	}

	if (typeContour.compare("circle")==0)
	{
		manModelContour = getContourModel(3);
	}

	if (typeContour.compare("bullEye")==0)
	{
		manModelContour = getContourModel(4);
	
	}

	if (typeContour.compare("line")==0)
	{
		manModelContour = getContourModel(6);
	}
	
	if (typeContour.compare("points")==0)
	{
		manModelContour = getContourModel(7);
	}

	if (typeContour.compare("rotationTool")==0)
	{
		manModelContour = getContourModel(8);
	}
	
	if (typeContour.compare("polygon")==0)
	{
		manModelContour = getContourModel(10);
	}

	
	//JPReyes 13/04/2010
	//Spline 3D
	if (typeContour.compare("spline3D")==0)
	{
		manModelContour = getContourModel(12);
	}

	return manModelContour;
}
