/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef creaContoursFactory_h
#define creaContoursFactory_h

#include "manualBaseModel.h"
#include "manualViewBaseContour.h"
#include "manualContourBaseControler.h"


class creaMaracasVisu_EXPORT creaContoursFactory
{

//--------------------------- virtual ~manualBaseModel();------------------------
// PUBLIC METHODS & ATTS
//---------------------------------------------------

	public:
		creaContoursFactory();
		virtual ~creaContoursFactory();

		/* Creates the controler of the contour given the number of the contour*/
		manualContourBaseControler* getContourControler(int typeContour);

		/* Creates the controler of the contour given the name of the contour*/
		manualContourBaseControler* getContourControler(std::string typeContour);

		/* Creates the model of the contour given the number of the contour*/
		manualBaseModel* getContourModel(int typeContour);

		/* Creates the model of the contour given the name of the contour*/
		manualBaseModel* getContourModel(std::string typeContour);

		/* Creates the viewer of the contour given the number of the contour*/
		manualViewBaseContour* getCountourView(int typeContour);

		/* Creates the viezer of the contour given the name of the contour*/
		manualViewBaseContour* getCountourView(std::string typeContour);		
};

#endif
