/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualBaseModel.h"

// ----------------------------------------------------------------------------
manualBaseModel::manualBaseModel()
{
//EED2017
	_sizePointsContour	= 500;			//JSTG 25-02-08 The change in the inisialization of these variable is critical.
	_label				= "";
	_label2				= "--";
}

// ----------------------------------------------------------------------------
manualBaseModel::~manualBaseModel()
{
	int i,size=_lstPoints.size();
	for (i=0;i<size; i++)
	{
		delete _lstPoints[i];
	}
	_lstPoints.clear();

}
// ----------------------------------------------------------------------------
int manualBaseModel::AddPoint(double x,double y,double z)
{
   manualPoint *mp = new manualPoint();
   mp->SetPoint(x,y,z);
   AddManualPoint(mp);

   return _lstPoints.size()-1;
}
// ----------------------------------------------------------------------------
int manualBaseModel::InsertPoint(double x,double y,double z)
{
	double dd,ddmin=9999999;
	int    ibak=0;
	double xx,x1,x2;
	double yy,y1,y2;
	double zz,z1,z2;
	int i,ii,iii,size=_lstPoints.size();
	double j,MaxDivisions=20,porcentage;
	int sizeB=size;

	double jbak;

	for ( i=0 ; i<size ; i++ )
	{
		ii=i % sizeB ;
		iii=(i+1) % sizeB;
		x1=_lstPoints[ii]->GetX();
		y1=_lstPoints[ii]->GetY();
		z1=_lstPoints[ii]->GetZ();
		x2=_lstPoints[iii]->GetX();
		y2=_lstPoints[iii]->GetY();
		z2=_lstPoints[iii]->GetZ();
		for (j=0; j<=MaxDivisions; j++)
		{
			porcentage=(j/MaxDivisions);
			xx=(x2-x1)*porcentage+x1;
			yy=(y2-y1)*porcentage+y1;
			zz=(z2-z1)*porcentage+z1;
			dd=sqrt( (xx-x)*(xx-x) + (yy-y)*(yy-y) + (zz-z)*(zz-z) );
			if ( dd<ddmin )
			{
				ddmin=dd;
				ibak=iii;
				jbak=j;
			}
		}
	}

	InsertPoint_id(ibak,x,y,z);

	return ibak;
}
// ----------------------------------------------------------------------------
void manualBaseModel::InsertPoint_id(int id, double x, double y, double z)
{
	manualPoint *mp = new manualPoint();
	mp->SetPoint(x,y,z);
	std::vector<manualPoint*>::iterator itNum = _lstPoints.begin() + id;
	_lstPoints.insert(itNum,mp);
}
// ----------------------------------------------------------------------------

void manualBaseModel::DeletePoint(int i)
{
	std::vector<manualPoint*>::iterator itNum = _lstPoints.begin() + i;
   _lstPoints.erase(itNum);
}
// ----------------------------------------------------------------------------
void manualBaseModel::DeleteAllPoints()
{
	int i,size=_lstPoints.size();
	for (i=0;i<size;i++){
	   _lstPoints.erase( _lstPoints.begin() );
	}
}
// ----------------------------------------------------------------------------

void manualBaseModel::MovePoint(int i,double dx,double dy,double dz)
{
	manualPoint *mp=_lstPoints[i];
	double x=mp->GetX()+dx;
	double y=mp->GetY()+dy;
	double z=mp->GetZ()+dz;
	mp->SetPoint(x,y,z);
}
// ----------------------------------------------------------------------------
void manualBaseModel::MoveLstPoints(double dx,double dy,double dz)
{
	// ToDo
}
// ----------------------------------------------------------------------------
void manualBaseModel::MoveAllPoints(double dx,double dy,double dz)
{
	int i,size=_lstPoints.size();
	for (i=0;i<size;i++){
		MovePoint(i,dx,dy,dz);
	}
}

// ----------------------------------------------------------------------------
// type=-1  x,y,z
// type=0	y,z
// type=1	x,z
// type=2	x,y
int	 manualBaseModel::GetIdPoint(double x, double y, double z, int i_range,int type)
{
	double range = i_range+1;

	double xx,yy,zz,dd,ddmin=9999999;
	int ibak=-1;
	int i,size=_lstPoints.size();
	for (i=0;i<size;i++){
		manualPoint *mp=_lstPoints[i];
		xx=mp->GetX();
		yy=mp->GetY();
		zz=mp->GetZ();

		if (type==-1)
		{
			if ((fabs(xx-x)<range) && (fabs(yy-y)<range) && (fabs(zz-z)<range)) {
			   dd=sqrt(   (xx-x)*(xx-x) + (yy-y)*(yy-y) + (zz-z)*(zz-z) );
			   if (dd<ddmin){
				   ddmin=dd;
				   ibak=i;
			   }
			}
		}
		if (type==0)
		{
			if ((fabs(yy-y)<range) && (fabs(zz-z)<range)) {
			   dd=sqrt(   (yy-y)*(yy-y) + (zz-z)*(zz-z) );
			   if (dd<ddmin){
				   ddmin=dd;
				   ibak=i;
			   }
			}
		}
		if (type==1)
		{
			if ((fabs(xx-x)<range) && (fabs(zz-z)<range)) {
			   dd=sqrt(   (xx-x)*(xx-x)  + (zz-z)*(zz-z) );
			   if (dd<ddmin){
				   ddmin=dd;
				   ibak=i;
			   }
			}
		}
		if (type==2)
		{
			if ((fabs(xx-x)<range) && (fabs(yy-y)<range) ) {
			   dd=sqrt(   (xx-x)*(xx-x) + (yy-y)*(yy-y)  );
			   if (dd<ddmin){
				   ddmin=dd;
				   ibak=i;
			   }
			}
		}
	}
	return ibak;
}
// ----------------------------------------------------------------------------
int	 manualBaseModel::IsPoint(double x, double y)
{
	double xx,yy/*,zz*/;
	bool exists=false;
	int i,size=_lstPoints.size();
	for (i=0;i<size;i++){
		manualPoint *mp=_lstPoints[i];
		xx=mp->GetX();
		yy=mp->GetY();

		//RaC Be Careful!! Cast to have a point like the one in the params 27-09-09
		if(x==(int)xx && y==(int)yy )
		{
			exists=true;
		}
	}
	return exists;
}
// ----------------------------------------------------------------------------
manualPoint* manualBaseModel::GetManualPoint(int id)
{
	return _lstPoints[id];
}
// ----------------------------------------------------------------------------
int manualBaseModel::GetSizeLstPoints()
{
	return _lstPoints.size();
}

// ----------------------------------------------------------------------------
manualBaseModel * manualBaseModel :: Clone() // virtual
{
	manualBaseModel * clone = new manualBaseModel();
	CopyAttributesTo(clone);
	return clone;
}

// ----------------------------------------------------------------------------
int manualBaseModel::GetTypeModel() //virtual
{
	// 0 spline
	// 1 spline
	// 2 rectangle
	// 3 circle
	// 4 BullEye
	// 5 BullEyeSector
	// 6 Line
	// 7 Points
	return 7;
}

// ---------------------------------------------------------------------------

void manualBaseModel::CopyAttributesTo( manualBaseModel * cloneObject)
{
	int i, size = GetSizeLstPoints();
	for( i=0; i<size; i++ )
	{
		cloneObject->AddManualPoint( GetManualPoint( i )->Clone() );
	}
}

// ---------------------------------------------------------------------------
void manualBaseModel::AddManualPoint( manualPoint* theManualPoint )
{
	_lstPoints.push_back( theManualPoint );
}
// ---------------------------------------------------------------------------
void manualBaseModel::Open(FILE *ff)	// virtual
{
}
// ---------------------------------------------------------------------------
void manualBaseModel::Save(FILE *ff)	// virtual
{
}
// ---------------------------------------------------------------------------
void manualBaseModel::SaveData(FILE *ff)// virtual
{
}


// ---------------------------------------------------------------------------
void manualBaseModel::SetNumberOfPointsSpline(int size)
{
	_sizePointsContour = size;
}
// ---------------------------------------------------------------------------
double manualBaseModel::GetPathSize(double *spc)
{
	return 0.0;
}
// ---------------------------------------------------------------------------
void manualBaseModel::Transform_Ax_Plus_B (double Ax, double Bx, double Ay, double By)
{
}
// ---------------------------------------------------------------------------
void manualBaseModel::GetSpline_i_Point(int i, double *x, double *y, double *z)
{
	//RaC 20-09-09 IF it's a points contour
	if(GetTypeModel()==7){
		if (_lstPoints.size()==0)
		{
			*x	= 0;
			*y	= 0;
			*z	= 0;
		}
		else
		{
			manualPoint	*mp;
			mp	= _lstPoints[i];
			*x	= mp->GetX();
			*y	= mp->GetY();
			*z	= mp->GetZ();
		}
	}
}

void manualBaseModel::GetSpline_t_Point(double t, double *x, double *y, double *z)
{
}

// ---------------------------------------------------------------------------
int	manualBaseModel::GetNumberOfPointsSpline()
{

	//RaC 20-09-09 IF it's a points contour
	if(GetTypeModel()==7){
		return _lstPoints.size();
	}
	return _sizePointsContour;
}

// ---------------------------------------------------------------------------
void manualBaseModel::UpdateSpline()
{
}

// ---------------------------------------------------------------------------
std::vector<manualBaseModel*> manualBaseModel::ExploseModel(  )
{
	std::vector<manualBaseModel*> lstTmp;
	lstTmp.push_back(this);
	return lstTmp;
}

// ---------------------------------------------------------------------------
double manualBaseModel::GetPathArea( double *spc )
{
	return 0.0;
}
void manualBaseModel::GetNearestPointAndNormal(double *p, double *rp,  double *rn)
{
}
void manualBaseModel::SetCloseContour(bool closeContour)
{
}
bool manualBaseModel::IfCloseContour()
{
	return false;
}
//CMRU 17-08-09----------------------------------------------------------------------------

void manualBaseModel::SetRealSize(double newRealSize) 
{
}

double manualBaseModel::GetRealSize()
{
	return -1;
}

void manualBaseModel::OpenData(FILE *ff)
{
}

void manualBaseModel::SetLabel(std::string newLabel)
{
	_label = newLabel;
}

std::string manualBaseModel::GetLabel()
{
	return _label;
}

void manualBaseModel::SetLabel2(std::string newLabel)
{
	_label2 = newLabel;
}

std::string manualBaseModel::GetLabel2()
{
	return _label2;
}



//----------------------------------------------------------------------------
