/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef manualBaseModel_h
#define manualBaseModel_h

#include "vtkRenderWindow.h"

#include "vtkRenderer.h"
#include "vtkRenderWindowInteractor.h" //extremely important with VC++ don't remove !
#include "vtkCommand.h"
#include "vtkPolyData.h"
#include "vtkCellArray.h"
#include "vtkPolyDataMapper.h"
#include "vtkInteractorObserver.h"
#include "vtkInteractorStyleImage.h"
#include <vtkCellPicker.h> 
#include <vtkCamera.h> 
#include <vtkPolyLine.h>
#include <vtkDataSetMapper.h>
#include <vtkUnstructuredGrid.h>

#include "creawxVTKRenderWindowInteractor.h"

#include <vector>
#include "wxVtkBaseView.h"
#include "marTypes.h"
#include "manualPoint.h"

// --------------------------------------------------------------------------------------------
// Includes the functionality to manage a contour without the spline line usage
// @author RaC 09-09
class creaMaracasVisu_EXPORT manualBaseModel
{
public:
	manualBaseModel();
	virtual ~manualBaseModel();

	virtual manualBaseModel * Clone();
	void CopyAttributesTo( manualBaseModel *cloneObject );
	virtual void Open(FILE *ff);	// virtual
	virtual void Save(FILE *ff);	// virtual
	virtual int GetTypeModel();			// virtual 
	
	virtual void			SetNumberOfPointsSpline(int size);

	virtual int				AddPoint(double x,double y,double z);
	virtual int				InsertPoint(double x,double y,double z);
	virtual void			InsertPoint_id(int id, double x,double y,double z);
	virtual void			AddManualPoint( manualPoint* theManualPoint );
	virtual void			DeletePoint(int i);
	virtual void			DeleteAllPoints();

	virtual void			MovePoint(int i,double dx,double dy,double dz);
	virtual void			MoveLstPoints(double dx,double dy,double dz);
	virtual void			MoveAllPoints(double dx,double dy,double dz);

	// Returns the id of the point in the coordinates and the i_range given, according to the type
	// which corresponds to the plane where it's necessary to find the point.
	// @param type=-1  x,y,z - type=0 y,z - type=1	x,z - type=2	x,y
	// @return int - Returns the id of the point in the coordinates given. Returns -1 otherwise.
	virtual int				GetIdPoint(double x, double y, double z, int i_range,int type);
	virtual manualPoint*	GetManualPoint(int id);
	virtual int				GetSizeLstPoints();
	virtual double			GetPathSize(double *spc);
	virtual void			Transform_Ax_Plus_B (double Ax, double Bx, double Ay, double By);
	virtual void			GetSpline_i_Point(int i, double *x, double *y, double *z);
	virtual void			GetSpline_t_Point(double t, double *x, double *y, double *z);

	//
	// Returns the number of points of the spline line, but not the contour control points
	// @return int - spline points size
	//
	virtual int				GetNumberOfPointsSpline();
	virtual void			UpdateSpline();

	//
	// Returns a list with the actual model
	// @return std::vector<manualBaseModel*>
	//
	virtual std::vector<manualBaseModel*> ExploseModel(  );
	virtual double			GetPathArea(double *spc);
	virtual void			GetNearestPointAndNormal(double *p, double *rp,  double *rn);

	virtual void			SetCloseContour(bool closeContour);
	virtual bool			IfCloseContour();

	// RaC 27-09-09 ----

	//
	// Returns true if the point with the coordinates in parameters is one of the points in
	// the list of points of the model,
	// @param x double
	// @param y double
	// @return true if the point with the coordinates in parameters is one of the points, false otherwise
	//
	int	IsPoint(double x, double y);

	// CMRU 17-08-09 -----------------------------------------------------------------
	
	/*
	* Assigns the parameter value to the label
	* @param newLabel New label of the contour
	*/
	void SetLabel(std::string newLabel);
	std::string GetLabel();
	void SetLabel2(std::string newLabel);
	std::string GetLabel2();
	
	/*
	* Assigns the parameter value to the real size
	* @param newRealSize New real size in milimeters of the contour
	*/
	virtual void SetRealSize(double newRealSize);
	

	/**
	* Returns the real size in milimeters of the contour
	*/
	virtual double GetRealSize();
	
	/*
	* Saves the label and the real size of the contour
	* @param ff File where the information is stored 
	*/
	virtual void SaveData(FILE *ff);
 
	/*
	* Reads and interprets the information of the label and the real size
	* @param ff File where the information is readed 
	*/
	virtual void OpenData(FILE *ff);

protected:
	int							_sizePointsContour;
	std::vector<manualPoint*>	_lstPoints;

	/**
	* Represents the label associated with the contour
	*/
	std::string					_label;
	std::string					_label2;

}; 


#endif // manualBaseModel_h
