/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualContour3DControler.h"


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

manualContour3DControler::manualContour3DControler()
{
}
// ----------------------------------------------------------------------------
manualContour3DControler::~manualContour3DControler()
{
}
// ----------------------------------------------------------------------------
manualContour3DControler * manualContour3DControler :: Clone()  // virtual
{
	manualContour3DControler * clone = new manualContour3DControler();
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------
void manualContour3DControler::CopyAttributesTo( manualContour3DControler * cloneObject)
{
	// Fathers object
	manualContourControler::CopyAttributesTo(cloneObject);

	cloneObject->SetVtkMPRBaseData( this->GetVtkMPRBaseData() );
}

// ----------------------------------------------------------------------------
bool  manualContour3DControler::OnLeftButtonDown()
{
	int X,Y;
	crea::wxVTKRenderWindowInteractor *wxVTKiren;
	wxVTKiren = _vtkInteractorStyleBaseView->GetWxVtk3DBaseView()->GetWxVTKRenderWindowInteractor();
	wxVTKiren->GetEventPosition(X,Y);
 	MouseClickLeft(X,Y);
	return true;
}
// ----------------------------------------------------------------------------
void manualContour3DControler::ResetOrientationPlane()
{
	double p[3],rp[3],rn[3];
	p[0] = this->GetVtkMPRBaseData()->GetX(  );
	p[1] = this->GetVtkMPRBaseData()->GetY(  );
	p[2] = this->GetVtkMPRBaseData()->GetZ(  );
	this->GetManualContourModel()->GetNearestPointAndNormal(p,rp,rn);
	this->GetVtkMPRBaseData()->SetNormal(rn[0],rn[1],rn[2]);
}
// ----------------------------------------------------------------------------
void manualContour3DControler::MouseClickLeft(int x, int y) // virtual
{
	manualView3DContour *manualview3Dcontour=(manualView3DContour*)GetManualViewBaseContour();
	int id=manualview3Dcontour->GetIdPoint2(x,y);
	if ( (GetState()==0) && (id!=-1) )
	{
		manualPoint *mp = this->GetManualContourModel()->GetManualPoint(id);

		this->GetVtkMPRBaseData()->SetX( mp->GetX() );
		this->GetVtkMPRBaseData()->SetY( mp->GetY() );
		this->GetVtkMPRBaseData()->SetZ( mp->GetZ() );
		ResetOrientationPlane();
		this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();
	}


	manualContourControler::MouseClickLeft(x,y);

}
// ----------------------------------------------------------------------------
bool manualContour3DControler::OnChar()
{
	bool ok=true;
	manualContourControler::OnChar();
	char keyCode = _vtkInteractorStyleBaseView->GetInteractor()-> GetKeyCode();
	if (keyCode==32){
		ok=false;
		ResetOrientationPlane();
		this->_vtkInteractorStyleBaseView->SetRefresh_waiting();
	}
	return ok;
}

// ----------------------------------------------------------------------------
void manualContour3DControler::SetVtkMPRBaseData (vtkMPRBaseData *vtkmprbasedata )
{
	_vtkmprbasedata=vtkmprbasedata;
}
// ----------------------------------------------------------------------------
vtkMPRBaseData *manualContour3DControler::GetVtkMPRBaseData()
{
	return _vtkmprbasedata;
}

// ----------------------------------------------------------------------------
void manualContour3DControler::InsertPoint(int x, int y, int z ) // virtual
{
	manualContourControler::InsertPoint(  x,  y,  z );
	ResetOrientationPlane();
}

