/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualContour3V3DControler.h"


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

manualContour3V3DControler::manualContour3V3DControler()
  :
_manualcontour3Vcontroler(NULL)
{
}
// ----------------------------------------------------------------------------
manualContour3V3DControler::~manualContour3V3DControler()
{
}

// ----------------------------------------------------------------------------
manualContour3V3DControler * manualContour3V3DControler :: Clone()  // virtual
{
	manualContour3V3DControler * clone = new manualContour3V3DControler();
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------
void manualContour3V3DControler::CopyAttributesTo( manualContour3V3DControler * cloneObject)
{
	// Fathers object
	manualContour3DControler::CopyAttributesTo(cloneObject);

	cloneObject->SetManualContour3VControler( this->GetManualContour3VControler() );
}
// ----------------------------------------------------------------------------
void manualContour3V3DControler::InsertPoint(int x, int y, int z ) // virtual
{
	manualContour3DControler::InsertPoint(  x,  y,  z );
	_manualcontour3Vcontroler->InsertPoint_Others(0);
}
// ----------------------------------------------------------------------------
void manualContour3V3DControler::AddPoint( int x, int y, int z )
{
	manualContour3DControler::AddPoint(  x,  y,  z );
	if (_manualcontour3Vcontroler!=NULL)
	{
		_manualcontour3Vcontroler->AddPoint_Others();
	}
}
// ----------------------------------------------------------------------------
void manualContour3V3DControler::DeleteActualMousePoint(int x, int y)
{
	int id = GetManualViewBaseContour()->GetIdPoint ( x , y , GetZ() );
	manualContour3DControler::DeleteActualMousePoint( x , y );
	_manualcontour3Vcontroler->DeleteActualMousePoint_Others(id);
}
// ----------------------------------------------------------------------------
void manualContour3V3DControler::MouseMove( int x, int y )
{
	int ss =this->_vtkInteractorStyleBaseView->vtkInteractorStyle::GetState();
	if ((this->GetState()!=7) && (ss!=1)){
		manualContour3DControler::MouseMove( x , y );
		int id = GetManualViewBaseContour()->GetIdPoint ( x , y , GetZ() );
		if (_manualcontour3Vcontroler!=NULL)
		{
			_manualcontour3Vcontroler->MouseMove_Others(id);
		}
	}
}
// ----------------------------------------------------------------------------
void manualContour3V3DControler::SetManualContour3VControler(manualContour3VControler *manualcontour3Vcontroler)
{
	_manualcontour3Vcontroler = manualcontour3Vcontroler;
}
// ----------------------------------------------------------------------------
manualContour3VControler *manualContour3V3DControler::GetManualContour3VControler()
{
	return _manualcontour3Vcontroler;
}
// ----------------------------------------------------------------------------
bool manualContour3V3DControler::OnChar() // virtual
{
	if (manualContour3DControler::OnChar()==false )
	{
		_manualcontour3Vcontroler->OnChar_Others();
	}
	return true;
}

// ----------------------------------------------------------------------------
void manualContour3V3DControler::ResetContour() // virtual
{
	manualContourControler::ResetContour();
	_manualcontour3Vcontroler->ResetContour_Others();
}

