/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualContour3VControler.h"

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

// _type = 0  Sagital
// _type = 1  Coronal
// _type = 2  Axial
// _type = -1 View 3D

manualContour3VControler::manualContour3VControler(int type)
{
	_type=type;

//EEDhh
//	_manViewBaseCont1 = NULL;
//	_manViewBaseCont2 = NULL;
//	_manViewBaseCont3 = NULL;
}
//----------------------------------------------------------------------------
manualContour3VControler::~manualContour3VControler()
{
}

// ----------------------------------------------------------------------------
manualContour3VControler * manualContour3VControler :: Clone()  // virtual
{
	manualContour3VControler * clone = new manualContour3VControler( this->GetType() );
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------
void manualContour3VControler::CopyAttributesTo( manualContour3VControler * cloneObject)
{
	// Fathers object
	manualContourControler::CopyAttributesTo(cloneObject);

	cloneObject->SetVtkMPRBaseData( this->GetVtkMPRBaseData() );

	// Remember to add ManualViewBaseContour with "AddManualViewBaseContour"

}
// ----------------------------------------------------------------------------
int manualContour3VControler::GetType()
{
	return _type;
}

// ----------------------------------------------------------------------------
void manualContour3VControler::AddPoint_Others()
{
	manualViewBaseContour *mvbc;
	int i,size=this->_lstManualViewBaseContour.size();
	for ( i = 0 ; i < size ; i++ )
	{
		mvbc = _lstManualViewBaseContour[i];
		mvbc->AddPoint();
	}

// EEDhh
//	if (_manViewBaseCont1!=NULL){
//		_manViewBaseCont1->AddPoint();
//		_manViewBaseCont2->AddPoint();
//		_manViewBaseCont3->AddPoint();
//		this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();
//	}

	this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();
}
// ----------------------------------------------------------------------------
void manualContour3VControler::AddPoint( int x, int y, int z ) // virtual
{

	z=(int)_vtkmprbasedata->GetZ();
	if (GetManualContourModel()!=NULL){
		double	xx	= x;
		double	yy	= y;
		double	zz	= z;
		GetManualViewBaseContour()->TransfromCoordViewWorld(xx,yy,zz,_type);

		if (_type==0)
		{
			xx=_vtkmprbasedata->GetX();
		}

		if (_type==1)
		{
			yy=_vtkmprbasedata->GetY();
		}


		/*int	id		= */ GetManualContourModel()->AddPoint(xx,yy,zz);  // JPRx
		GetManualViewBaseContour()->AddPoint();
		AddPoint_Others();

	}
}

// ----------------------------------------------------------------------------
void manualContour3VControler::InsertPoint_Others(int id)
{

	manualViewBaseContour *mvbc;
	int i,size=this->_lstManualViewBaseContour.size();
	for ( i = 0 ; i < size ; i++ )
	{
		mvbc = _lstManualViewBaseContour[i];
		mvbc->InsertPoint(id);
	}

/*EEDhh
	if (_manViewBaseCont1!=NULL){
		_manViewBaseCont1->InsertPoint(id);
		_manViewBaseCont2->InsertPoint(id);
		_manViewBaseCont3->InsertPoint(id);
		this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();
	}
*/

	this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();

}
// ----------------------------------------------------------------------------
void manualContour3VControler::InsertPoint(int x, int y, int z)
{
	int id=-1;
	if (GetManualContourModel()!=NULL){
		if (GetManualContourModel()->GetSizeLstPoints()>1){
			z=(int)_vtkmprbasedata->GetZ();
			double				xx		= x;
			double				yy		= y;
			double				zz		= z;
			GetManualViewBaseContour()->TransfromCoordViewWorld(xx,yy,zz,_type);
			if (_type==0)
			{
				xx=_vtkmprbasedata->GetX();
			}

			if (_type==1)
			{
				yy=_vtkmprbasedata->GetY();
			}

			id	= GetManualContourModel()->InsertPoint(xx,yy,zz);

			GetManualViewBaseContour()->InsertPoint(id);
			InsertPoint_Others(0);

		} else {
			AddPoint(x,y,z);
		}
	}
}
// ----------------------------------------------------------------------------

// EEDhh
/*
void manualContour3VControler::SetModelView (	manualContourModel *manContModel,
												manualViewBaseContour *manViewBaseCont0,
												manualViewBaseContour *manViewBaseCont1,
												manualViewBaseContour *manViewBaseCont2,
												manualViewBaseContour *manViewBaseCont3)
{
	manualContourControler::SetModelView(manContModel,manViewBaseCont0);
	_manViewBaseCont1 = manViewBaseCont1;
	_manViewBaseCont2 = manViewBaseCont2;
	_manViewBaseCont3 = manViewBaseCont3;
}
*/

// ----------------------------------------------------------------------------
void manualContour3VControler::AddManualViewBaseContour( manualViewBaseContour *manViewBaseCont )
{
	_lstManualViewBaseContour.push_back( manViewBaseCont );
}

// ----------------------------------------------------------------------------
void manualContour3VControler::SetVtkMPRBaseData (vtkMPRBaseData *vtkmprbasedata )
{
	_vtkmprbasedata=vtkmprbasedata;
}
// ----------------------------------------------------------------------------
vtkMPRBaseData *manualContour3VControler::GetVtkMPRBaseData()
{
	return _vtkmprbasedata;
}
// ----------------------------------------------------------------------------
void manualContour3VControler::SetPoint( int id ,int x ,int y ,int z ) // virtual
{
	z=(int)_vtkmprbasedata->GetZ();
	if ((GetManualViewBaseContour()!=NULL) && (id>=0)){
		double xx = x;
		double yy = y;
		double zz = z;
		GetManualViewBaseContour()->TransfromCoordViewWorld(xx,yy,zz,_type);

		if (_type==0)
		{
			xx=_vtkmprbasedata->GetX();
		}
		if (_type==1)
		{
			yy=_vtkmprbasedata->GetY();
		}

		manualPoint	*mp	= GetManualContourModel()->GetManualPoint(id);
		mp->SetPoint(xx,yy,zz);

	}
}
// ----------------------------------------------------------------------------
void manualContour3VControler::DeleteActualMousePoint_Others(int id)
{
	manualViewBaseContour *mvbc;
	int i,size=this->_lstManualViewBaseContour.size();
	for ( i = 0 ; i < size ; i++ )
	{
		mvbc = _lstManualViewBaseContour[i];
		mvbc->DeletePoint(id);
		mvbc->Refresh();
	}

/*
	if (_manViewBaseCont1!=NULL){
		_manViewBaseCont1->DeletePoint(id);
		_manViewBaseCont2->DeletePoint(id);
		_manViewBaseCont3->DeletePoint(id);

		_manViewBaseCont1->Refresh();
		_manViewBaseCont2->Refresh();
		_manViewBaseCont3->Refresh();

		this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();
	}
*/
	this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();
}
// ----------------------------------------------------------------------------
void manualContour3VControler::DeleteActualMousePoint(int x, int y)// virtual
{
	int id=GetManualViewBaseContour()->GetIdPoint ( x , y , GetZ() );
	if (id!=-1){
		manualContourBaseControler::DeleteActualMousePoint( x , y );
		DeleteActualMousePoint_Others( id );
	}
}
// ----------------------------------------------------------------------------
void manualContour3VControler::MouseMove_Others(int id) // virtual
{
	manualViewBaseContour *mvbc;
	int i,size=this->_lstManualViewBaseContour.size();
	for ( i = 0 ; i < size ; i++ )
	{
		mvbc = _lstManualViewBaseContour[i];
		mvbc->SelectAllPossibleSelected(false);
		if (id!=-1)
		{
			mvbc->SetPointPosibleSelected(id,true);
		}
		mvbc->SetPosibleSelected  (  GetManualViewBaseContour()->GetPosibleSelected()  );
		mvbc->Refresh();
	}

// EEDhh
/*
	if (_manViewBaseCont1!=NULL){
		_manViewBaseCont1->SelectAllPossibleSelected(false);
		_manViewBaseCont2->SelectAllPossibleSelected(false);
		_manViewBaseCont3->SelectAllPossibleSelected(false);
		if (id!=-1){
			_manViewBaseCont1->SetPointPosibleSelected(id,true);
			_manViewBaseCont2->SetPointPosibleSelected(id,true);
			_manViewBaseCont3->SetPointPosibleSelected(id,true);
		}
		_manViewBaseCont1->SetPosibleSelected  (  GetManualViewBaseContour()->GetPosibleSelected()  );
		_manViewBaseCont2->SetPosibleSelected  (  GetManualViewBaseContour()->GetPosibleSelected()  );
		_manViewBaseCont3->SetPosibleSelected  (  GetManualViewBaseContour()->GetPosibleSelected()  );

		_manViewBaseCont1->Refresh();
		_manViewBaseCont2->Refresh();
		_manViewBaseCont3->Refresh();

		this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();
	}
*/
	this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();

}

// ----------------------------------------------------------------------------
void manualContour3VControler::MouseMove(int x, int y) // virtual
{
	manualContourControler::MouseMove( x , y );
	int id=GetManualViewBaseContour()->GetIdPoint(x,y,GetZ());
	MouseMove_Others( id );
}

// ----------------------------------------------------------------------------
void manualContour3VControler::OnChar_Others()
{
	manualViewBaseContour *mvbc;
	int i,size=this->_lstManualViewBaseContour.size();
	for ( i = 0 ; i < size ; i++ )
	{
		mvbc = _lstManualViewBaseContour[i];
		mvbc->Refresh();
	}
// EEDhh
/*
		_manViewBaseCont1->Refresh();
		_manViewBaseCont2->Refresh();
		_manViewBaseCont3->Refresh();
*/
	this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();
}
// ----------------------------------------------------------------------------
bool manualContour3VControler::OnChar()
{
	manualContourControler::OnChar();
	OnChar_Others();
	return true;
}
// ----------------------------------------------------------------------------
void manualContour3VControler::ResetContour() // virtual
{
	manualContourControler::ResetContour();
	ResetContour_Others();
}

// ----------------------------------------------------------------------------
void manualContour3VControler::ResetContour_Others()
{
	manualViewBaseContour *mvbc;
	int i,size=this->_lstManualViewBaseContour.size();
	for ( i = 0 ; i < size ; i++ )
	{
		mvbc = _lstManualViewBaseContour[i];
		mvbc->DeleteContour();
		mvbc->CreateNewContour();
	}

// EEDhh
/*
	_manViewBaseCont1->DeleteContour();
	_manViewBaseCont2->DeleteContour();
	_manViewBaseCont3->DeleteContour();
	_manViewBaseCont1->CreateNewContour();
	_manViewBaseCont2->CreateNewContour();
	_manViewBaseCont3->CreateNewContour();
*/
}

