/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualContourBaseControler.h"


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

manualContourBaseControler::manualContourBaseControler()
{
	_manViewBaseCont	= NULL;
	_manContModel		= NULL;
	_state				= 0;
	
//EED 21 mars 2012  FLIP probleme  ..PLOP..
//	_z					= 900;
	_z					= -900;
	
	_editable			= true;
	_posibleToMove		= true;
	_moving				= false;
	_created			= false;
	_keyBoardMoving		= false;
}
// ----------------------------------------------------------------------------
manualContourBaseControler::~manualContourBaseControler()
{
}

// ----------------------------------------------------------------------------
manualContourBaseControler * manualContourBaseControler :: Clone()  // virtual
{
	manualContourBaseControler * clone = new manualContourBaseControler();
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------

void manualContourBaseControler::CopyAttributesTo( manualContourBaseControler * cloneObject)
{
	// Fathers object
	InteractorStyleMaracas::CopyAttributesTo(cloneObject);
	cloneObject->SetZ( this->GetZ() );
	cloneObject->SetState( this->GetState() );
	cloneObject->SetEditable( this->IsEditable() );
	cloneObject->SetPosibleToMove( this->GetPosibleToMove() );
	cloneObject->SetMoving( this->IsMoving() );
	cloneObject->SetCompleteCreation( this->GetIfCompleteCreation() );
	cloneObject->SetKeyBoardMoving( this->GetKeyBoardMoving() );
}

// ----------------------------------------------------------------------------
void manualContourBaseControler::Configure() //virtual
{
}

// ----------------------------------------------------------------------------
bool manualContourBaseControler::OnChar()
{
	if ( _vtkInteractorStyleBaseView!=NULL )
	{
		char keyCode = _vtkInteractorStyleBaseView->GetInteractor()-> GetKeyCode();

		int X,Y;
		crea::wxVTKRenderWindowInteractor *_wxVTKiren;
		_wxVTKiren= _vtkInteractorStyleBaseView->GetWxVtk2DBaseView()->GetWxVTKRenderWindowInteractor();
		_wxVTKiren->GetEventPosition(X, Y);
		//int Z = GetZ(); // JPRx
		// Delete Point
		if ((keyCode==8) || (keyCode==127))
		{

			if (!GetManualViewBaseContour()->GetPosibleSelected()==true)
			{
				DeleteActualMousePoint(X,Y);
			}
			GetManualViewBaseContour()->Refresh();
			this->_vtkInteractorStyleBaseView->SetRefresh_waiting();
		}
		else
		{
			// Magnet
			if (keyCode==32)
			{
				Magnet(X,Y);
				GetManualViewBaseContour()->Refresh();
				this->_vtkInteractorStyleBaseView->SetRefresh_waiting();
			}
			else if( !IsEditable() )
			{
				if ( keyCode == 'L' )
				{
					GetManualViewBaseContour()->MoveContour( -1, 0 );
					SetKeyBoardMoving( true );
				}
				else if ( keyCode == 'R' )
				{
					GetManualViewBaseContour()->MoveContour( 1, 0 );
					SetKeyBoardMoving( true );
				}
				else if ( keyCode == 'U' )
				{
					GetManualViewBaseContour()->MoveContour( 0, -1 );
					SetKeyBoardMoving( true );
				}
				else if ( keyCode == 'D' )
				{
					GetManualViewBaseContour()->MoveContour( 0, 1 );
					SetKeyBoardMoving( true );
				}
				else if ( keyCode == 'W' )//Diagonal left down
				{
					GetManualViewBaseContour()->MoveContour( -1, 1 );
					SetKeyBoardMoving( true );
				}
				else if ( keyCode == 'Q' )//Diagonal left up
				{
					GetManualViewBaseContour()->MoveContour( -1, -1 );
					SetKeyBoardMoving( true );
				}
				else if( keyCode == 'P' )//Diagonal right up
				{
					GetManualViewBaseContour()->MoveContour( 1, -1 );
					SetKeyBoardMoving( true );
				}
				else if( keyCode == 'M' )//Diagonal right down
				{
					GetManualViewBaseContour()->MoveContour( 1, 1 );
					SetKeyBoardMoving( true );
				}
				if( GetKeyBoardMoving() )
				{
					GetManualViewBaseContour()->Refresh();
					this->_vtkInteractorStyleBaseView->SetRefresh_waiting();
				}
			}
		}
	}
	return true;
}
// ----------------------------------------------------------------------------
bool manualContourBaseControler::OnMouseMove()
{
	if ( _vtkInteractorStyleBaseView!=NULL)
	{
		int X,Y;
		crea::wxVTKRenderWindowInteractor *_wxVTKiren;
		_wxVTKiren= _vtkInteractorStyleBaseView->GetWxVtk2DBaseView()->GetWxVTKRenderWindowInteractor();
		_wxVTKiren->GetEventPosition( X , Y );

		if ( (_vtkInteractorStyleBaseView->GetInteractor()->GetControlKey()==0) &&
	 		(_vtkInteractorStyleBaseView->GetInteractor()->GetShiftKey()==0) ) {
			MouseMove(X,Y);
		}
	}
	return true;
}
// ----------------------------------------------------------------------------
bool manualContourBaseControler::OnLeftButtonDown()
{
	SetKeyBoardMoving( false );
	if ( _vtkInteractorStyleBaseView!=NULL )
	{
		int X,Y;
		crea::wxVTKRenderWindowInteractor *wxVTKiren;
		wxVTKiren = _vtkInteractorStyleBaseView->GetWxVtk2DBaseView()->GetWxVTKRenderWindowInteractor();
		wxVTKiren->GetEventPosition(X,Y);

		MouseClickLeft(X,Y);
	}
	return true;
}
// ----------------------------------------------------------------------------
bool manualContourBaseControler::OnLeftButtonUp()
{
	if ( _vtkInteractorStyleBaseView!=NULL )
	{
		int X,Y;
		crea::wxVTKRenderWindowInteractor *wxVTKiren;
		wxVTKiren = _vtkInteractorStyleBaseView->GetWxVtk2DBaseView()->GetWxVTKRenderWindowInteractor();
		wxVTKiren->GetEventPosition(X,Y);
		MouseReleaseLeft(X,Y);
	}
	return true;
}
// ----------------------------------------------------------------------------
bool manualContourBaseControler::OnLeftDClick()
{
	if ( _vtkInteractorStyleBaseView!=NULL )
	{
		int X,Y;
		crea::wxVTKRenderWindowInteractor *wxVTKiren;
		wxVTKiren = _vtkInteractorStyleBaseView->GetWxVtk2DBaseView()->GetWxVTKRenderWindowInteractor();
		wxVTKiren->GetEventPosition(X,Y);

		this->MouseDLeft(X,Y);
	}
	return true;
}
// ----------------------------------------------------------------------------
bool manualContourBaseControler::OnMiddleButtonDown()
{
//	SetKeyBoardMoving( false );
	if ( _vtkInteractorStyleBaseView!=NULL )
	{
		int X,Y;
		crea::wxVTKRenderWindowInteractor *wxVTKiren;
		wxVTKiren = _vtkInteractorStyleBaseView->GetWxVtk2DBaseView()->GetWxVTKRenderWindowInteractor();
		wxVTKiren->GetEventPosition(X,Y);
		GetManualViewBaseContour()->InitMove( X, Y,GetZ());
	}
	return true;
}
// ----------------------------------------------------------------------------
bool manualContourBaseControler::OnMiddleButtonUp()
{
	return true;
}
// ----------------------------------------------------------------------------
bool manualContourBaseControler::OnRightButtonDown()
{
	if( _vtkInteractorStyleBaseView!= NULL )
	{
		int X,Y;
		crea::wxVTKRenderWindowInteractor *wxVTKiren;
		wxVTKiren = _vtkInteractorStyleBaseView->GetWxVtk2DBaseView()->GetWxVTKRenderWindowInteractor();
		wxVTKiren->GetEventPosition(X, Y);

		MouseClickRight(X,Y);
	}
	return true;
}
// ----------------------------------------------------------------------------
bool manualContourBaseControler::OnRightButtonUp()
{
	return true;
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::SetModelView(manualBaseModel *manContModel, manualViewBaseContour *manViewBaseCont){
	_manContModel		=	manContModel;
	_manViewBaseCont	=	manViewBaseCont;
	_manViewBaseCont->SetEditable( &_editable );
}
// ----------------------------------------------------------------------------
manualBaseModel* manualContourBaseControler::GetManualContourModel()
{
	return _manContModel;
}
// ----------------------------------------------------------------------------
manualViewBaseContour* manualContourBaseControler::GetManualViewBaseContour()
{
	return _manViewBaseCont;
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::MouseClickLeft(int x, int y) // virtual
{

}
// ----------------------------------------------------------------------------
void manualContourBaseControler::MouseClickRight(int x, int y)
{
	SetCompleteCreation( true );
	SetKeyBoardMoving( false );
	this->GetManualContourModel()->SetCloseContour(true);

//	if (_state==1)
//	{
//		_state=0;
//	}
	SetEditable( false );
	SetPosibleToMove( false );
	_state = 0;

//EED 24Avril2009	_state=7;
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::MouseReleaseLeft(int x, int y)
{
	if (_state==5){ _state = 0; }
	if (_state==6){ _state = 0; }
	if (_state==7){ _state = 0; }
	SetMoving( false );
	GetManualViewBaseContour()->SelectPosibleContour(x,y,GetZ());
	if( GetIfCompleteCreation() && IsEditable() && !GetManualViewBaseContour()->GetPosibleSelected() && (GetManualViewBaseContour()->GetIdPoint(x,y,GetZ())==-1)  )
	{
		SetEditable( false );
		SetPosibleToMove( false );
	}
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::MouseDLeft(int x, int y )
{
	if (_state==0)
	{

		int z=GetZ();
		/*bool temp = */ _manViewBaseCont->SelectPosibleContour(x,y,z);

		_manViewBaseCont->SelectPosiblePoint(x,y,z);

		if ( _manViewBaseCont->GetPosibleSelected() )
		{
			_editable = true;
		}
	}
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::MouseMove(int x, int y) // virtual
{
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::SetState(int state)
{
	_state=state;
}
// ----------------------------------------------------------------------------
int manualContourBaseControler::GetState()
{
	return _state;
}
// ----------------------------------------------------------------------------
bool manualContourBaseControler::IsEditable( )
{
	return _editable;
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::SetEditable(  bool condition  )
{
	if (GetManualViewBaseContour()!=NULL) {
		if( !condition )
		{
			GetManualViewBaseContour()->RemoveControlPoints();
		}
		GetManualViewBaseContour()->SetSelected( condition );
	}
	_editable = condition;
}

// ----------------------------------------------------------------------------
bool manualContourBaseControler::GetPosibleToMove()
{
	return _posibleToMove;
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::SetPosibleToMove( bool condition )
{
	_posibleToMove = condition;
}
// ----------------------------------------------------------------------------
bool manualContourBaseControler::IsMoving()
{
	return _moving;
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::SetMoving( bool condition )
{
	_moving = condition;
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::SetCompleteCreation( bool condition )
{
	_created = condition;
}
// ----------------------------------------------------------------------------
bool manualContourBaseControler::GetIfCompleteCreation ( )
{
	return _created;
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::SetKeyBoardMoving( bool condition )
{
	_keyBoardMoving = condition;
}
// ----------------------------------------------------------------------------
bool manualContourBaseControler::GetKeyBoardMoving(  )
{
	return _keyBoardMoving;
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::CreateNewManualContour(){
	_manViewBaseCont->CreateNewContour();
}
// ----------------------------------------------------------------------------
int	manualContourBaseControler::GetNumberOfPointsManualContour(){
	return _manViewBaseCont->GetNumberOfPoints();
}
// ----------------------------------------------------------------------------

//JSTG - 25-02-08 -------------------------------------------------------------
int	manualContourBaseControler::GetNumberOfPointsSplineManualContour(){
	//return _manViewBaseCont->GetNumberOfPointsSpline();
	return _manContModel->GetNumberOfPointsSpline();
}
// ----------------------------------------------------------------------------

double* manualContourBaseControler::GetVectorPointsXManualContour(){
	return _manViewBaseCont->GetVectorPointsXManualContour();
}
// ----------------------------------------------------------------------------
double* manualContourBaseControler::GetVectorPointsYManualContour(){
	return _manViewBaseCont->GetVectorPointsYManualContour();
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::DeleteContour(){
	_manViewBaseCont->DeleteContour();
	_manContModel->DeleteAllPoints();
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::DeleteActualMousePoint(int x, int y)// virtual
{
	if ((_manContModel!=NULL) && (_manViewBaseCont!=NULL) )
	{
		int id=_manViewBaseCont->GetIdPoint(x,y,GetZ());
		if ((id!=-1) && (_manContModel->GetSizeLstPoints()>2) ){
			_manContModel->DeletePoint(id);
			_manViewBaseCont->DeletePoint(id);
		}
	}
	_state = 0;
}

// ----------------------------------------------------------------------------
void manualContourBaseControler::Magnet(int x, int y)
{
	if( IsEditable())
	{
		/*int id= */ _manViewBaseCont->GetIdPoint(x,y,GetZ()); // JPRx
		if (GetManualContourModel()!=NULL){
			double	xx	= x;
			double	yy	= y;
			double	zz	= GetZ();
			GetManualViewBaseContour()->TransfromCoordViewWorld(xx,yy,zz);
			int			id	= GetManualContourModel()->GetIdPoint(xx,yy,zz,32000,-1);
			if (id!=-1)
			{
				manualPoint	*mp	= GetManualContourModel()->GetManualPoint(id);
				mp->SetPoint(xx,yy,zz);
			}
	//		GetManualViewBaseContour()->UpdateViewPoint(id);
		}
		_state = 0;
	}
}

// ----------------------------------------------------------------------------
void manualContourBaseControler::SetZ(int z)
{
	_z=z;
}
// ----------------------------------------------------------------------------
int manualContourBaseControler::GetZ()
{
	return _z;
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::AddPoint(int x, int y, int z) // virtual
{
	if (GetManualContourModel()!=NULL){
		double	xx	= x;
		double	yy	= y;
		double	zz	= z;

		GetManualViewBaseContour()->TransfromCoordViewWorld(xx,yy,zz);
		GetManualContourModel()->AddPoint(xx,yy,zz);
		GetManualViewBaseContour()->AddPoint();
//		GetManualViewBaseContour()->UpdateViewPoint(id);
	}
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::InsertPoint(int x,int y,int z)  // virtual
{
//EEDzz
	int id=-1;
	if (GetManualContourModel()!=NULL){
		double				xx		= x;
		double				yy		= y;
		double				zz		= z;
		GetManualViewBaseContour()->TransfromCoordViewWorld(xx,yy,zz);
		if (GetManualContourModel()->GetSizeLstPoints()>1){
			id = GetManualContourModel()->InsertPoint(xx,yy,zz);
			GetManualViewBaseContour()->InsertPoint(id);
//			GetManualViewBaseContour()->UpdateViewPoint(id);
		} else {
			GetManualContourModel()->AddPoint(xx,yy,zz);
			GetManualViewBaseContour()->AddPoint();
//			AddPoint(x,y,z);
//			GetManualViewBaseContour()->UpdateViewPoint(id);
		}
	}
}

// ----------------------------------------------------------------------------
void manualContourBaseControler::SetPoint( int id ,int x , int y , int z){ // virtual
	if ((GetManualViewBaseContour()!=NULL) && (id>=0)){
		double xx = x;
		double yy = y;
		double zz = z;

		GetManualViewBaseContour()->TransfromCoordViewWorld(xx,yy,zz);
		manualPoint		*mp		= _manContModel->GetManualPoint(id);
		mp->SetPoint(xx,yy,zz);
		GetManualViewBaseContour()->UpdateViewPoint(id);
	}
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::SetPointX( int id ,int x  ){
	if ((GetManualViewBaseContour()!=NULL) && (id>=0)){
		double xx = x;
		double yy = 0;
		double zz = 0;
		GetManualViewBaseContour()->TransfromCoordViewWorld(xx,yy,zz);
		manualPoint		*mp		= _manContModel->GetManualPoint(id);
		mp->SetPointX(xx);
		GetManualViewBaseContour()->UpdateViewPoint(id);
	}
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::SetPointY( int id ,int y  ){
	if ((GetManualViewBaseContour()!=NULL) && (id>=0)){
		double xx = 0;
		double yy = y;
		double zz = 0;
		GetManualViewBaseContour()->TransfromCoordViewWorld(xx,yy,zz);
		manualPoint		*mp		= _manContModel->GetManualPoint(id);
		mp->SetPointY(yy);
		GetManualViewBaseContour()->UpdateViewPoint(id);
	}
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::SetPointZ( int id ,int z  ){
	if ((GetManualViewBaseContour()!=NULL) && (id>=0)){
		double xx = 0;
		double yy = 0;
		double zz = z;
		GetManualViewBaseContour()->TransfromCoordViewWorld(xx,yy,zz);
		manualPoint		*mp		= _manContModel->GetManualPoint(id);
		mp->SetPointZ(zz);
		GetManualViewBaseContour()->UpdateViewPoint(id);
	}
}
// ----------------------------------------------------------------------------
void manualContourBaseControler::ResetContour() // virtual
{
 	this->DeleteContour();
	GetManualViewBaseContour()->CreateNewContour();
	this->SetState(0);
}

