/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualContourControler.h"

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

// _state = 0  // ..nothing..
// _state = 1  // move with add point
// _state = 5  // move
// _state = 6  // move with insert point
// _state = 7  // move with non selection

manualContourControler::manualContourControler()
{
	_easyCreation = true;

}
// ----------------------------------------------------------------------------
manualContourControler::~manualContourControler()
{
}
// ----------------------------------------------------------------------------
manualContourControler * manualContourControler :: Clone()  // virtual
{
	manualContourControler * clone = new manualContourControler();
	CopyAttributesTo(clone);
	return clone;
}
// ---------------------------------------------------------------------------
void manualContourControler::CopyAttributesTo( manualContourControler * cloneObject)
{
	// Fathers object
	manualContourBaseControler::CopyAttributesTo(cloneObject);
	cloneObject->SetEasyCreation( this->GetEasyCreation() );
}

// ----------------------------------------------------------------------------
void manualContourControler::Configure() //virtual
{
 //	this->_manContModel->SetNumberOfPointsSpline(100);
}

// ----------------------------------------------------------------------------
void manualContourControler::MouseClickLeft(int x, int y)
{

	bool ok	= false;
	int z	= GetZ();
	int size= GetManualViewBaseContour()->GetNumberOfPoints();

	// Insert a Control Point with shift+ClickLeft
	vtkRenderWindowInteractor *vtkrenderwindowinteractor = _vtkInteractorStyleBaseView->GetInteractor();

	if( IsEditable() )
	{
		if ( (_vtkInteractorStyleBaseView!=NULL) && (GetState()==0) && ( (vtkrenderwindowinteractor!=NULL) && (vtkrenderwindowinteractor->GetShiftKey()==1) ) )
		{
			ok=true;
			InsertPoint(x,y,z);
			size++;
		}
		// Start to Insert Control Points with ClickLeft (Empty contour)
		if ((GetState()==0) && (size==0) && (_easyCreation==true) )
		{
			ok=true;
			SetState(1);
			GetManualContourModel()->SetCloseContour(false);
			AddPoint(x,y,z);
		}
		// Continuie to Insert Control Points with ClickLeft (After being empty the contour)
		if ((GetState()==1) && (_easyCreation==true) )
		{
			ok=true;
			AddPoint(x,y,z);
			_bakIdPoint=GetNumberOfPointsManualContour() - 1;
		}
		// Insert Control Points IF Contour si Selected
		if ((GetState()==0) && GetManualViewBaseContour()->GetPosibleSelected() )
		{
			ok=true;
			InsertPoint(x,y,z);
			_bakIdPoint = GetManualViewBaseContour()->GetIdPoint(x,y,z);
			SetState(6);
		}
		// Chose id of Control Point to be move
		if ( (GetState()==0 || GetState()==6) && (GetManualViewBaseContour()->GetIdPoint(x,y,z)!=-1 ) )
		{
			ok=true;
			_bakIdPoint = GetManualViewBaseContour()->GetIdPoint(x,y,z);
			SetState(5);
		}
		// If nothing selected _state=7
		if ( (GetState()==0) && (GetManualViewBaseContour()->GetIdPoint(x,y,z)==-1 ) )
		{
			//ok=true;
			_bakIdPoint = GetManualViewBaseContour()->GetIdPoint(x,y,z);
			SetState(7);
		}
	}else{
		SetPosibleToMove( true );
		GetManualViewBaseContour()->SetSelected( GetManualViewBaseContour()->GetPosibleSelected() );
	} // IsEditable

	if ( GetState() == 0 && GetManualViewBaseContour()->GetPosibleSelected() )
	{
		SetMoving( true );
		ok=true;
		GetManualViewBaseContour()->InitMove(x,y,z);
		SetState(6);
	}
	if (ok==true)
	{
		GetManualViewBaseContour()->Refresh();
	}
}
// ----------------------------------------------------------------------------
void manualContourControler::MouseMove(int x, int y) // virtual
{
	int z=GetZ();
	GetManualViewBaseContour()->SelectPosiblePoint(x,y,z);
	GetManualViewBaseContour()->SelectPosibleContour(x,y,z);
	if (GetState()==1){	SetPoint( _bakIdPoint , x , y ,z); }
	if (GetState()==5){	SetPoint( _bakIdPoint , x , y ,z); }
	if ( GetState()==6 && !IsEditable() && GetPosibleToMove() &&IsMoving() )
	{
		GetManualViewBaseContour()->MoveContour(x,y,z);
	}
	if (GetState()!=7 || GetManualViewBaseContour()->GetPosibleSelected() ){
		GetManualViewBaseContour()->Refresh();
		this->_vtkInteractorStyleBaseView->SetRefresh_waiting();
	}
	if (!IsEditable())
	{
		GetManualViewBaseContour()->RemoveControlPoints();
//		GetManualViewBaseContour()->RemoveTextActor();
		GetManualViewBaseContour()->Refresh();
		this->_vtkInteractorStyleBaseView->SetRefresh_waiting();
	}

}

// ----------------------------------------------------------------------------
void manualContourControler::MouseDLeft( int x, int y)//virtual
{
	manualContourBaseControler::MouseDLeft( x, y);
	if ( IsEditable() )
	{

		GetManualViewBaseContour()->AddControlPoints();
		GetManualViewBaseContour()->AddTextActor();
		GetManualViewBaseContour()->Refresh();
		this->_vtkInteractorStyleBaseView->SetRefresh_waiting();
	}
}
// ----------------------------------------------------------------------------
void manualContourControler::SetEasyCreation(bool easyCreation)
{
	_easyCreation=easyCreation;
}
// ----------------------------------------------------------------------------
bool manualContourControler::GetEasyCreation()
{
	return _easyCreation;
}

