/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualContourModel.h"

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

manualContourModel::manualContourModel()
{
    _cntSplineX = vtkKochanekSpline::New( );
    _cntSplineY = vtkKochanekSpline::New( );
    _cntSplineZ = vtkKochanekSpline::New( );
	this->SetCloseContour(true);
    _cntSplineX->SetDefaultTension( 0 );
	_cntSplineX->SetDefaultBias( 0 );
	_cntSplineX->SetDefaultContinuity( 0 );
    _cntSplineY->SetDefaultTension( 0 );
	_cntSplineY->SetDefaultBias( 0 );
	_cntSplineY->SetDefaultContinuity( 0 );
    _cntSplineZ->SetDefaultTension( 0 );
	_cntSplineZ->SetDefaultBias( 0 );
	_cntSplineZ->SetDefaultContinuity( 0 );
//JSTG 25-02-08 -------------------------------------------------------------------------------------------------
	// this parameter is reset in the  VIRTUAL manualContourBaseControler::Configure
	_sizePointsContour	= 500;			//JSTG 25-02-08 The change in the inisialization of these variable is critical.
	_delta_JSTG			= 0.0;
//---------------------------------------------------------------------------------------------------------------
//CMRU 17-08-09 -------------------------------------------------------------------------------------------------
	_realSize			= 0.0;
//---------------------------------------------------------------------------------------------------------------
}

// ----------------------------------------------------------------------------
manualContourModel::~manualContourModel()
{
	int i,size=_lstPoints.size();
	for (i=0;i<size; i++)
	{
		delete _lstPoints[i];
	} // for i
	_lstPoints.clear();
	_cntSplineX->RemoveAllPoints();
	_cntSplineY->RemoveAllPoints();
	_cntSplineZ->RemoveAllPoints();
	_cntSplineX->Delete();
	_cntSplineY->Delete();
	_cntSplineZ->Delete();
}

// ----------------------------------------------------------------------------
int manualContourModel::AddPoint(double x,double y,double z)
{
   manualPoint *mp = new manualPoint();
   mp->SetPoint(x,y,z);
   AddManualPoint(mp);
   //UpdateSpline();
   return _lstPoints.size()-1;
}
// ----------------------------------------------------------------------------
int manualContourModel::InsertPoint(double x,double y,double z)
{
	double dd,ddmin=9999999;
	int    ibak=0;
	double xx,x1,x2;
	double yy,y1,y2;
	double zz,z1,z2;
	int i,ii,iii,size=_lstPoints.size();
	double j,MaxDivisions=20,porcentage;
	int sizeB=size;

	if (_closeContour==false)
	{
		size=size-1;
	}

	double jbak;

	for ( i=0 ; i<size ; i++ )
	{
		ii=i % sizeB ;
		iii=(i+1) % sizeB;
		x1=_lstPoints[ii]->GetX();
		y1=_lstPoints[ii]->GetY();
		z1=_lstPoints[ii]->GetZ();
		x2=_lstPoints[iii]->GetX();
		y2=_lstPoints[iii]->GetY();
		z2=_lstPoints[iii]->GetZ();
		for (j=0; j<=MaxDivisions; j++)
		{
			porcentage=(j/MaxDivisions);
			xx=(x2-x1)*porcentage+x1;
			yy=(y2-y1)*porcentage+y1;
			zz=(z2-z1)*porcentage+z1;
			dd=sqrt( (xx-x)*(xx-x) + (yy-y)*(yy-y) + (zz-z)*(zz-z) );
			if ( dd<ddmin )
			{
				ddmin=dd;
				ibak=iii;
				jbak=j;
			}
		}
	}

	if (_closeContour==false)
	{
		if ( (ibak==1) && (jbak==0) )
		{
			ibak=0;
		}
		if ( ( ibak==size ) && ( jbak==MaxDivisions ) )
		{
			ibak=sizeB;
		}
	}


//JSTG - 25-04-08 ----------------------------------------------------------
	//manualPoint *mp = new manualPoint();
	//mp->SetPoint(x,y,z);
	//std::vector<manualPoint*>::iterator itNum = _lstPoints.begin() + ibak;
	//_lstPoints.insert(itNum,mp);
	InsertPoint_id(ibak,x,y,z);
//----------------------------------------------------------------------------

	return ibak;
}
// ----------------------------------------------------------------------------
void manualContourModel::InsertPoint_id(int id, double x, double y, double z)
{
	manualPoint *mp = new manualPoint();
	mp->SetPoint(x,y,z);
	std::vector<manualPoint*>::iterator itNum = _lstPoints.begin() + id;
	_lstPoints.insert(itNum,mp);
}
// ----------------------------------------------------------------------------

void manualContourModel::DeletePoint(int i)
{
	std::vector<manualPoint*>::iterator itNum = _lstPoints.begin() + i;
   _lstPoints.erase(itNum);
}
// ----------------------------------------------------------------------------
void manualContourModel::DeleteAllPoints()
{
	int i,size=_lstPoints.size();
	for (i=0;i<size;i++){
	   _lstPoints.erase( _lstPoints.begin() );
	}
	this->UpdateSpline();
}
// ----------------------------------------------------------------------------

void manualContourModel::MovePoint(int i,double dx,double dy,double dz)
{
printf("EED manualContourModel::MovePoint %p \n", this);
	manualPoint *mp=_lstPoints[i];
	double x=mp->GetX()+dx;
	double y=mp->GetY()+dy;
	double z=mp->GetZ()+dz;
	mp->SetPoint(x,y,z);
}
// ----------------------------------------------------------------------------
void manualContourModel::MoveLstPoints(double dx,double dy,double dz)
{
	// ToDo
}
// ----------------------------------------------------------------------------
void manualContourModel::MoveAllPoints(double dx,double dy,double dz)
{
	int i,size=_lstPoints.size();
	for (i=0;i<size;i++){
		MovePoint(i,dx,dy,dz);
	}
}


// ----------------------------------------------------------------------------

// type=-1  x,y,z
// type=0	x,y
// type=1	y,z
// type=2	x,z
int	 manualContourModel::GetIdPoint(double x, double y, double z, int i_range,int type)
{
	double range = i_range+1;

	double xx,yy,zz,dd,ddmin=9999999;
	int ibak=-1;
	int i,size=_lstPoints.size();
	for (i=0;i<size;i++){
		manualPoint *mp=_lstPoints[i];
		xx=mp->GetX();
		yy=mp->GetY();
		zz=mp->GetZ();

		if (type==-1)
		{
			if ((fabs(xx-x)<range) && (fabs(yy-y)<range) && (fabs(zz-z)<range)) {
			   dd=sqrt(   (xx-x)*(xx-x) + (yy-y)*(yy-y) + (zz-z)*(zz-z) );
			   if (dd<ddmin){
				   ddmin=dd;
				   ibak=i;
			   }
			}
		}
		if (type==0)
		{
			if ((fabs(yy-y)<range) && (fabs(zz-z)<range)) {
			   dd=sqrt(   (yy-y)*(yy-y) + (zz-z)*(zz-z) );
			   if (dd<ddmin){
				   ddmin=dd;
				   ibak=i;
			   }
			}
		}
		if (type==1)
		{
			if ((fabs(xx-x)<range) && (fabs(zz-z)<range)) {
			   dd=sqrt(   (xx-x)*(xx-x)  + (zz-z)*(zz-z) );
			   if (dd<ddmin){
				   ddmin=dd;
				   ibak=i;
			   }
			}
		}
		if (type==2)
		{
			if ((fabs(xx-x)<range) && (fabs(yy-y)<range) ) {
			   dd=sqrt(   (xx-x)*(xx-x) + (yy-y)*(yy-y)  );
			   if (dd<ddmin){
				   ddmin=dd;
				   ibak=i;
			   }
			}
		}
	}
	return ibak;
}
// ----------------------------------------------------------------------------
manualPoint* manualContourModel::GetManualPoint(int id)
{
	return _lstPoints[id];
}
// ----------------------------------------------------------------------------
int manualContourModel::GetSizeLstPoints()
{
	return _lstPoints.size();
}
//----------------------------------------------------------------------------
int manualContourModel::GetNumberOfPointsSpline()
{
	return _sizePointsContour;
}
//----------------------------------------------------------------------------
void manualContourModel::SetNumberOfPointsSpline(int size)
{
	_sizePointsContour = size;
}

// ----------------------------------------------------------------------------

void manualContourModel::SetCloseContour(bool closeContour)
{
	_closeContour = closeContour;
	if (_closeContour==true)
	{
		_cntSplineX->ClosedOn();
		_cntSplineY->ClosedOn();
		_cntSplineZ->ClosedOn();
	} else {
		_cntSplineX->ClosedOff();
		_cntSplineY->ClosedOff();
		_cntSplineZ->ClosedOff();
	}
}

// ----------------------------------------------------------------------------
bool manualContourModel::IfCloseContour()
{
	return _closeContour;
}

// ----------------------------------------------------------------------------

void manualContourModel::UpdateSpline() // virtual
{
	int i, np;
    np	= _lstPoints.size();
	manualPoint	*mp;
	_cntSplineX->RemoveAllPoints();
	_cntSplineY->RemoveAllPoints();
	_cntSplineZ->RemoveAllPoints();
    for( i = 0; i < np; i++ ) {
		mp = GetManualPoint(i);
        _cntSplineX->AddPoint( i, mp->GetX() );
        _cntSplineY->AddPoint( i, mp->GetY() );
        _cntSplineZ->AddPoint( i, mp->GetZ() );
    } //  rof

//JSTG 25-02-08 ---------------------------------------------------------------------------------------------
	if (this->_closeContour==true)
	{
		_delta_JSTG = (double) (np) / double (_sizePointsContour - 1);  //Without the -1 the curve is not close
	} else {
//		_delta_JSTG = (double) (np-1) / double (_sizePointsContour );  //Without the -1 the curve is not close
//EED 9/7/2016 		_delta_JSTG = (double) (np) / double (_sizePointsContour-1 );  //Without the -1 the curve is not close
 		_delta_JSTG = (double) (np-1) / double (_sizePointsContour-1 );  //Without the -1 the curve is not close
	}
//-----------------------------------------------------------------------------------------------------------
}

//---------------------------------------------------------------------------------

/*void manualContourModel::GetSplineiPoint(int i, double &x, double &y, double &z)
{
	double delta=(double)(_lstPoints.size()) / (double)(_sizePointsContour);
	double t = delta*(double)i;
	GetSplinePoint(t, x, y, z);
}*/

//-----------------------------------------------------------------------------

//JSTG 25-02-08 ---------------------------------------------------------------
void manualContourModel::GetSpline_i_Point(int i, double *x, double *y, double *z) // virtal
{
	GetSpline_t_Point(i*_delta_JSTG,x,y,z);
}

// ----------------------------------------------------------------------------

//JSTG 25-02-08 ---------------------------------------------------------------
void manualContourModel::GetSpline_t_Point(double t, double *x, double *y, double *z)
{
	if (_lstPoints.size()==0)
	{
		*x	= 0;
		*y	= 0;
		*z	= 0;
	}
	if (_lstPoints.size()==1)
	{
		manualPoint	*mp;
		mp	= GetManualPoint(0);
		*x	= mp->GetX();
		*y	= mp->GetY();
		*z	= mp->GetZ();
	}
	if (_lstPoints.size()>=2)
	{
		*x	= _cntSplineX->Evaluate(t);
		*y	= _cntSplineY->Evaluate(t);
		*z	= _cntSplineZ->Evaluate(t);
	}
}

// ----------------------------------------------------------------------------
/*void manualContourModel::GetSplinePoint(double t, double &x, double &y, double &z)
{
	if (_lstPoints.size()==0)
	{
		x	= 0;
		y	= 0;
		z	= 0;
	}
	if (_lstPoints.size()==1)
	{
		manualPoint	*mp;
		mp	= GetManualPoint(0);
		x	= mp->GetX();
		y	= mp->GetY();
		z	= mp->GetZ();
	}
	if (_lstPoints.size()>=2)
	{
		x	= _cntSplineX->Evaluate(t);
		y	= _cntSplineY->Evaluate(t);
		z	= _cntSplineZ->Evaluate(t);
	}
}*/

// ----------------------------------------------------------------------------
double manualContourModel::GetPathSize(double *spc)
{
	double result = 0;
	double x1,y1,z1;
	double x2,y2,z2;
// JSTG 25-02-08 -----------------------------
	//double t,delta;
	//int i,np,nps;
	int i;
//--------------------------------------------
	if (_lstPoints.size()==2)
	{
		x1 = spc[0] * _lstPoints[0]->GetX();
		y1 = spc[1] * _lstPoints[0]->GetY();
		z1 = spc[2] * _lstPoints[0]->GetZ();
		x2 = spc[0] * _lstPoints[1]->GetX();
		y2 = spc[1] * _lstPoints[1]->GetY();
		z2 = spc[2] * _lstPoints[1]->GetZ();
		result = sqrt( (x2-x1)*(x2-x1) + (y2-y1)*(y2-y1) + (z2-z1)*(z2-z1) );
	}
	if (_lstPoints.size()>2)
	{
// JSTG 25-02-08 ------------------------------------------
		//np  = _lstPoints.size( );
		//nps = 200;
		//delta=( double ) ( np  ) / ( double ) ( nps  );
		UpdateSpline();
		//GetSplinePoint(0,x1,y1,z1);
		GetSpline_i_Point(0,&x1,&y1,&z1);
		x1 = spc[0] * x1; 
		y1 = spc[1] * y1; 
		z1 = spc[2] * z1; 
		//for( i = 1; i < nps; i++ )
		for( i = 1; i < GetNumberOfPointsSpline(); i++ )
		{
			//t = delta * (double)i;
			//GetSplinePoint(t,x2,y2,z2);
			GetSpline_i_Point(i,&x2,&y2,&z2);
			x2 = spc[0] * x2; 
			y2 = spc[1] * y2; 
			z2 = spc[2] * z2; 
//---------------------------------------------------------
			result=result + sqrt( (x2-x1)*(x2-x1) + (y2-y1)*(y2-y1) + (z2-z1)*(z2-z1) );
			x1=x2;
			y1=y2;
			z1=z2;
		}// for
	}
	return result;
}

// ----------------------------------------------------------------------------
double manualContourModel::GetPathArea(double *spc)
{
	double result = 555;
	if ((_lstPoints.size()>=3) && IfCloseContour()==true )
	{
		double area;
//JSTG 25-02-08 ---------------------------------------------
		//double ti,tj;
//-----------------------------------------------------------
		double x1,y1,z1;
		double x2,y2,z2;
		bool okArea=true;
		int i, j;
		// This uses Green's theorem:
		// A = 1/2 * sum( xiyi+1 - xi+1yi); pO == pN
		// A < 0 -> A = |A| (a negative value could raise because points are
		// given in clockwise order).

//JSTG 25-02-08 -------------------------------------------------
		//int np  = _lstPoints.size( );
		//int nps = 200;
		int nps = GetNumberOfPointsSpline();
		//double delta=( double ) ( np  ) / ( double ) ( nps  );
		UpdateSpline();
		for( i = 0, area = 0.0; i < nps; i++ )
		{
			j = ( i + 1 ) % nps;
			//ti = delta * (double)i;
			//tj = delta * (double)j;
			//GetSplinePoint(ti,x1,y1,z1);
			//GetSplinePoint(tj,x2,y2,z2);
			GetSpline_i_Point(i,&x1,&y1,&z1);
			GetSpline_i_Point(j,&x2,&y2,&z2);
//----------------------------------------------------------------
			x1=spc[0]*x1;
			y1=spc[1]*y1;
			z1=spc[2]*z1;
			x2=spc[0]*x2;
			y2=spc[1]*y2;
			z2=spc[2]*z2;
			area += (x1 * y2 ) - ( x2 * y1 );
			if (z1!=z2)
			{
				okArea=false;
			}
		}// for
		area /= 2.0;
		area = fabs( area );

/*
		for( i = 0, area = 0.0; i < _lstPoints.size(); i++ )
		{
			j = ( i + 1 ) % _lstPoints.size();
			//  Area
			area +=
					(_lstPoints[i]->GetX() * _lstPoints[j]->GetY() ) -
					( _lstPoints[j]->GetX() * _lstPoints[i]->GetY() );
			if (_lstPoints[0]->GetZ()!=_lstPoints[i]->GetZ())
			{
				okArea=false;
			}
		} // rof
		area /= 2.0;
		area = fabs( area );
*/

		if (okArea==true)
		{
			result = area;
		} else {
			result = -1;
		}

	} else {
		result = 0;
	}
	return result;
}

// ----------------------------------------------------------------------------
// p[x,y,z]   :  data in
// rp[x,y,z]  :  data out  result point
// rn[x,y,z]  :  data out   result normal
void manualContourModel::GetNearestPointAndNormal(double *p, double *rp,  double *rn)
{
	double  distMin=999999999;
	double	dist,dx,dy,dz;
	double	x1,y1,z1;
	double	x2,y2,z2;
	int		i,np,nps;

//JSTG 25-02-08 -------------------
	//double  tback;
	int iback;
	//double	t,delta;
//---------------------------------

	np	= _lstPoints.size( );
	if (np>=2)
	{
// JSTG 25-02-08 ------------------------------------------
		//nps		= 200;
		nps = GetNumberOfPointsSpline();
		//delta	= ( double ) ( np  ) / ( double ) ( nps  );
		UpdateSpline();
		//GetSplinePoint(0,x1,y1,z1);
		GetSpline_i_Point(0,&x1,&y1,&z1);
		for( i = 0; i < nps; i++ )
		{
			//t = delta * (double)i;
			//GetSplinePoint(t,x1,y1,z1);
			GetSpline_i_Point(i,&x1,&y1,&z1);
//----------------------------------------------------------
			dx= x1-p[0];
			dy= y1-p[1];
			dz= z1-p[2];
			dist = sqrt( dx*dx + dy*dy + dz*dz );
			if (dist<distMin)
			{
				distMin  = dist;
//JSTG			tback = t;
				iback = i;
				rp[0] = x1;
				rp[1] = y1;
				rp[2] = z1;
				rn[0] = x2-x1;
				rn[1] = y2-y1;
				rn[2] = z2-z1;
			} // if
			x2 = x1;
			y2 = y1;
			z2 = z1;
		}// for
// JSTG 25-02-08 ------------------------------------------
		//if (tback==0)
		if (iback==0)
		{
			//t = delta * (double)1.0;
			//GetSplinePoint(t,x1,y1,z1);
			GetSpline_i_Point(i,&x1,&y1,&z1);
//----------------------------------------------------------
			rn[0] = rp[0]-x1;
			rn[1] = rp[1]-y1;
			rn[2] = rp[2]-z1;
		} // if iback 
	} else {
		rp[0] = 0;
		rp[1] = 0;
		rp[2] = 0;
		rn[0] = -1;
		rn[1] = 0;
		rn[2] = 0;
	} // if np
}

// ----------------------------------------------------------------------------
manualContourModel * manualContourModel::Clone() // virtual
{
	manualContourModel * clone = new manualContourModel();
	CopyAttributesTo(clone);
	return clone;
}

// ----------------------------------------------------------------------------
void manualContourModel::Open(FILE *ff) // virtual
{
	char tmp[255];
	int i;
	int numberOfControlPoints;
	double x,y,z;

	fscanf(ff,"%s",tmp); // NumberOfControlPoints
	fscanf(ff,"%s",tmp); // ##
	numberOfControlPoints = atoi(tmp);
	for (i=0;i<numberOfControlPoints;i++)
	{
		fscanf(ff,"%s",tmp); // X
		x = atof(tmp);
		fscanf(ff,"%s",tmp); // Y
		y = atof(tmp);
		fscanf(ff,"%s",tmp); // Z
		z = atof(tmp);
		AddPoint(x,y,z);
	}
}

// ----------------------------------------------------------------------------
int manualContourModel::GetTypeModel() //virtual
{
	// 0 spline
	// 1 spline
	// 2 rectangle
	// 3 circle
	// 4 BullEye
	// 5 BullEyeSector
	// 6 Line
	return 1;
}

// ----------------------------------------------------------------------------
void manualContourModel::Save(FILE *ff) // virtual
{
	int i,size=_lstPoints.size();
	fprintf(ff,"TypeModel %d\n", GetTypeModel() );
	fprintf(ff,"NumberOfControlPoints %d\n",size);
	for (i=0;i<size;i++)
	{
		manualPoint *mp=_lstPoints[i];
		fprintf(ff,"%f %f %f\n", mp->GetX(), mp->GetY(), mp->GetZ() );
	}
}
//CMRU 03-09-09-----------------------------------------------------------------------------------------------
void manualContourModel::SaveData(FILE *ff)
{
	std::string etiqueta = GetLabel();
	if(etiqueta.empty())
	{
		fprintf(ff,"Label: NO_LABEL\n");
	} else {
		fprintf(ff,"Label: %s\n",etiqueta.c_str());
	} // if etiqueta
	fprintf(ff,"Real_Size: %f\n",GetRealSize());
}

void manualContourModel::OpenData(FILE *ff)
{
	char tmp[255];

	fscanf(ff,"%s",tmp); // Label:
	fscanf(ff,"%s",tmp); // value
	std::cout<<tmp<<std::endl;
	//if(strcmp(tmp != "NO_LABEL") // JPR
	if(strcmp(tmp,"NO_LABEL") != 0)
	{
		SetLabel(tmp);
	}
	fscanf(ff,"%s",tmp); // Real_size
	fscanf(ff,"%s",tmp);// #

	//tmp.ToDouble(&tmp);
	SetRealSize(atof(tmp));
}

//------------------------------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------

void manualContourModel::CopyAttributesTo( manualContourModel * cloneObject)
{
	// Fathers object
	//XXXX::CopyAttributesTo(cloneObject);

	cloneObject->SetCloseContour( this->IfCloseContour() );
	int i, size = GetSizeLstPoints();
	for( i=0; i<size; i++ )
	{
		cloneObject->AddManualPoint( GetManualPoint( i )->Clone() );
	}
	cloneObject->SetNumberOfPointsSpline( GetNumberOfPointsSpline () );
	cloneObject->SetCloseContour( _closeContour );
	cloneObject->UpdateSpline();
}


// ---------------------------------------------------------------------------
void manualContourModel::AddManualPoint( manualPoint* theManualPoint )//private
{
	_lstPoints.push_back( theManualPoint );
}

std::vector<manualBaseModel*> manualContourModel::ExploseModel(  )
{
	std::vector<manualBaseModel*> lstTmp;
	lstTmp.push_back(this);
	return lstTmp;
}


// ----------------------------------------------------------------------------
void manualContourModel::Transform_Ax_Plus_B (double Ax, double Bx, double Ay, double By)
{
	manualPoint * mp;

	int i, size = GetSizeLstPoints();

	for( i=0; i<size; i++ )
	{
		mp = GetManualPoint( i );

		mp->SetPointX( mp->GetX()*Ax + Bx );
		mp->SetPointY( mp->GetY()*Ay + By );
	}
}


//CMRU 17-08-09----------------------------------------------------------------------------
void manualContourModel::SetRealSize(double newRealSize) 
{
	_realSize = newRealSize;
}

double manualContourModel::GetRealSize()
{
	return _realSize;
}

//----------------------------------------------------------------------------
