/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef manualContourModel_h
#define manualContourModel_h

#include "vtkRenderWindow.h"

#include "vtkRenderer.h"
#include "vtkRenderWindowInteractor.h" //extremely important with VC++ don't remove !
#include "vtkCommand.h"
#include "vtkPolyData.h"
#include "vtkCellArray.h"
#include "vtkPolyDataMapper.h"
#include "vtkInteractorObserver.h"
#include "vtkInteractorStyleImage.h"
#include <vtkKochanekSpline.h> 

#include <vtkCellPicker.h> 


#include <vtkCamera.h> 
#include <vtkPolyLine.h>
#include <vtkDataSetMapper.h>
#include <vtkUnstructuredGrid.h>

#include "creawxVTKRenderWindowInteractor.h"


//--

#include <vector>
#include "wxVtkBaseView.h"
#include "marTypes.h"
#include "manualPoint.h"
#include "manualBaseModel.h"


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------


class creaMaracasVisu_EXPORT manualContourModel : public manualBaseModel
{
public:
	manualContourModel();
	virtual ~manualContourModel();

	virtual manualContourModel * Clone();
	void CopyAttributesTo( manualContourModel *cloneObject );
	void Open(FILE *ff);				// virtual
	virtual void Save(FILE *ff);		// virtual
	virtual int GetTypeModel();			// virtual 

	virtual int				AddPoint(double x,double y,double z);
	virtual int				InsertPoint(double x,double y,double z);
//JSTG 25-04-08 -------------------------------------------------------
	virtual void			InsertPoint_id(int id, double x,double y,double z);
//---------------------------------------------------------------------
	virtual void			AddManualPoint( manualPoint* theManualPoint );
	virtual void			Transform_Ax_Plus_B (double Ax, double Bx, double Ay, double By);

	virtual void			DeletePoint(int i);
	virtual void			DeleteAllPoints();

	virtual void			MovePoint(int i,double dx,double dy,double dz);
	virtual void			MoveLstPoints(double dx,double dy,double dz);
	virtual void			MoveAllPoints(double dx,double dy,double dz);

	virtual int				GetIdPoint(double x, double y, double z, int i_range,int type);
	virtual manualPoint*	GetManualPoint(int id);
	virtual int				GetSizeLstPoints();
	int						GetNumberOfPointsSpline();
	virtual void			SetNumberOfPointsSpline(int size);

	virtual void			UpdateSpline();
	void					SetCloseContour(bool closeContour);
	bool					IfCloseContour();
//JSTG 25-02-08 -----------------------------------------------------------------
	//void			GetSplinePoint(double t, double &x, double &y, double &z);	//Method Original
	//void			GetSplineiPoint(int i, double &x, double &y, double &z);	//Method Original
//-------------------------------------------------------------------------------
	virtual double			GetPathSize(double *spc);
	virtual double			GetPathArea(double *spc);

	void					GetNearestPointAndNormal(double *p, double *rp,  double *rn);
	
// JSTG 25-02-08 -----------------------------------------------------------------
	virtual void			GetSpline_i_Point(int i, double *x, double *y, double *z);
	void					GetSpline_t_Point(double t, double *x, double *y, double *z);
//--------------------------------------------------------------------------------

	virtual std::vector<manualBaseModel*> ExploseModel(  );

// CMRU 17-08-09 -----------------------------------------------------------------
	
	
	/*
	* Assigns the parameter value to the real size
	* @param newRealSize New real size in milimeters of the contour
	*/
	void SetRealSize(double newRealSize);
	
	/**
	* Returns the real size in milimeters of the contour
	*/
	double GetRealSize();
	
	/*
	* Saves the label and the real size of the contour
	* @param ff File where the information is stored 
	*/
	void SaveData(FILE *ff);

	/*
	* Reads and interprets the information of the label and the real size
	* @param ff File where the information is readed 
	*/
	void OpenData(FILE *ff);
//--------------------------------------------------------------------------------

//public:
	//int							_sizePointsContour;
	//std::vector<manualPoint*>	_lstPoints;
	bool						_closeContour;
    vtkKochanekSpline			*_cntSplineX;
    vtkKochanekSpline			*_cntSplineY;
    vtkKochanekSpline			*_cntSplineZ;

//JSTG 25-02-08 ----------------------------------------
	double						_delta_JSTG;
//------------------------------------------------------

//CMRU 17-08-09 -----------------------------------------------------------------
	/**
	* Represents the real size in milimeters of the contour
	*/
	double						_realSize;

//--------------------------------------------------------------------------------

}; 


#endif // manualContourModel_h
