/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualContourModelBullEye.h"


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

manualContourModelBullEye::manualContourModelBullEye()
: manualContourModel()
{
	_numberPointsSlineBySector=101;   // impaire
}

manualContourModelBullEye::~manualContourModelBullEye()
{
}


// ----------------------------------------------------------------------------
manualContourModelBullEye * manualContourModelBullEye :: Clone()  // virtual
{
	manualContourModelBullEye * clone = new manualContourModelBullEye();
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------

void manualContourModelBullEye::CopyAttributesTo( manualContourModelBullEye * cloneObject)
{
	// Fathers object
	manualContourModel::CopyAttributesTo(cloneObject);
}

//----------------------------------------------------------------
int manualContourModelBullEye::GetTypeModel() //virtual
{
	return 4;
}

//----------------------------------------------------------------
int	manualContourModelBullEye::GetNumberOfPointsSplineSectorBulleEje()
{
	return _numberPointsSlineBySector;
}

//----------------------------------------------------------------
void manualContourModelBullEye::SetNumberOfPointsSplineSectorBulleEje(int numpoints)
{
	this->_numberPointsSlineBySector = numpoints;
}

//----------------------------------------------------------------
void manualContourModelBullEye::AddSector(	double radioA,
						double radioB,
						double ang,
						double angDelta)
{
	manualContourModelBullEyeSector *modelSector = new manualContourModelBullEyeSector();
	modelSector->SetSector(radioA,radioB,ang,angDelta);
	modelSector->SetNumberOfPointsSpline( this->GetNumberOfPointsSplineSectorBulleEje() );
	_lstModelBullEyeSector.push_back(modelSector);
}

//----------------------------------------------------------------
manualContourModelBullEyeSector * manualContourModelBullEye::GetModelSector(int id)
{
	return _lstModelBullEyeSector[id];
}

//----------------------------------------------------------------
void manualContourModelBullEye::GetSector(int id,
						double *radioA,
						double *radioB,
						double *ang,
						double *angDelta)
{
	_lstModelBullEyeSector[id]->GetSector(radioA,radioB,ang,angDelta);
}

void manualContourModelBullEye::UpdateSpline() // virtual
{
	manualContourModel::UpdateSpline();

	if (this->GetSizeLstPoints()>2){
		double cx,cy;
		double ww,hh;
		manualPoint *mpA = GetManualPoint(0);
		manualPoint *mpB = GetManualPoint(2);
		cx = (mpA->GetX() + mpB->GetX()) / 2.0;
		cy = (mpA->GetY() + mpB->GetY()) / 2.0;
		ww = fabs( mpA->GetX() - mpB->GetX() )/2.0;
		hh = fabs( mpA->GetY() - mpB->GetY() )/2.0;
		int i,size = _lstModelBullEyeSector.size();
		for (i=0;i<size;i++)
		{
			_lstModelBullEyeSector[i]->SetCenter(cx,cy);
			_lstModelBullEyeSector[i]->SetSize(ww,hh);
		} // for
	}
}


//----------------------------------------------------------------
void manualContourModelBullEye::ResetSectors()
{
	int i,size=_lstModelBullEyeSector.size();
	for (i=0;i<size;i++)
	{
		delete _lstModelBullEyeSector[i];
	}
	_lstModelBullEyeSector.clear();
}

//----------------------------------------------------------------
int manualContourModelBullEye::GetSizeOfSectorLst()
{
	return _lstModelBullEyeSector.size();
}

//----------------------------------------------------------------
void manualContourModelBullEye::Save(FILE *ff) // virtual
{
	manualContourModel::Save(ff);
	int i,size = GetSizeOfSectorLst();
	fprintf(ff,"numberOfSections %d \n",size);
	for ( i=0 ; i<size ; i++ )
	{
		_lstModelBullEyeSector[i]->Save(ff);
	}
}

//----------------------------------------------------------------
void manualContourModelBullEye::Open(FILE *ff) // virtual
{
	manualContourModel::Open(ff);

	ResetSectors();

	char tmp[255];
	int i;
	int numberOfSections;
//	double radioA,radioB,ang,deltaAng;

	fscanf(ff,"%s",tmp); // NumberOfSections
	fscanf(ff,"%s",tmp); // ##
	numberOfSections = atoi(tmp);
	for (i=0;i<numberOfSections;i++)
	{
		AddSector(0,1,90,0);
		_lstModelBullEyeSector[i]->Open(ff);
	}

}

// ----------------------------------------------------------------------------
std::vector<manualBaseModel*> manualContourModelBullEye::ExploseModel(  )
{
//EED004
	std::vector<manualBaseModel*> lstTmp;
	int i,iSize=_lstModelBullEyeSector.size();
	for (i=0;i<iSize;i++)
	{
		lstTmp.push_back( _lstModelBullEyeSector[i] );
	}
	return lstTmp;
}

