/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualContourModelBullEyeSector.h"


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

manualContourModelBullEyeSector::manualContourModelBullEyeSector()
: manualContourModel()
{
}

manualContourModelBullEyeSector::~manualContourModelBullEyeSector()
{
}


// ----------------------------------------------------------------------------
manualContourModelBullEyeSector * manualContourModelBullEyeSector :: Clone()  // virtual
{
	manualContourModelBullEyeSector * clone = new manualContourModelBullEyeSector();
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------

void manualContourModelBullEyeSector::CopyAttributesTo( manualContourModelBullEyeSector * cloneObject)
{
	// Fathers object
	manualContourModel::CopyAttributesTo(cloneObject);
}

//----------------------------------------------------------------
int manualContourModelBullEyeSector::GetTypeModel() //virtual
{
	return 5;
}


//----------------------------------------------------------------
void manualContourModelBullEyeSector::SetSector(	double radioA,
						double radioB,
						double ang,
						double angDelta)
{
	_radioA		= radioA;
	_radioB		= radioB;
	_ang		= ang*3.14159265/180.0;
	_angDelta	= angDelta*3.14159265/180.0;
}

//----------------------------------------------------------------
void manualContourModelBullEyeSector::GetSector(
						double *radioA,
						double *radioB,
						double *ang,
						double *angDelta)
{
	*radioA		= _radioA;
	*radioB		= _radioB;
	*ang		= _ang;
	*angDelta	= _angDelta;
}

// ----------------------------------------------------------------------------
void manualContourModelBullEyeSector::SetCenter(double cx,double cy)
{
	_cx = cx;
	_cy = cy;
}

//----------------------------------------------------------------
void manualContourModelBullEyeSector::SetSize(double ww,double hh)
{
	_ww = ww;
	_hh = hh;
}

//----------------------------------------------------------------
void manualContourModelBullEyeSector::GetSpline_i_Point(int i, double *x, double *y, double *z)
{
//EED004

	int ii,nps;
//	double x,y,z;
	double ang,angcos, angsin;
	double radio;

	nps	=  GetNumberOfPointsSpline() - 3;

	if (i==GetNumberOfPointsSpline()-1)
	{
		i=0;
	}

	if (i<=nps/2)
	{
		ii=i;
		radio=_radioA;
	} else {
		ii=nps-i+1;
		radio=_radioB;
	}
	ang = ((double)ii/(nps/2))*_angDelta + _ang;
	angcos =  cos(ang);
	angsin =  sin(ang);

	*x = _ww*radio*angcos + _cx;
	*y = _hh*radio*angsin + _cy;
	
//EED 21 mars 2012  FLIP probleme  ..PLOP..	
//	*z= 900;
	*z= -900;
}

//----------------------------------------------------------------
void manualContourModelBullEyeSector::Save(FILE *ff) // virtual
{
	manualContourModel::Save(ff);
	fprintf(ff,"rA= %f rB= %f ang= %f deltaAng= %f\n", _radioA,_radioB, _ang , _angDelta);
}

//----------------------------------------------------------------
void manualContourModelBullEyeSector::Open(FILE *ff) // virtual
{
	char tmp[255];
	fscanf(ff,"%s",tmp); // TypeModel
	fscanf(ff,"%s",tmp); // ##

	manualContourModel::Open(ff);


	fscanf(ff,"%s",tmp); // radioA=
	fscanf(ff,"%s",tmp); // radioA
	_radioA = atof(tmp);

	fscanf(ff,"%s",tmp); // radioB=
	fscanf(ff,"%s",tmp); // radioB
	_radioB = atof(tmp);

	fscanf(ff,"%s",tmp); // ang=
	fscanf(ff,"%s",tmp); // ang
	_ang = atof(tmp);

	fscanf(ff,"%s",tmp); // deltaAng=
	fscanf(ff,"%s",tmp); // deltaAng
	_angDelta = atof(tmp);
}


