/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualContourModelCircle.h"

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

manualContourModelCircle::manualContourModelCircle()
: manualContourModel()
{
}

manualContourModelCircle::~manualContourModelCircle()
{
}


// ----------------------------------------------------------------------------
manualContourModelCircle * manualContourModelCircle :: Clone()  // virtual
{
	manualContourModelCircle * clone = new manualContourModelCircle();
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------

void manualContourModelCircle::CopyAttributesTo( manualContourModelCircle * cloneObject)
{
	// Fathers object
	manualContourModel::CopyAttributesTo(cloneObject);
}

//----------------------------------------------------------------
int manualContourModelCircle::GetTypeModel() //virtual
{
	return 3;
}

//----------------------------------------------------------------
void manualContourModelCircle::GetSpline_i_Point(int i, double *x, double *y, double *z) // virtal
{
	double angle = _deltaAngle*i;
	*x = _radio*cos(angle) + _centerX;
	*y = _radio*sin(angle) + _centerY;
	*z = _centerZ;
}

//
// ---------------------------------------------------------------------------
void manualContourModelCircle::UpdateSpline() // virtal
{
	manualPoint	*mpA,*mpB;
	double difX,difY;
    int np	= GetSizeLstPoints( );
	int nps = GetNumberOfPointsSpline();
	_deltaAngle=(3.14159265*2)/(nps-1);

	if (np==2)
	{
		mpA			= GetManualPoint(0);
		mpB			= GetManualPoint(1);
		difX		= mpA->GetX() - mpB->GetX();
		difY		= mpA->GetY() - mpB->GetY();
		_radio		= sqrt( difX*difX + difY*difY );
		_centerX	= mpA->GetX();
		_centerY	= mpA->GetY();
		_centerZ	= mpA->GetZ();
	} else {
		_radio		= -1;
		_centerX	= -1;
		_centerY	= -1;
		_centerZ	= -1;
	}
}
