/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualContourModelRotationTool.h"

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

manualContourModelRotationTool::manualContourModelRotationTool()
{
}

//----------------------------------------------------------------

manualContourModelRotationTool::~manualContourModelRotationTool()
{
}


// ----------------------------------------------------------------------------
manualContourModelRotationTool * manualContourModelRotationTool :: Clone()  // virtual
{
	manualContourModelRotationTool * clone = new manualContourModelRotationTool();
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------
void manualContourModelRotationTool::CopyAttributesTo( manualContourModelRotationTool * cloneObject)
{
	// Fathers object
	manualContourModelRotationTool::CopyAttributesTo(cloneObject);
}

//----------------------------------------------------------------
int manualContourModelRotationTool::GetTypeModel() //virtual
{
	return 8;
}

//----------------------------------------------------------------
void manualContourModelRotationTool::GetSpline_i_Point(int i, double *x, double *y, double *z) // virtal
{
	int nps = GetNumberOfPointsSpline();
	//Spline points of the circle
	if(i<nps-2)
	{
		double angle = _deltaAngle*i;
		*x = _radio*cos(angle) + _centerX;
		*y = _radio*sin(angle) + _centerY;
		*z = _centerZ;
	}
	//Spline points of the reference line
	if(i==nps-2)
	{
		*x = _centerX;
		*y = _centerY;
		*z = _centerZ;
	}
	//Spline points of the movable line
	if(i==nps-1)
	{
		manualPoint *mpA= GetManualPoint(2);
		*x = mpA->GetX();
		*y = mpA->GetY();
		*z = _centerZ;
	}
	
}

// ---------------------------------------------------------------------------
void manualContourModelRotationTool:: UpdateSpline()
{	
	manualPoint	*mpA,*mpB,*mpC;
	double difX,difY;
	double x, y; 
    int np	= GetSizeLstPoints( );
	int nps = GetNumberOfPointsSpline();
	_deltaAngle=(3.14159265*2)/(nps-1-2);

	if (np==3)
	{
		mpA			= GetManualPoint(0);
		mpB			= GetManualPoint(1);
		mpC			= GetManualPoint(2);
		difX		= mpA->GetX() - mpB->GetX();
		difY		= mpA->GetY() - mpB->GetY();
		_radio		= sqrt( difX*difX + difY*difY );
		_centerX	= mpA->GetX();
		_centerY	= mpA->GetY();
		_centerZ	= mpA->GetZ();

		x= mpC->GetX() - mpA->GetX();
		y= mpC->GetY() - mpA->GetY();
		_angle= atan(y/x)*180/(3.14159265);
		cout << "Scale" <<_radio <<endl;
		cout << "Angle" <<_angle <<endl;
		cout<< "Center"<<_centerX<<","<<_centerY<<endl;
	} 
	else 
	{
		_radio		= -1;
		_centerX	= -1;
		_centerY	= -1;
		_centerZ	= -1;
		_angle		= -1;
	}
}

//----------------------------------------------------------------
double manualContourModelRotationTool::getRadio()
{
	return _radio;
}

//----------------------------------------------------------------
double manualContourModelRotationTool::getAngle()
{
	return _angle;
}


std::vector<double> manualContourModelRotationTool::getCenter()
{
	manualPoint *mpCenter	= GetManualPoint(0);
	std::vector<double> centro(2,0);
	centro[0]=mpCenter->GetX();
	centro[1]=mpCenter->GetY();
	return centro;

}
