/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualContourPerpPlaneControler.h"

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
manualContourPerpPlaneControler::manualContourPerpPlaneControler()
{
	_flagMouseMove = true;
}
// ----------------------------------------------------------------------------
manualContourPerpPlaneControler::~manualContourPerpPlaneControler()
{
}
// ----------------------------------------------------------------------------
manualContourPerpPlaneControler * manualContourPerpPlaneControler :: Clone()  // virtual
{
	manualContourPerpPlaneControler * clone = new manualContourPerpPlaneControler();
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------
void manualContourPerpPlaneControler::CopyAttributesTo( manualContourPerpPlaneControler * cloneObject)
{
	// Fathers object
	manualContourControler::CopyAttributesTo(cloneObject);

	cloneObject->SetVtkMPRBaseData( this->GetVtkMPRBaseData() );
	cloneObject->SetManualContour3VControler( this->GetManualContour3VControler() );
	cloneObject->SetVtkInteractorStylePlane2D( this->GetVtkInteractorStylePlane2D() );
}

// ----------------------------------------------------------------------------
void manualContourPerpPlaneControler::SetVtkMPRBaseData(vtkMPRBaseData *vtkmprbasedata)
{
	_vtkmprbasedata = vtkmprbasedata;
}

// ----------------------------------------------------------------------------
vtkMPRBaseData *manualContourPerpPlaneControler::GetVtkMPRBaseData()
{
	return _vtkmprbasedata;
}


// ----------------------------------------------------------------------------
void manualContourPerpPlaneControler::InsertPoint(int x, int y, int z ) // virtual
{
	manualContourControler::InsertPoint(  x,  y,  z );
	_manualcontour3Vcontroler->InsertPoint_Others(0);
}
// ----------------------------------------------------------------------------
void manualContourPerpPlaneControler::AddPoint( int x, int y, int z )
{
	manualContourControler::AddPoint(  x,  y,  z );
	_manualcontour3Vcontroler->AddPoint_Others();
}
// ----------------------------------------------------------------------------
void manualContourPerpPlaneControler::DeleteActualMousePoint(int x, int y)
{
	int id = GetManualViewBaseContour()->GetIdPoint ( x , y , GetZ() );
	manualContourControler::DeleteActualMousePoint( x , y );
	_manualcontour3Vcontroler->DeleteActualMousePoint_Others(id);
}
// ----------------------------------------------------------------------------
void manualContourPerpPlaneControler::MouseMove( int x, int y )
{
	_flagMouseMove = true;
	int ss =this->_vtkInteractorStyleBaseView->vtkInteractorStyle::GetState();
	if ((this->GetState()!=7) && (ss!=1)){
		manualContourControler::MouseMove( x , y );
		int id = GetManualViewBaseContour()->GetIdPoint ( x , y , GetZ() );
		if (id!=-1)
		{
			_manualcontour3Vcontroler->MouseMove_Others(id);
			_flagMouseMove = false;
		}
	}
}
// ----------------------------------------------------------------------------
void manualContourPerpPlaneControler::SetManualContour3VControler(manualContour3VControler *manualcontour3Vcontroler)
{
	_manualcontour3Vcontroler = manualcontour3Vcontroler;
}
// ----------------------------------------------------------------------------
manualContour3VControler * manualContourPerpPlaneControler::GetManualContour3VControler()
{
	return _manualcontour3Vcontroler;
}
// ----------------------------------------------------------------------------
bool manualContourPerpPlaneControler::OnChar() // virtual
{
	if (manualContourControler::OnChar()==false )
	{
		_manualcontour3Vcontroler->OnChar_Others();
	}
	return true;
}
// ----------------------------------------------------------------------------
bool manualContourPerpPlaneControler::OnMouseMove() // 	virtual
{
	manualContourControler::OnMouseMove();
	return _flagMouseMove;
}
// ----------------------------------------------------------------------------
bool manualContourPerpPlaneControler::OnLeftDClick() // 	virtual
{
	manualContourControler::OnLeftDClick();
	return _flagMouseDClick;
}
// ----------------------------------------------------------------------------
void manualContourPerpPlaneControler::ResetContour() // virtual
{
	manualContourControler::ResetContour();
	_manualcontour3Vcontroler->ResetContour_Others();
}

// ----------------------------------------------------------------------------
void manualContourPerpPlaneControler::MouseDLeft( int x, int y) // virtual
{
	_flagMouseDClick=true;
	manualContourControler::MouseDLeft(x,y);

	if (GetManualViewBaseContour()->ifTouchContour(x,y,0)==true)
	{
		_flagMouseDClick = false;
		_vtkinteractorstyleplane2D->OnLeftDClick();
		ResetOrientationPlane();
		this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();
	}

//	int id=GetManualViewBaseContour()->GetIdPoint(x,y,GetZ());
//		if ( (GetState()==0) && (id!=-1) )
//	{
//		manualPoint *mp = this->GetManualContourModel()->GetManualPoint(id);
//		_vtkmprbasedata->SetX( mp->GetX() );
//		_vtkmprbasedata->SetY( mp->GetY() );
//		_vtkmprbasedata->SetZ( mp->GetZ() );
//		ResetOrientationPlane();
//		this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();
//	}
}



// ----------------------------------------------------------------------------
void manualContourPerpPlaneControler::ResetOrientationPlane()
{
	double p[3],rp[3],rn[3];
	p[0] = _vtkmprbasedata->GetX(  );
	p[1] = _vtkmprbasedata->GetY(  );
	p[2] = _vtkmprbasedata->GetZ(  );
	this->GetManualContourModel()->GetNearestPointAndNormal(p,rp,rn);

	_vtkmprbasedata->SetNormal(rn[0],rn[1],rn[2]);
}

// ----------------------------------------------------------------------------
void manualContourPerpPlaneControler::SetVtkInteractorStylePlane2D(InteractorStyleMaracas *vtkinteractorstyleplane2D)
{
	_vtkinteractorstyleplane2D = vtkinteractorstyleplane2D;
}
// ----------------------------------------------------------------------------
InteractorStyleMaracas * manualContourPerpPlaneControler::GetVtkInteractorStylePlane2D()
{
	return _vtkinteractorstyleplane2D;
}

