/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef manualContourPerpPlaneControler_h
#define manualContourPerpPlaneControler_h


#include "wxMPRBaseData.h"
#include "manualContourControler.h"
#include "manualContour3VControler.h"

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

class creaMaracasVisu_EXPORT manualContourPerpPlaneControler: public manualContourControler
{
public:
	manualContourPerpPlaneControler();
	virtual ~manualContourPerpPlaneControler();
    virtual manualContourPerpPlaneControler * Clone();
	void CopyAttributesTo( manualContourPerpPlaneControler *cloneObject );

	void SetVtkMPRBaseData(vtkMPRBaseData *vtkmprbasedata);
	vtkMPRBaseData *GetVtkMPRBaseData();

	virtual bool OnChar();
	virtual bool OnMouseMove();
	virtual bool OnLeftDClick(); 
	virtual void AddPoint( int x, int y, int z );
	virtual void DeleteActualMousePoint(int x, int y);
	virtual void MouseMove(int x, int y);
	virtual void InsertPoint(int x, int y, int z);
	virtual void ResetContour();

			void SetManualContour3VControler(manualContour3VControler *manualcontour3Vcontroler);
			manualContour3VControler *GetManualContour3VControler();

	virtual void MouseDLeft( int x, int y);
			void ResetOrientationPlane();
			void SetVtkInteractorStylePlane2D(InteractorStyleMaracas *vtkinteractorstyleplane2D);
			InteractorStyleMaracas * GetVtkInteractorStylePlane2D();

private:
	bool						_flagMouseMove;
	bool						_flagMouseDClick;
	InteractorStyleMaracas		*_vtkinteractorstyleplane2D;

protected:
	vtkMPRBaseData				*_vtkmprbasedata;
	manualContour3VControler	*_manualcontour3Vcontroler;
};


#endif // manualContourPerpPlaneControler_h
