/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualLineControler.h"

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

// AD:02-09

// _state = 0  // ..nothing..
// _state = 5  // move point
// _state = 6  // move all
// _state = 7  // Empty mouse drag

manualLineControler::manualLineControler()
{
}
// ----------------------------------------------------------------------------
manualLineControler::~manualLineControler()
{
}
// ----------------------------------------------------------------------------
manualLineControler * manualLineControler :: Clone()  // virtual 
{
	manualLineControler * clone = new manualLineControler();
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------
void manualLineControler::CopyAttributesTo( manualLineControler * cloneObject)
{
	// Fathers object
	manualContourBaseControler::CopyAttributesTo(cloneObject);
}


// ----------------------------------------------------------------------------
void manualLineControler::MouseClickLeft(int x, int y){
	int z = GetZ();
	
	if( IsEditable() )
	{	// move control point
  	  if ( (GetState()==0) && (GetManualViewBaseContour()->GetIdPoint(x,y,z)!=-1 ) ){
  		  bakIdPoint = GetManualViewBaseContour()->GetIdPoint(x,y,z);	
		  SetState(5);
	  }
	} //IsEditable
	
	// move contour
	if ((GetState()==0) && (GetManualViewBaseContour()->GetPosibleSelected()==true))	{ 
		GetManualViewBaseContour()->InitMove(x,y,z);
		SetState(6);
	}
	
	// fist time create 2 control points and move a control point
	int size=GetManualViewBaseContour()->GetNumberOfPoints();
	if (GetState()==0) { 
		if (size==0){
			AddPoint(x,y,z); 
			AddPoint(x,y,z); 
			bakIdPoint = GetManualViewBaseContour()->GetIdPoint(x,y,z);	
			SetState(1);
		}
	}
	
	
/*EED 21 Avril 2009		
	if (GetState()==0) { 
		if (size==0){
			AddPoint(x,y,z); 
			AddPoint(x,y,z); 
		} else {
			SetPoint(0,x,y,z); 
			SetPoint(1,x,y,z); 
		}
		bakIdPoint = GetManualViewBaseContour()->GetIdPoint(x,y,z);	
		SetState(5);
	}
*/
	
	GetManualViewBaseContour()->Refresh();
}
// ----------------------------------------------------------------------------

void manualLineControler::MouseMove(int x, int y) // virtual
{
	int z=GetZ();

	GetManualViewBaseContour()->SelectPosibleContour(x,y,z);
	GetManualViewBaseContour()->SelectPosiblePoint(x,y,z);

	if (GetState()==1) { SetPoint( bakIdPoint , x , y ,z); }
	if (GetState()==5) { SetPoint( bakIdPoint , x , y ,z); }
	
	if (GetState()==6)
	{	
		GetManualViewBaseContour()->MoveContour(x,y,z);
	}
	GetManualViewBaseContour()->Refresh();
}


// ----------------------------------------------------------------------------
void manualLineControler::DeleteActualMousePoint(int x, int y)  // virtual
{ 
}
// ----------------------------------------------------------------------------

void manualLineControler::InitRoi(int ww, int hh, double porcentage)
{
	int zz;
	manualPoint *mp;

	if (GetManualContourModel()->GetSizeLstPoints() ==0)
	{
		zz = GetZ();
		AddPoint(0,0,zz);
		AddPoint(0,0,zz);
	}

	double pp1=porcentage;
	double pp2=1-porcentage;

	mp = GetManualContourModel()->GetManualPoint(0);
	zz=(int)mp->GetZ();
	mp->SetPoint(ww*pp2,hh*pp2,zz);

	mp = GetManualContourModel()->GetManualPoint(1);
	zz=(int)mp->GetZ();
	mp->SetPoint(ww*pp2,hh*pp1,zz);

	GetManualViewBaseContour() ->UpdateViewPoint(0);
	GetManualViewBaseContour() ->UpdateViewPoint(1);

	SetState(0);
	GetManualViewBaseContour()->Refresh();	
}	
