/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualView3DContour.h"

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
manualView3DContour::manualView3DContour()
{
}
// ----------------------------------------------------------------------------
manualView3DContour::~manualView3DContour()
{
}

// ----------------------------------------------------------------------------
manualView3DContour * manualView3DContour :: Clone()
{
	manualView3DContour * clone = new manualView3DContour();
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------
void manualView3DContour::CopyAttributesTo( manualView3DContour * cloneObject)
{
	// Fathers object
	manualViewContour::CopyAttributesTo(cloneObject);

	cloneObject->SetDimensions ( _w , _h , _d );
}
// ----------------------------------------------------------------------------
void manualView3DContour::SetDimensions(int w, int h, int d)
{
	_w = w;
	_h = h;
	_d = d;
}
// ----------------------------------------------------------------------------
void manualView3DContour::TransfromCoordViewWorld(double &X, double &Y, double &Z, int type)
{
	X = _vtkmprbasedata->GetX();
	Y = _vtkmprbasedata->GetY();
	Z = _vtkmprbasedata->GetZ();
}
// ----------------------------------------------------------------------------
void manualView3DContour::SetVtkMPRBaseData(vtkMPRBaseData *vtkmprbasedata)
{
	_vtkmprbasedata = vtkmprbasedata;
}
// ----------------------------------------------------------------------------
int manualView3DContour::GetIdPoint2(int x, int y)
{
	int id = -1;
	double p[3],pA[3],pB[3];

	double pickPoint[ 3 ], cameraPos[ 3 ];
	vtkPointPicker* picker = vtkPointPicker::New( );
	vtkRenderer *pRenderer = this->GetWxVtkBaseView()->GetRenderer();
	picker->Pick( x, y, 0.0, pRenderer );
 	pRenderer->GetActiveCamera( )->GetPosition( cameraPos );
	picker->GetPickPosition( pickPoint );
	picker->Delete( );

	UtilVtk3DGeometriSelection utilVtk3Dgeometriselection;
	utilVtk3Dgeometriselection.SetDimentions(_w,_h,_d);

	if( utilVtk3Dgeometriselection.FindCubePointsFromPoints( pA, pB, pickPoint, cameraPos )  )
	{
		double dist,distMin=999999999;
		int i,size=this->_manContModel->GetSizeLstPoints();
		for (i=0;i<size;i++)
		{
			manualPoint *mp = this->_manContModel->GetManualPoint(i);
			p[0] = mp->GetX();
			p[1] = mp->GetY();
			p[2] = mp->GetZ();
			dist=utilVtk3Dgeometriselection.DistanceMinPointToLine(p,pA,pB);
			if ( (dist<=2*GetRange()) && (dist<distMin) )
			{
				distMin = dist;
				id		= i;
			}
		}
	}
	return id;
}
// ----------------------------------------------------------------------------
int manualView3DContour::SelectPosiblePoint ( int x, int y, int z )// virtual
{
	SelectAllPossibleSelected(false);
	int id=GetIdPoint2(x,y);
	if (id!=-1)
	{
		SetPointPosibleSelected(id,true);
	}
	return id;
}

