/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualView3VContour.h"


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

manualView3VContour::manualView3VContour(int type)
{
	_type=type;
// JSTG 25-02-08 ------------------------------
	//_manContModel= new manualContourModel();
//---------------------------------------------
}
// ----------------------------------------------------------------------------
manualView3VContour::~manualView3VContour()
{
}



// ----------------------------------------------------------------------------
manualView3VContour * manualView3VContour :: Clone()
{
	manualView3VContour * clone = new manualView3VContour( GetType() );
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------

void manualView3VContour::CopyAttributesTo( manualView3VContour * cloneObject)
{
	// Fathers object
	manualViewContour::CopyAttributesTo(cloneObject);
}

int manualView3VContour::GetType()
{
	return _type;
}

// ----------------------------------------------------------------------------
void manualView3VContour::FilterCordinateXYZ(double &x,double &y,double &z)
{
	if (_type==0)
	{
		x=-1000;
	}
	if (_type==1)
	{
		y=500;
	}
	if (_type==2)
	{
		z=-1000;
	}
}
// ----------------------------------------------------------------------------

void manualView3VContour::RefreshContour()  // virtula
{
	manualViewContour::RefreshContour();
	int i;
	//EED 27 Juin 2012
    //Boundaring box	
	_minX=99999;
	_minY=99999;
	_minZ=99999;
	_maxX=-99999;
	_maxY=-99999;
	_maxZ=-99999;
	double pp[3];
// JSTG 25-02-08 ----------------------------------------
	//int nps = GetNumberOfPointsSpline();
	int nps = _manContModel->GetNumberOfPointsSpline();
//-------------------------------------------------------
	for( i = 0; i < nps; i++ )
	{
		_pts->GetPoint( i, pp );
		FilterCordinateXYZ(pp[0],pp[1],pp[2]);
//EED 27 sep 2006
		_pts->SetPoint( i, pp[0] , pp[1] ,pp[2] );
		//EED 27 Juin 2012
		//Boundaring box
		if (pp[0] < _minX) { _minX = pp[0]; }
		if (pp[1] < _minY) { _minY = pp[1]; }
		if (pp[2] < _minZ) { _minZ = pp[2]; }
		if (pp[0] > _maxX) { _maxX = pp[0]; }
		if (pp[1] > _maxY) { _maxY = pp[1]; }		
		if (pp[2] > _maxZ) { _maxY = pp[2]; }		
	}// for
//EED 2017-03-02
	if (_pts!=NULL) 
	{ 
		_pts->Modified(); 
	}
}

// ----------------------------------------------------------------------------

void manualView3VContour::UpdateViewPoint(int id){  // virtual
	double x,y,z;
	manualPoint		*mp		= _manContModel->GetManualPoint(id);
	x=mp->GetX();
	y=mp->GetY();
	z=mp->GetZ();

	FilterCordinateXYZ(x,y,z);
	_lstViewPoints[id]->SetPositionXY( x , y ,GetRange(), z );
}

// ----------------------------------------------------------------------------

int	manualView3VContour::GetIdPoint(int x, int y, int z) // virtual
{
	int ii=-1;
	if (_manContModel!=NULL){
		double xx=x;
		double yy=y;
		double zz=z;
		TransfromCoordViewWorld(xx,yy,zz,-1);
		ii=_manContModel->GetIdPoint(xx,yy,zz,GetRange(),_type);
	}
	return ii;
}

// ----------------------------------------------------------------------------
bool manualView3VContour::ifTouchContour(int x,int y,int z){ // virtual
	bool result=false;
	double xx=x;
	double yy=y;
	double zz=z;
	double ppA[3];
	double ppB[3];
	double d1,d2,d3;
	TransfromCoordViewWorld(xx,yy,zz,-1);

//EED 27 sep 2006
	xx = xx * _spc[0];
	yy = yy * _spc[1];
	zz = zz * _spc[2];

	if ( (xx>=_minX) &&  (yy>=_minY) && (xx<=_maxX) && (yy<=_maxY)) {  //  boundaring box	
		unsigned int i, nps,nps_t;
		nps	  = _sizePointsContour;
		if (this->_manContModel->IfCloseContour()==true)
		{
			nps_t = nps;
		} else {
			nps_t = nps-1;
		}
		FilterCordinateXYZ(xx,yy,zz);

		for( i = 0; i < nps_t; i++ ) {
			_pts->GetPoint(i%nps, ppA);
			_pts->GetPoint((i+1)%nps, ppB);
			FilterCordinateXYZ(ppA[0],ppA[1],ppA[2]);
			FilterCordinateXYZ(ppB[0],ppB[1],ppB[2]);
			d1= sqrt( (ppA[0]-xx)*(ppA[0]-xx) + (ppA[1]-yy)*(ppA[1]-yy) + (ppA[2]-zz)*(ppA[2]-zz));
			d2= sqrt( (ppB[0]-xx)*(ppB[0]-xx) + (ppB[1]-yy)*(ppB[1]-yy) + (ppB[2]-zz)*(ppB[2]-zz));
			d3= sqrt( (ppB[0]-ppA[0])*(ppB[0]-ppA[0]) + (ppB[1]-ppA[1])*(ppB[1]-ppA[1]) + (ppB[2]-ppA[2])*(ppB[2]-ppA[2]));
			if (  ((d1+d2)>=d3) &&  ((d1+d2)<=d3*1.3) ) {
				result=true;
				i=nps;
			} // if d1 d2 d3
		}// for i
	} // boundaring box
	return result;
}
