/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualViewBaseContour.h"


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

manualViewBaseContour::manualViewBaseContour()
{
	_show_text			= true;
	_textActor			= NULL;
	_manContModel		= NULL;
	_wxvtkbaseview		= NULL;
	_selected			= false;
	_posibleSelected	= false;
	_viewControlPoints	= false;
	_pts				= NULL;
	_pd					= NULL;
	_contourVtkActor	= NULL;
	_bboxMapper			= NULL;
	_range				= 1;
	_sizePointsContour	= 500;
	_spc[0]				= 1;
	_spc[1]				= 1;
	_spc[2]				= 1;
	_coulorEdit_r		= 1;
	_coulorEdit_g		= 1;
	_coulorEdit_b		= 0;
	_coulorNormal_r		= 1;
	_coulorNormal_g		= 0;
	_coulorNormal_b		= 1;
	_coulorSelection_r	= 0;
	_coulorSelection_g	= 1;
	_coulorSelection_b	= 0;
	_widthline			= 1;
}
// ----------------------------------------------------------------------------
manualViewBaseContour::~manualViewBaseContour()
{
	int i,size=_lstViewPoints.size();
	for (i=0;i<size; i++){
		delete _lstViewPoints[i];
	}
	_lstViewPoints.clear();
}
// ----------------------------------------------------------------------------


int manualViewBaseContour::GetType() // virtual
{
// Information...
//int manualViewBaseContour::GetType()		0;
//int manualViewContour::GetType()			1;
//int manualViewRoi::GetType()				2;
//int manualViewCircle::GetType()			3;
//int manualViewStar::GetType()				4;
//int manualViewLine::GetType()				6;
//int manualViewPoints::GetType()			7;


	return 0;
}
// ----------------------------------------------------------------------------

void manualViewBaseContour::Save(FILE *pFile)
{
	fprintf(pFile,"TypeView %d\n", GetType() );
}

// ----------------------------------------------------------------------------
void manualViewBaseContour::Open(FILE *pFile)
{
}

// ----------------------------------------------------------------------------
void manualViewBaseContour :: AddCompleteContourActor(  bool ifControlPoints )
{
	_viewControlPoints = ifControlPoints;
	 /*vtkRenderer * theRenderer = */  _wxvtkbaseview->GetRenderer();  // JPRx ??
	 //Adding the spline
	 AddSplineActor();
	 AddTextActor();

	 //Adding each control point
	 if( ifControlPoints )
	 {
		AddControlPoints();
 	 }
	 RefreshContour();
	 Refresh();
}
// ---------------------------------------------------------------------------

void manualViewBaseContour::RemoveCompleteContourActor()
{
	/*vtkRenderer * theRenderer =*/  _wxvtkbaseview->GetRenderer(); // JPRx ??
	 //Removing the spline
	RemoveSplineActor();
	RemoveTextActor();

	//Removing each point
	RemoveControlPoints();
	RefreshContour();
	Refresh();
}
// ---------------------------------------------------------------------------
manualViewBaseContour *  manualViewBaseContour :: Clone( )//virtual
{
	manualViewBaseContour * clone = new manualViewBaseContour();
	CopyAttributesTo(clone);
	return clone;

}

// ---------------------------------------------------------------------------

void manualViewBaseContour::CopyAttributesTo( manualViewBaseContour * cloneObject)
{
	// Fathers object
	//XXXX::CopyAttributesTo(cloneObject);

	cloneObject-> SetWxVtkBaseView( this->_wxvtkbaseview );
	cloneObject-> SetSelected( this->GetSelected() );
	cloneObject-> SetPosibleSelected( this->GetPosibleSelected() );
	cloneObject-> SetIfViewControlPoints( this->GetIfViewControlPoints() );
	cloneObject-> SetRange( this->GetRange() );
	cloneObject-> SetZ( this->GetZ() );
	cloneObject-> SetSpacing( _spc );
	cloneObject-> SetColorNormalContour( _coulorNormal_r, _coulorNormal_g, _coulorNormal_b );
	cloneObject-> SetColorEditContour( _coulorEdit_r, _coulorEdit_g, _coulorEdit_b );
	cloneObject-> SetColorSelectContour( _coulorSelection_r, _coulorSelection_g, _coulorSelection_b );

	int i, size = _lstViewPoints.size();
	for ( i=0; i<size; i++ )
	{
		cloneObject->AddPoint(  );
	}
}

// ----------------------------------------------------------------------------
void manualViewBaseContour :: AddSplineActor()
{
	vtkRenderer * theRenderer = _wxvtkbaseview->GetRenderer();
	if (_contourVtkActor!=NULL)
		theRenderer->AddActor( _contourVtkActor  );
}
// ----------------------------------------------------------------------------
void manualViewBaseContour :: RemoveSplineActor() // virtual
{
	vtkRenderer * theRenderer = _wxvtkbaseview->GetRenderer();
	if (_contourVtkActor!=NULL)
		theRenderer->RemoveActor( _contourVtkActor );
}
// ----------------------------------------------------------------------------
void manualViewBaseContour :: RemoveControlPoints()
{
	if (_wxvtkbaseview!=NULL){
		vtkRenderer * theRenderer = _wxvtkbaseview->GetRenderer();
		int i,size=_lstViewPoints.size();
		for (i=0;i<size; i++)
		{
			vtkActor * pointActor = _lstViewPoints[i]->GetVtkActor();
			theRenderer->RemoveActor( pointActor );
		} // for
	} // if
	SetIfViewControlPoints( false );
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::AddControlPoints()
{
	vtkRenderer * theRenderer = _wxvtkbaseview->GetRenderer();
	SetIfViewControlPoints( true );
	 if( _viewControlPoints )
	 {
		int i,size=_lstViewPoints.size();
		for (i=0;i<size; i++)
		{
			vtkActor * pointActor = _lstViewPoints[i]->GetVtkActor();
			theRenderer->AddActor( pointActor );
		}
	 }
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::AddTextActor()
{
	if(_show_text)
	{
		_wxvtkbaseview->GetRenderer()->AddActor2D( _textActor );
		_wxvtkbaseview->GetRenderer()->AddActor2D( _textActor2 );
	}
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::RemoveTextActor()
{
	if(_show_text)
	{
		_wxvtkbaseview->GetRenderer()->RemoveActor2D( _textActor );
		_wxvtkbaseview->GetRenderer()->RemoveActor2D( _textActor2 );
	}
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::DeleteVtkObjects()
{
	if ( _contourVtkActor	!= NULL	)	{ _contourVtkActor  -> Delete(); }
	if ( _bboxMapper		!= NULL	)	{ _bboxMapper		-> Delete(); }
	if ( _pts				!= NULL	)	{ _pts				-> Delete(); }
	if ( _pd				!= NULL	)	{ _pd				-> Delete(); }
	_contourVtkActor	= NULL;
	_bboxMapper			= NULL;
	_pts				= NULL;
	_pd					= NULL;
}


// ----------------------------------------------------------------------------
void manualViewBaseContour::SetWidthLine(double width)
{
	_widthline = width;
	this->UpdateColorActor();

	// for the control points
	int id, size = _lstViewPoints.size();
	for( id=0; id<size; id++)
	{
		this->_lstViewPoints[id]->SetWidthLine(_widthline);
	}

}

// ----------------------------------------------------------------------------
double manualViewBaseContour::GetWidthLine()
{
	return _widthline;
}

// ----------------------------------------------------------------------------
void manualViewBaseContour::ConstructVTKObjects()
{


//JSTG 29-02-08 -----------------------------------------------
	//int i , nps = _sizePointsContour;
	int i;
	int nps = _manContModel->GetNumberOfPointsSpline();
//-------------------------------------------------------------

	DeleteVtkObjects();
	_pts = vtkPoints::New();
	_pts->SetNumberOfPoints(nps);
	for (i=0 ; i<nps ; i++)
	{
		_pts->SetPoint(i,	0	, 0	, 0 );
	}
	// This is for the boundaring inicialisation

//EED 29Mars2009	
	//_pts->SetPoint(0,	0	, 0	, -1000 );
	//_pts->SetPoint(1,	0	, 0	,  1000 );

//EED 2017-03-02
//	_pts->SetPoint(0, 	-1000	, -1000	, -1000 );
//	_pts->SetPoint(1, 	1000	, 1000	, 1000  );

	// This is the structure for the spline
	_splineCell = vtkCellArray::New();
	_splineCell->InsertNextCell( nps /* +1 */ );
	for ( i=0 ; i<nps+1 ; i++ )
	{
		_splineCell->InsertCellPoint(i % nps );
	}

	// This is the structure for the spline justo to points (line)
	// This will be use in the refresh part, in case the spline have only 2 points
	_lineCell = vtkCellArray::New();
	_lineCell->InsertNextCell(2);
	_lineCell->InsertCellPoint(0);
	_lineCell->InsertCellPoint(1);

	_pd = vtkPolyData::New();
	_pd->SetPoints( _pts );
	_pd->SetLines( _splineCell );
	// lines->Delete();  //do not delete lines ??

	_contourVtkActor	=	vtkActor::New();
    _bboxMapper			=	vtkPolyDataMapper::New();
    _bboxMapper->ScalarVisibilityOff( );


//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_bboxMapper->SetInput(_pd);
	_bboxMapper->ImmediateModeRenderingOn();
#else
	_bboxMapper->SetInputData(_pd);
#endif


	_contourVtkActor->SetMapper(_bboxMapper);
	_contourVtkActor->GetProperty()->BackfaceCullingOff();

	UpdateColorActor();

	_pd->ComputeBounds();

	InitTextActor();
}

// ----------------------------------------------------------------------------
void manualViewBaseContour::SetCellArray(bool type)
{
	if (type==true)
	{
		_pd->SetLines( _splineCell );
	} else {
		_pd->SetLines( _lineCell );
	}// if type
}

// ----------------------------------------------------------------------------
void manualViewBaseContour::InitTextActor()
{
	//	Text
	_textActor = vtkTextActor::New();
//	_textActor->SetDisplayPosition(200, 200);
	_textActor->SetInput("00");
	// Set coordinates to match the old vtkScaledTextActor default value
//	_textActor->GetPosition2Coordinate()->SetCoordinateSystemToNormalizedViewport();
//	_textActor->GetPosition2Coordinate()->SetValue( 0.2 , 0.2 );
	_textActor->GetPositionCoordinate()->SetCoordinateSystemToWorld ();
//	_textActor->GetPositionCoordinate()->SetValue( 0.8 , 0.8 );

	vtkTextProperty *tprop = _textActor->GetTextProperty();
	tprop->SetFontSize(12);
	tprop->SetFontFamilyToArial();
	tprop->SetColor(1, 1, 0);


	//	Text 2
	_textActor2 = vtkTextActor::New();
//	_textActor->SetDisplayPosition(200, 200);
	_textActor2->SetInput("00");
	// Set coordinates to match the old vtkScaledTextActor default value
//	_textActor2->GetPosition2Coordinate()->SetCoordinateSystemToNormalizedViewport();
//	_textActor2->GetPosition2Coordinate()->SetValue( 0.2 , 0.2 );
	_textActor2->GetPositionCoordinate()->SetCoordinateSystemToWorld ();
//	_textActor2->GetPositionCoordinate()->SetValue( 0.8 , 0.8 );

	vtkTextProperty *tprop2 = _textActor2->GetTextProperty();
	tprop2->SetFontSize(12);
	tprop2->SetFontFamilyToArial();
	tprop2->SetColor(1, 1, 0);

}

// ----------------------------------------------------------------------------
void manualViewBaseContour::CreateNewContour()
{
	ConstructVTKObjects();
	/*
	_wxvtkbaseview->GetRenderer()->AddActor( _contourVtkActor );
	_wxvtkbaseview->GetRenderer()->AddActor2D(_textActor);*/
	AddCompleteContourActor();
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::UpdateViewPoint(int id) // virtual
{
	manualPoint		*mp		= _manContModel->GetManualPoint(id);

//EEDx6
			double XX=mp->GetX(),YY=mp->GetY(),ZZ=mp->GetZ();
//			wxVtk2DBaseView *wxvtk2Dbasevie = (wxVtk2DBaseView*)this->GetWxVtkBaseView();
//			wxvtk2Dbasevie->TransformCoordinate_spacing_ModelToView(XX,YY,ZZ);

	_lstViewPoints[id]->SetPositionXY( XX , YY ,_range, ZZ );
}

// ----------------------------------------------------------------------------
void manualViewBaseContour::UpdateViewPoints()
{
	int id, size = _lstViewPoints.size();
	for( id=0; id<size; id++)
	{
		UpdateViewPoint( id );
	}
}

// ----------------------------------------------------------------------------
void manualViewBaseContour::AddPoint()
{
	manualViewPoint *mvp	= new manualViewPoint( this->GetWxVtkBaseView() );
	AddPoint( mvp );
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::AddPoint( manualViewPoint * manualViewPoint )
{
	_lstViewPoints.push_back( manualViewPoint );

	// EED 3 oct 2006
	manualViewPoint->SetSpacing(_spc);

	vtkActor *actor = manualViewPoint->CreateVtkPointActor();
	_wxvtkbaseview->GetRenderer()->AddActor( actor );	
}

// ----------------------------------------------------------------------------
void manualViewBaseContour::InsertPoint(int id)
{
	manualViewPoint		*mvp	= new manualViewPoint( this->GetWxVtkBaseView() );

// EED 3 oct 2006
	mvp->SetSpacing(_spc);

	std::vector<manualViewPoint*>::iterator itNum = _lstViewPoints.begin() + id;
	_lstViewPoints.insert(itNum,mvp);
	_wxvtkbaseview->GetRenderer()->AddActor( mvp->CreateVtkPointActor() );
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::DeleteContour()
{
	RemoveCompleteContourActor();
	/*if (_contourVtkActor!=NULL){
		_wxvtkbaseview->GetRenderer()->RemoveActor( _contourVtkActor );
	}*/
	DeleteVtkObjects();
	int i,size=_lstViewPoints.size();
	for (i=0;i<size;i++){
		manualViewBaseContour::DeletePoint(0);
	}
	Refresh();
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::DeletePoint(int id) // virtual
{
	int size=_lstViewPoints.size();
	if ( (id>=0) && (id<size) ){
		manualViewPoint		*mvp	=_lstViewPoints[id];
//EED ups1
//		_handlePicker->DeletePickList(mvp->GetVtkActor());
		_wxvtkbaseview->GetRenderer()->RemoveActor( mvp->GetVtkActor() );
		std::vector<manualViewPoint*>::iterator itNum = _lstViewPoints.begin() + id;
		_lstViewPoints.erase(itNum);
		delete mvp;
		Refresh();
	}
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::DeletePoint(int x, int y, int z)
{
	int id=GetIdPoint(x,y,z);
	if (id!=-1){
		DeletePoint(id);
	}
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::SetSelected(bool selected)
{
	_selected=selected;
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::SetPosibleSelected(bool posibleSelected)
{
	_posibleSelected=posibleSelected;
}
// ----------------------------------------------------------------------------
bool manualViewBaseContour::GetEditable()
{
	return *_editable;
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::SetEditable( bool * condition )
{
	_editable = condition;
}
// ----------------------------------------------------------------------------
bool manualViewBaseContour::GetSelected()
{
	return _selected;
}
// ----------------------------------------------------------------------------
bool manualViewBaseContour::GetPosibleSelected()
{
	return _posibleSelected;
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::DeleteSelectedPoints()
{
	int i,size=_lstViewPoints.size();
	for (i=size-1;i>=0;i--){
		if (_lstViewPoints[i]->GetSelected()==true){
			DeletePoint(i);
		}
	}
	Refresh();
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::SelectPoint(int i, bool select)
{
	_lstViewPoints[i]->SetSelected(select);
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::SelectLstPoints()
{
	// ToDo
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::SelectAllPoints(bool select)
{
	int i,size=_lstViewPoints.size();
	for (i=0;i<size;i++){
		SelectPoint(i,select);
	}
}
//-----------------------------------------------------------------------------
void manualViewBaseContour:: SetIfViewControlPoints(bool ifShow)
{
	_viewControlPoints = ifShow;
}
// ----------------------------------------------------------------------------
bool manualViewBaseContour:: GetIfViewControlPoints()
{
	return _viewControlPoints;
}

// ----------------------------------------------------------------------------
void manualViewBaseContour::SetPointPosibleSelected(int id,bool select)
{
	_lstViewPoints[id]->SetPosibleSelected(select);
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::SetPointSelected(int id,bool select)
{
	_lstViewPoints[id]->SetSelected(select);
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::SelectAllPossibleSelected(bool select)
{
	int i,size=_lstViewPoints.size();
	for (i=0;i<size;i++){
		SetPointPosibleSelected(i,select);
	}
}
// ----------------------------------------------------------------------------
int manualViewBaseContour::SelectPosiblePoint(int x, int y, int z)  // virtual
{
	SelectAllPossibleSelected(false);

    int id = GetIdPoint(x,y,z);
	if (id!=-1)
	{
		SetPointPosibleSelected(id,true);
	}
	return id;
}
// ----------------------------------------------------------------------------
bool manualViewBaseContour::SelectPosibleContour(int x, int y, int z)
{
	bool result=false;
	SetPosibleSelected(result);
    int id = GetIdPoint(x,y,z);
	
	if( !GetEditable() && !_selected && id!= -1)
	{
		result=true;
		_posibleSelected=true;		
	}
	else
	{
		if ( (GetEditable()==true) && (id==-1 ) && (this->_lstViewPoints.size()>=2) )
		{
			if (ifTouchContour(x,y,z)==true)
			{
				result=true;
				SetPosibleSelected(result);
			}
		}

		if (GetEditable()==false)
		{
			if (ifTouchContour(x,y,z)==true)
			{
				result=true;
				SetPosibleSelected(result);
			}
		}
	}
	return result;
}
// ----------------------------------------------------------------------------
bool manualViewBaseContour::ifTouchContour(int x,int y, int z) // virtual
{
	return false;
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::UnSelectPoint(int i){
	_lstViewPoints[i]->SetSelected(false);
	Refresh();
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::UnSelectLstPoints(){
	// ToDo
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::UnSelectAllPoints(){
	int i,size=_lstViewPoints.size();
	for (i=0;i<size;i++){
		UnSelectPoint(i);
	}
	Refresh();
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::SetModel(manualBaseModel *manContModel){
	_manContModel=manContModel;
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::SetWxVtkBaseView(wxVtkBaseView *wxvtkbaseview){
	_wxvtkbaseview = wxvtkbaseview;
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::RefreshContour()  // Virtual
{
}
// ----------------------------------------------------------------------------
double* manualViewBaseContour::GetVectorPointsXManualContour(){
	double pp[3];
	int i,size = _sizePointsContour;
	double *vx = (double*)malloc(sizeof(double)*size);
	for (i=0;i<size;i++)
	{
		_pts->GetPoint(i,pp);
		vx[i]=pp[0];
	} // for i
	return vx;
}
// ----------------------------------------------------------------------------
double* manualViewBaseContour::GetVectorPointsYManualContour()
{
	double pp[3];
	int i,size = _sizePointsContour;
	double *vy = (double*)malloc(sizeof(double)*size);
	for (i=0;i<size;i++)
	{
		_pts->GetPoint(i,pp);
		vy[i]=pp[1];
	} // for i
	return vy;
}
// ----------------------------------------------------------------------------
double* manualViewBaseContour::GetVectorPointsZManualContour()
{
	double pp[3];
	int i,size = _sizePointsContour;
	double *vz = (double*)malloc(sizeof(double)*size);
	for (i=0;i<size;i++)
	{
		_pts->GetPoint(i,pp);
		vz[i]=pp[2];
	} // for i
	return vz;
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::Refresh() // virtual
{
	if (_contourVtkActor!=NULL)
	{
		RefreshContour();
	}
	int i,size=_lstViewPoints.size();
	for (i=0;i<size;i++)
	{
		UpdateViewPoint(i);
		_lstViewPoints[i]->UpdateColorActor();
	} // for i
	UpdateColorActor();

	if (_show_text==true)
	{
		RefreshText();
	}

	vtkRenderWindowInteractor *vri = _wxvtkbaseview->GetWxVTKRenderWindowInteractor ();
	if (vri==NULL)
	{
		_wxvtkbaseview->GetRenWin()->Render();
		printf("EED %p How to optimize manualViewBaseContour::Refresh() \n",this);
	}

}
// ----------------------------------------------------------------------------
void manualViewBaseContour::RefreshText()  // virtual
{
	if( _textActor!=NULL)
	{
		_textActor -> SetInput("00");
		_textActor2 -> SetInput("00");
	}
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::SetColorNormalContour(double r, double g, double b)
{
	_coulorNormal_r = r;
	_coulorNormal_g = g;
	_coulorNormal_b = b;
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::GetColorNormalContour(double &r, double &g, double &b)
{
	r = _coulorNormal_r;
	g = _coulorNormal_g;
	b = _coulorNormal_b;
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::SetColorEditContour(double r, double g, double b)
{
	_coulorEdit_r = r;
	_coulorEdit_g = g;
	_coulorEdit_b = b;
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::GetColorEditContour(double &r, double &g, double &b)
{
	r = _coulorEdit_r;
	g = _coulorEdit_g;
	b = _coulorEdit_b;
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::SetColorSelectContour(double r, double g, double b)
{
	_coulorSelection_r = r;
	_coulorSelection_g = g;
	_coulorSelection_b = b;
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::GetColorSelectContour(double &r, double &g, double &b)
{
	r = _coulorSelection_r;
	g = _coulorSelection_g;
	b = _coulorSelection_b;
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::UpdateColorActor()
{
	if (_contourVtkActor!=NULL)
	{
		_contourVtkActor->GetProperty()->SetLineWidth( _widthline );
  		_contourVtkActor->GetProperty()->SetDiffuseColor( _coulorNormal_r , _coulorNormal_g , _coulorNormal_b );
		if (_posibleSelected || (_posibleSelected && GetEditable() ) )
		{
			_contourVtkActor->GetProperty()->SetDiffuseColor( _coulorEdit_r , _coulorEdit_g , _coulorEdit_b );
		}
		if( _selected )
		{
			_contourVtkActor->GetProperty()->SetDiffuseColor( _coulorSelection_r , _coulorSelection_g , _coulorSelection_b );
		}
	}
}
// ----------------------------------------------------------------------------
int	manualViewBaseContour::GetIdPoint(int x, int y, int z) // virtual
{
	int ii = -1;
	if (_manContModel!=NULL){
		double xx = x;
		double yy = y;
		double zz = z;
		TransfromCoordViewWorld(xx,yy,zz);
		ii=_manContModel->GetIdPoint(xx,yy,zz,_range,-1);
	}
	return ii;
}

// ----------------------------------------------------------------------------


int manualViewBaseContour::GetNumberOfPoints()
{
	return _lstViewPoints.size();
}

// ----------------------------------------------------------------------------

//JSTG 25-02-08 ---------------------------------------------------------------
/*int manualViewBaseContour::GetNumberOfPointsSpline()
{
	return _sizePointsContour;
}*/
//----------------------------------------------------------------------------

//JSTG 25-02-08 ---------------------------------------------------------------
/*void manualViewBaseContour::SetNumberOfPointsSpline(int size)
{
	_sizePointsContour = size;
}*/
//----------------------------------------------------------------------------
// virtual
void manualViewBaseContour::TransfromCoordViewWorld(double &X, double &Y, double &Z, int type)  // Virtual
{
	_wxvtkbaseview->TransFromCoordScreenToWorld(X, Y, Z,false, type);


//EED 27 sep 2007
//   //EEDx6
//	wxVtk2DBaseView *wxvtk2Dbaseview = (wxVtk2DBaseView*)_wxvtkbaseview;
//	wxvtk2Dbaseview->TransformCoordinate_spacing_ModelToView(X,Y,Z);

}
// ----------------------------------------------------------------------------
void manualViewBaseContour::SetRange(double range)
{
	_range=range;
}
// ----------------------------------------------------------------------------
double	manualViewBaseContour::GetRange()
{
	return _range;
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::SetZ(int z)
{
//	_Z=z;
}
// ----------------------------------------------------------------------------
int	manualViewBaseContour::GetZ()
{
//	return _Z;
	return 0;
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::InitMove(int x, int y, int z) // virtual
{

}
// ----------------------------------------------------------------------------
void manualViewBaseContour::MoveContour(int x, int y, int z) // virtual
{
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::MoveContour(int horizontalUnits, int verticalUnits )// virtual
{

}
// ----------------------------------------------------------------------------
void manualViewBaseContour::GetMinMax( double &minX,double &minY, double &minZ, double &maxX, double &maxY, double &maxZ )// virtual
{
	double	pp[3];
	manualPoint *mp;
	int i;
	int size=_manContModel->GetSizeLstPoints();
	minX=99999;
	minY=99999;
	maxX=-99999;
	maxY=-99999;
	bool ifFindZ = minZ!=-1.0 && maxZ!=-1.0;
	if ( ifFindZ )
	{
		minZ=99999;
		maxZ=-99999;
	}
	for( i = 0; i < size; i++ )
	{
		mp=_manContModel->GetManualPoint(i);
		pp[0]=mp->GetX();
		pp[1]=mp->GetY();
		if ( ifFindZ )
			pp[2]=mp->GetZ();

		// min X
		if (pp[0]<minX)
		{
			minX=pp[0];
		}
		//min Y
		if (pp[1]<minY)
		{
			minY=pp[1];
		}
		//max X
		if (pp[0]>maxX)
		{
			maxX=pp[0];
		}
		// max Y
		if (pp[1]>maxY)
		{
			maxY=pp[1];
		}
		if ( ifFindZ )
		{
			// min Z
			if (pp[2]<minZ)
			{
				minZ=pp[2];
			}
			// max Z
			if (pp[2]>maxZ)
			{
				maxZ=pp[2];
			}
		}
	}
	if ( size<1 )
	{
		minX = 0;
		maxX = 0;

		minY = 0;
		maxY = 0;

		minZ = 0;
		maxZ = 0;
	}
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::ClearContour()
{
	if (_contourVtkActor!=NULL){
		_wxvtkbaseview->GetRenderer()->RemoveActor( _contourVtkActor );
	}
	DeleteVtkObjects();
	int i,size=_lstViewPoints.size();
	for (i=0;i<size;i++){
		ClearPoint(0);
	}
	Refresh();
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::ClearPoint(int id)
{
	DeletePoint(id);
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::SetVisible(bool ok)
{
	double opacity;
	if (ok==true)
	{
		opacity=1;
	} else {
		opacity=0.5;
	}
	vtkActor *actor;
	int i,size=_lstViewPoints.size();
	for (i=0;i<size;i++){
		actor = _lstViewPoints[i]->GetVtkActor();
		actor->GetProperty()->SetOpacity( opacity );
	}
	_contourVtkActor->GetProperty()->SetOpacity( opacity );
	_textActor->GetProperty()->SetOpacity( opacity );
	_textActor->SetInput("00");
	_textActor2->GetProperty()->SetOpacity( opacity );
	_textActor2->SetInput("00");

}
// ----------------------------------------------------------------------------
void manualViewBaseContour::SetShowText(bool ok)
{
	_show_text = ok;
	if (_show_text==false && _textActor!=NULL)
	{
		_textActor->SetInput("");
		_textActor2->SetInput("");
	}
}
// ----------------------------------------------------------------------------
wxVtkBaseView *manualViewBaseContour::GetWxVtkBaseView()
{
	return this->_wxvtkbaseview;
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::GetSpacing(double spc[3])
{
	spc[0] = _spc[0];
	spc[1] = _spc[1];
	spc[2] = _spc[2];
}
// ----------------------------------------------------------------------------
void manualViewBaseContour::SetSpacing(double spc[3])
{
	_spc[0] = spc[0];
	_spc[1] = spc[1];
	_spc[2] = spc[2];
}
