/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualViewBullEye.h"

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

manualViewBullEye::manualViewBullEye()
{
}

// ----------------------------------------------------------------------------
manualViewBullEye::~manualViewBullEye()
{
	// BullEye(s)
	int i,size=lstSectorBullEye.size();
	for (i=0;i<size;i++)
	{
		delete lstSectorBullEye[i];
	}
	lstSectorBullEye.clear();
}


// ----------------------------------------------------------------------------
manualViewBullEye * manualViewBullEye :: Clone()
{
	manualViewBullEye * clone = new manualViewBullEye();
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------

void manualViewBullEye::CopyAttributesTo( manualViewBullEye * cloneObject)
{
	// Fathers object
	manualViewBaseContour::CopyAttributesTo(cloneObject);
}


// ----------------------------------------------------------------------------
int manualViewBullEye::GetType() // virtual
{
	return 4;
}


// ----------------------------------------------------------------------------
void manualViewBullEye::RefreshContour() // virtual
{
	// External Rectangle
	manualViewRoi::RefreshContour();

	_manContModel->UpdateSpline();
    int np	= GetNumberOfPoints( );
	// Refres sectors of BullEye(s)

	if (np>=2  )
	{
		int i,size = lstSectorBullEye.size();
		for (i=0;i<size;i++)
		{
			lstSectorBullEye[i]->RefreshContour();
		} // for
	} // if


}

// ----------------------------------------------------------------------------
void manualViewBullEye::ConstructVTKObjects() // virtual
{
	manualViewRoi::ConstructVTKObjects();

	double spc[3];
	this->GetSpacing(spc);
	manualViewBullEyeSector *mvbc;
	manualContourModelBullEye *mcmbe = (manualContourModelBullEye*)this->_manContModel;
	int i,size = mcmbe->GetSizeOfSectorLst();
	for ( i=0 ; i<size ; i++ )
	{
		mvbc = new manualViewBullEyeSector();
		mvbc->SetModel( mcmbe->GetModelSector(i) );
		mvbc->SetWxVtkBaseView( this->GetWxVtkBaseView()  );
		mvbc->SetRange( 2 );
		mvbc->SetZ( 1000 );
		mvbc->SetSpacing(spc);
		mvbc->SetColorNormalContour(1, 0, 0);
//		mvbc->SetColorEditContour(0.5, 0.5, 0.5);
//		mvbc->SetColorSelectContour(1, 0.8, 0);
		mvbc->SetWidthLine( this->GetWidthLine()  );
//EED004
		mvbc->ConstructVTKObjects();
		lstSectorBullEye.push_back( mvbc );
	}


}

// ----------------------------------------------------------------------------
void manualViewBullEye::AddSplineActor()  // virtual
{
	manualViewRoi::AddSplineActor();
	int i,size=lstSectorBullEye.size();
	for (i=0;i<size;i++)
	{
		lstSectorBullEye[i]->AddSplineActor();
	}
}

// ----------------------------------------------------------------------------
void manualViewBullEye::RemoveSplineActor()  // virtual
{
	manualViewRoi::RemoveSplineActor();
	int i,size=lstSectorBullEye.size();
	for (i=0;i<size;i++)
	{
		lstSectorBullEye[i]->RemoveSplineActor();
	}
}
