/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualViewCircle.h"


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

manualViewCircle::manualViewCircle()
{
//	_sizePointsContour=5;   // default 100
}
// ----------------------------------------------------------------------------
manualViewCircle::~manualViewCircle()
{
}

// ----------------------------------------------------------------------------
manualViewCircle * manualViewCircle :: Clone()
{
	manualViewCircle * clone = new manualViewCircle();
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------
void manualViewCircle::CopyAttributesTo( manualViewCircle * cloneObject)
{
	// Fathers object
	manualViewBaseContour::CopyAttributesTo(cloneObject);
}

// ----------------------------------------------------------------------------
int manualViewCircle::GetType() // virtual
{
	return 3;
}

// ----------------------------------------------------------------------------

void manualViewCircle::GetMinMax(double &minX,double &minY, double &maxX, double &maxY)
{
	manualPoint	*mpA,*mpB;
    unsigned int  np;
	double radio;
	double difX,difY;
    np	= GetNumberOfPoints( );
	if (np==2)
	{
		mpA		= _manContModel->GetManualPoint(0);
		mpB		= _manContModel->GetManualPoint(1);
		difX	= mpA->GetX() - mpB->GetX();
		difY	= mpA->GetY() - mpB->GetY();
		radio	= sqrt( difX*difX + difY*difY );
		minX=mpA->GetX()-radio;
		minY=mpA->GetY()-radio;
		maxX=mpA->GetX()+radio;
		maxY=mpA->GetY()+radio;
	} else {
		minX	= 0;
		maxX	= 0;
		minY	= 0;
		maxY	= 0;
	} // if np
}


// ----------------------------------------------------------------------------

void manualViewCircle::InitMove(int x, int y, int z)  // virtual
{
	manualPoint *mp;
	double 		XX = x;
	double 		YY = y;
	double 		ZZ = z;
	TransfromCoordViewWorld(XX,YY,ZZ);
	if (_manContModel->GetSizeLstPoints()==2)
	{
		mp = _manContModel->GetManualPoint(0);
		_dp0[0] = mp->GetX() - XX;
		_dp0[1] = mp->GetY() - YY;
		_dp0[2] = mp->GetZ();
		mp 		= _manContModel->GetManualPoint(1);
		_dp1[0] = mp->GetX() - XX;
		_dp1[1] = mp->GetY() - YY;
		_dp1[2] = mp->GetZ();
/*
		mp = _manContModel->GetManualPoint(2);
		_dp2[0]= mp->GetX() - XX;
		_dp2[1]= mp->GetY() - YY;
		_dp2[2]= mp->GetZ();
		mp = _manContModel->GetManualPoint(3);
		_dp3[0]= mp->GetX() - XX;
		_dp3[1]= mp->GetY() - YY;
		_dp3[2]= mp->GetZ();
*/
	} // if 
}

// ----------------------------------------------------------------------------
void manualViewCircle::MoveContour(int x, int y, int z) // virtual
{
printf("EED  manualViewCircle::MoveContour %p \n", this);
	manualPoint *mp;
	double XX=x;
	double YY=y;
	double ZZ=z;
	TransfromCoordViewWorld(XX,YY,ZZ);
	mp = _manContModel->GetManualPoint(0);
	mp->SetPoint(_dp0[0]+XX,_dp0[1]+YY,_dp0[2]);
	mp = _manContModel->GetManualPoint(1);
	mp->SetPoint(_dp1[0]+XX,_dp1[1]+YY,_dp0[2]);
//	mp = _manContModel->GetManualPoint(2);
//	mp->SetPoint(_dp2[0]+XX,_dp2[1]+YY,_dp0[2]);
//	mp = _manContModel->GetManualPoint(3);
//	mp->SetPoint(_dp3[0]+XX,_dp3[1]+YY,_dp0[2]);
	UpdateViewPoint(0);
	UpdateViewPoint(1);
//	UpdateViewPoint(2);
//	UpdateViewPoint(3);
}

// ----------------------------------------------------------------------------
bool manualViewCircle::ShowLineVersion()
{
	return false;
}


