/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualViewContour.h"

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

manualViewContour::manualViewContour()
{
	_id_viewPoint_for_text	= 0;
	_initialConoturModel	= new manualContourModel();	
	_minX					= 99999;
	_minY					= 99999;
	_maxX					= -99999;
	_maxY					= -99999;
	
}
// ----------------------------------------------------------------------------
manualViewContour::~manualViewContour()
{
	delete _initialConoturModel;
}
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
manualViewContour * manualViewContour :: Clone()
{
	manualViewContour * clone = new manualViewContour();
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------

void manualViewContour::CopyAttributesTo( manualViewContour * cloneObject)
{
	// Call to Fathers object
	manualViewBaseContour::CopyAttributesTo(cloneObject);
}

// ---------------------------------------------------------------------------

int manualViewContour::GetType() // virtual
{
	return 1;
}

// ----------------------------------------------------------------------------

void manualViewContour::Save(FILE *pFile)
{
	manualViewBaseContour::Save(pFile);
}

// ----------------------------------------------------------------------------
void manualViewContour::Open(FILE *pFile)
{
}

// ----------------------------------------------------------------------------
bool manualViewContour::ShowLineVersion()   // virtual
{
	bool result = false;
    int np	= GetNumberOfPoints( );
	if (np==2) 
	{
		result=true;
	}
	return result;
}

// ----------------------------------------------------------------------------
void manualViewContour::RefreshContour() // virtual
{
	int i,nps;
//JSTG 25-02-08 --------------------
	//double t,delta, x,y,z;
	double x,y,z;
	double xx,yy,zz;
//----------------------------------
	if ( ShowLineVersion()==true ) 
	{
		SetCellArray(false);
		manualPoint *mpA = _manContModel->GetManualPoint(0);
		manualPoint *mpB = _manContModel->GetManualPoint(1);		
		if ( _pts!=NULL )
		{
			xx		= mpA->GetX() * _spc[0];
			yy		= mpA->GetY() * _spc[1];
			zz		= mpA->GetZ() * _spc[2];
			_minX	= xx;
			_minY	= yy;
			_maxX	= xx;
			_maxY	= yy;
			_pts->SetPoint(0 , xx , yy , zz  );
			xx=mpB->GetX() * _spc[0];
			yy=mpB->GetY() * _spc[1];
			zz=mpB->GetZ() * _spc[2];
			if (xx<_minX) _minX=xx;
			if (yy<_minY) _minY=yy;
			if (xx>_maxX) _maxX=xx;
			if (yy>_maxY) _maxY=yy;
			_pts->SetPoint(1 , xx , yy , zz  );
		} // if _pts!=NULL
	} else {
		SetCellArray(true);
		_manContModel->UpdateSpline();
		//nps = GetNumberOfPointsSpline();
		nps = _manContModel->GetNumberOfPointsSpline();
		//delta=( double ) ( np  ) / ( double ) ( nps-1  );		//JSTG 25-02-08

		//EED 27 Juin 2012
		//Boundaring box	
		_minX = 99999;
		_minY = 99999;
		_maxX = -99999;
		_maxY = -99999;
		if ( _pts!=NULL )
		{
		    int np	= GetNumberOfPoints( );
			if (np>=2  )
			{
				for( i = 0; i < nps; i++ )
				{
	//JSTG 25-02-08 ------------------------------------------------
					//t = delta * (double)i;
					//_manContModel->GetSplinePoint(t,x,y,z);
					_manContModel->GetSpline_i_Point(i,&x,&y,&z);
	//--------------------------------------------------------------
		// EED 27 sep 2006
		//			_pts->SetPoint(i, x,y,z );
					xx = x*_spc[0];
					yy = y*_spc[1];
					zz = z*_spc[2];
					_pts->SetPoint(i,xx,yy,zz );

		            //EED 27 Juin 2012
					//Boundaring box
					if (xx < _minX) { _minX = xx; }
					if (yy < _minY) { _minY = yy; }
					if (xx > _maxX) { _maxX = xx; }
					if (yy > _maxY) { _maxY = yy; }
				}// for
			}else{
					_pts->SetPoint(0, 0 , 0 , 0);
					_pts->SetPoint(1, 0 , 0 , 0);
			} // if
		} // _pts!=NULL
	} //np==2
	_minX = _minX-1.0;
	_minY = _minY-1.0;
	_maxX = _maxX+1.0;
	_maxY = _maxY+1.0;

//EED 2017-03-02
	if (_pts!=NULL) 
	{
		_pts->Modified();
	}
}

// ----------------------------------------------------------------------------
void manualViewContour::RefreshText()  // virtual
{
	if ((_textActor!=NULL) && ( _textActor->GetProperty()->GetOpacity()!=0 )){
		int size = GetNumberOfPoints();
		char text[50];
		char resultText[250];
		strcpy(resultText, "000");
		char resultText2[250];
		strcpy(resultText2, "000");
		double spcP[3];
		spcP[0] = 1;
		spcP[1] = 1;
		spcP[2] = 1;

//CMRU 19-08-09 ----------------------------------
		std::string label 	= _manContModel->GetLabel();
		std::string label2 	= " (" + _manContModel->GetLabel2() + "z) ";
// ------------------------------------
	
		if (size==2)
		{
			strcpy(resultText,"L= ");
			gcvt ( this->_manContModel->GetPathSize( spcP ), 5, text );
			strcat(resultText,text);
			strcat(resultText,"p");

//CMRU 19-08-09 ----------------------------------
			strcat(resultText," ");
			strcat(resultText,label.c_str());

			strcpy(resultText2,"L= ");
			gcvt ( this->_manContModel->GetPathSize( _spc ), 5, text );
			strcat(resultText2,text);
			strcat(resultText2,"u");

//------------------------------------------------
		}
		if (size>2)
		{
			if (_manContModel->IfCloseContour()==true)
			{
				strcpy(resultText,"P= ");
				gcvt ( this->_manContModel->GetPathSize( spcP ), 5, text );
				strcat(resultText,text);
				strcat(resultText,"p");

				gcvt ( this->_manContModel->GetPathArea( spcP ), 5, text );
				strcat(resultText,"   A= ");
				strcat(resultText,text);
				strcat(resultText,"p^2 ");


				strcpy(resultText2,"P= ");
				gcvt ( this->_manContModel->GetPathSize( _spc ), 5, text );
				strcat(resultText2,text);
				strcat(resultText2,"u");

				gcvt ( this->_manContModel->GetPathArea( _spc ), 5, text );
				strcat(resultText2,"   A= ");
				strcat(resultText2,text);
				strcat(resultText2,"u^2 ");

			} else {
				strcpy(resultText,"L= ");
				gcvt ( this->_manContModel->GetPathSize( spcP ), 5, text );
				strcat(resultText,text);
				strcat(resultText,"p");

				strcpy(resultText2,"L= ");
				gcvt ( this->_manContModel->GetPathSize( _spc ), 5, text );
				strcat(resultText2,text);
				strcat(resultText2,"u");
			}
//CMRU 19-08-09 ----------------------------------
			strcat(resultText,label2.c_str());
			strcat(resultText,label.c_str());
//------------------------------------------------
		}

		_textActor->SetInput(resultText);
		_textActor2->SetInput(resultText2);
		
		if (size>=1)
		{
			int i;
			for (i=0; i<size; i++)
			{
				if (_lstViewPoints[i]->GetPosibleSelected()==true)
				{
					_id_viewPoint_for_text = i;
				} // if
			} // for
			if (_id_viewPoint_for_text>=size) 
			{
				_id_viewPoint_for_text = 0;
			}// if
			double px = _manContModel->GetManualPoint(_id_viewPoint_for_text)->GetX();
			double py = _manContModel->GetManualPoint(_id_viewPoint_for_text)->GetY();
			//EED 27 sep 2006
			px = px*_spc[0];
			py = py*_spc[1];
			_textActor->SetPosition(px+GetRange()+1,py);
			_textActor2->SetPosition(px+GetRange()+1,py+2);
		} // if size
	}
}

// ----------------------------------------------------------------------------
bool manualViewContour::ifTouchContour(int x,int y,int z)
{
	bool result	= false;
	double xx	= x;
	double yy	= y;
	double zz	= z;
	double ppA[3];
	double ppB[3];
	double d1,d2,d3;
	TransfromCoordViewWorld(xx,yy,zz);
//EED 27 sep 2006
	xx = xx * _spc[0];
	yy = yy * _spc[1];
	zz = zz * _spc[2];
	if ( (xx>=_minX) &&  (yy>=_minY) && (xx<=_maxX) && (yy<=_maxY)) 
	{  // inside the boundaring box
		if ( ShowLineVersion()==true )
		{
			_pts->GetPoint(0, ppA);
			_pts->GetPoint(1, ppB);
			double dirVec[3];
			// direction of the segment
            dirVec[0] = ppB[0] - ppA[0];
            dirVec[1] = ppB[1] - ppA[1];
            dirVec[2] = ppB[2] - ppA[2];
			// proj = mpA + k*dirVec
			double num;
			double den = 0.0 ;

			num	= dirVec[0]*( xx-ppA[0] );
			num	= num + dirVec[1]*( yy-ppA[1] );
			num	= num + dirVec[2]*( zz-ppA[2] );

			den=dirVec[0]*dirVec[0] + dirVec[1]*dirVec[1] + dirVec[2]*dirVec[2];
			double k;
			if (den!=0) 
			{
				k = num/den;
			} else {
				k = 99999999;
			}
			// projection of th point xx,yy,zz  in segment mpA,mpB
			double projX = ppA[0] + k*dirVec[0];
			double projY = ppA[1] + k*dirVec[1];
			double projZ = ppA[2] + k*dirVec[2];


			// distance [projX,projY,projZ]   and   (xx,yy,zz]
			double d1= sqrt(  (projX-xx)*(projX-xx) + (projY-yy)*(projY-yy) +(projZ-zz)*(projZ-zz) );
			if (d1<=1)
			{ 
				result=true;
			} // if d1
		} else {
			unsigned int i, nps,nps_t;
			nps	  = _sizePointsContour;
			if (this->_manContModel->IfCloseContour()==true)
			{
				nps_t = nps;
			} else {
				nps_t = nps-1;
			} // if close
			for( i = 0; i < nps_t; i++ ) 
			{
				_pts->GetPoint(i%nps, ppA);
				_pts->GetPoint((i+1)%nps, ppB);
				d1 = sqrt( (ppA[0]-xx)*(ppA[0]-xx) + (ppA[1]-yy)*(ppA[1]-yy) + (ppA[2]-zz)*(ppA[2]-zz));
				d2 = sqrt( (ppB[0]-xx)*(ppB[0]-xx) + (ppB[1]-yy)*(ppB[1]-yy) + (ppB[2]-zz)*(ppB[2]-zz));
				d3 = sqrt( (ppB[0]-ppA[0])*(ppB[0]-ppA[0]) + (ppB[1]-ppA[1])*(ppB[1]-ppA[1]) + (ppB[2]-ppA[2])*(ppB[2]-ppA[2]));
				if (  ((d1+d2)>=d3) &&  ((d1+d2)<=d3*1.3) ) 
				{
					result	= true;
					i		= nps;
				} // if
			} // for i
		} // if GetSizeLstPoints()==2
	} // if min max
	return result;
}

// ----------------------------------------------------------------------------
void manualViewContour::DeletePoint(int id) // virtual
{
	if (_lstViewPoints.size()>2)
	{
		manualViewBaseContour::DeletePoint( id );
	}
}
// ----------------------------------------------------------------------------

void manualViewContour::ClearPoint(int id)
{
	manualViewBaseContour::DeletePoint( id );
}

//-------------------------------------------------------------------
void manualViewContour::InitMove(int x, int y, int z)
{
	_initialConoturModel->DeleteAllPoints();

	manualPoint *mp = NULL;
	double XX=x;
	double YY=y;
	double ZZ=z;
	TransfromCoordViewWorld(XX,YY,ZZ);

	int i, manualPointsSZ = _manContModel->GetSizeLstPoints();
	for ( i=0; i<manualPointsSZ; i++ )
	{
		mp = _manContModel->GetManualPoint( i );
		this->_initialConoturModel->AddPoint( mp->GetX() - XX, mp->GetY() - YY, mp->GetZ() );
	}
}

//-------------------------------------------------------------------
void manualViewContour::MoveContour(int x, int y, int z)
{
	manualPoint *mpOrigin = NULL;
	manualPoint *mpMoving = NULL;
	double XX = x;
	double YY = y;
	double ZZ = z;

	TransfromCoordViewWorld(XX,YY,ZZ);

	int i, manualPointsSZ = _manContModel->GetSizeLstPoints();
	for ( i=0; i<manualPointsSZ; i++ )
	{
		mpOrigin = _manContModel->GetManualPoint( i );
		mpMoving = _initialConoturModel->GetManualPoint(i);
		mpOrigin->SetPoint( mpMoving->GetX()+XX, mpMoving->GetY() + YY, mpMoving->GetZ() );
	}
	UpdateViewPoints();
}

//-------------------------------------------------------------------
void manualViewContour::MoveContour(int horizontalUnits, int verticalUnits )
{
	manualPoint *mpOrigin = NULL;

	int i, manualPointsSZ = _manContModel->GetSizeLstPoints();
	for ( i=0; i<manualPointsSZ; i++ )
	{
		mpOrigin = _manContModel->GetManualPoint( i );
		mpOrigin->SetPoint( mpOrigin->GetX()+horizontalUnits, mpOrigin->GetY()+verticalUnits, mpOrigin->GetZ() );
	}
	UpdateViewPoints();
}
