/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef manualViewContour_h
#define manualViewContour_h

#include "manualContourModel.h"
#include "manualViewBaseContour.h"

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

class creaMaracasVisu_EXPORT manualViewContour: public manualViewBaseContour
{
public:
	manualViewContour();
	virtual ~manualViewContour();
	virtual manualViewContour * Clone();
	void CopyAttributesTo( manualViewContour *cloneObject );
	virtual int  GetType();
	virtual void Save(FILE *pFile);
	virtual void Open(FILE *pFile);
	virtual	bool ShowLineVersion();
	virtual void RefreshContour();
	virtual bool ifTouchContour(int x,int y, int z);
	virtual void InitMove(int x, int y, int z);
	virtual void MoveContour(int x, int y, int z);	
	virtual void MoveContour(int horizontalUnits, int verticalUnits );
	virtual void DeletePoint(int id); 
	virtual void ClearPoint(int id);
private:
	std::vector< std::vector<double> > _initialMovingPoints;
	manualContourModel * _initialConoturModel;
	virtual void	RefreshText();
protected:
	double _minX;
	double _minY;
	double _minZ;
	double _maxX;
	double _maxY;
	double _maxZ;	
};

#endif // manualViewContour_h
