/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualViewLine.h"


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

// AD:02-09

manualViewLine::manualViewLine()
{
	_sizePointsContour=20;
}
// ----------------------------------------------------------------------------
manualViewLine::~manualViewLine()
{
}

// ----------------------------------------------------------------------------
manualViewLine * manualViewLine :: Clone()
{
	manualViewLine * clone = new manualViewLine();
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------
void manualViewLine::CopyAttributesTo( manualViewLine * cloneObject)
{
	// Fathers object
	manualViewBaseContour::CopyAttributesTo(cloneObject);
}

// ----------------------------------------------------------------------------
int manualViewLine::GetType() // virtual
{
	return 6;
}

// ----------------------------------------------------------------------------
void manualViewLine::InitMove(int x, int y, int z)  // virtual
{
	manualPoint *mp;
	double XX=x;
	double YY=y;
	double ZZ=z;
	TransfromCoordViewWorld(XX,YY,ZZ);
	if (_manContModel->GetSizeLstPoints()==2)
	{
		mp = _manContModel->GetManualPoint(0);
		_dp0[0] = mp->GetX() - XX;
		_dp0[1] = mp->GetY() - YY;
		_dp0[2] = mp->GetZ();
		mp = _manContModel->GetManualPoint(1);
		_dp1[0] = mp->GetX() - XX;
		_dp1[1] = mp->GetY() - YY;
		_dp1[2] = mp->GetZ();
	} // if
}

// ----------------------------------------------------------------------------
void manualViewLine::MoveContour(int x, int y, int z) // virtual 
{
	manualPoint *mp;
	double 		XX = x;
	double 		YY = y;
	double 		ZZ = z;
	TransfromCoordViewWorld(XX,YY,ZZ);
	mp = _manContModel->GetManualPoint(0);
	mp->SetPoint(_dp0[0]+XX,_dp0[1]+YY,_dp0[2]);
	mp = _manContModel->GetManualPoint(1);
	mp->SetPoint(_dp1[0]+XX,_dp1[1]+YY,_dp0[2]);
	UpdateViewPoint(0);
	UpdateViewPoint(1);
}

