/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualViewPoint.h"

// ----------------------------------------------------------------------------
manualViewPoint::manualViewPoint(wxVtkBaseView *wxvtkbaseview){
	_selected		 = false;
	_posibleSelected = false;
	_pts			 = NULL;
	_pd				 = NULL;
	_pointVtkActor	 = NULL;
	_bboxMapper		 = NULL;
	_wxvtkbaseview	 = wxvtkbaseview;
	_spc[0]			 = 1;
	_spc[1]			 = 1;
	_spc[2]			 = 1;
	_widthline		 = 1;
	
	//Colors
	_colorNormal_r = 1.0;
	_colorNormal_g = 0.0;
	_colorNormal_b = 0.0;

	_colorPosibleSelected_r = 1.0;
	_colorPosibleSelected_g = 1.0;
	_colorPosibleSelected_b = 0.0;

}
// ----------------------------------------------------------------------------
manualViewPoint::~manualViewPoint(){
	DeleteVtkObjects();
}


// ----------------------------------------------------------------------------
manualViewPoint * manualViewPoint :: Clone()
{
	manualViewPoint * clone = new manualViewPoint(_wxvtkbaseview);
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------

void manualViewPoint::CopyAttributesTo( manualViewPoint * cloneObject)
{
	// Fathers object
	cloneObject->SetPosibleSelected(_posibleSelected);
	cloneObject->SetSelected(_selected);
	cloneObject->SetSpacing(_spc);
	cloneObject->SetWidthLine(_widthline);
}


// ----------------------------------------------------------------------------
void manualViewPoint::SetWidthLine( double width)
{
	_widthline = width;
}

// ----------------------------------------------------------------------------
void manualViewPoint::SetSelected(bool selected){
	_selected=selected;
}
// ----------------------------------------------------------------------------
void manualViewPoint::SetPosibleSelected(bool posibleSelected){
	_posibleSelected=posibleSelected;
}
// ----------------------------------------------------------------------------
bool manualViewPoint::GetSelected(){
	return _selected;
}
// ----------------------------------------------------------------------------
bool manualViewPoint::GetPosibleSelected(){
	return _posibleSelected;
}
// ----------------------------------------------------------------------------
void manualViewPoint::DeleteVtkObjects(){
	if (_pointVtkActor	!=NULL)		{ _pointVtkActor->Delete(); }
	if (_bboxMapper		!=NULL)		{ _bboxMapper	->Delete();	}
	if (_pts			!=NULL)		{ _pts			->Delete();	}
	if (_pd				!=NULL)		{ _pd			->Delete();	}
	_pointVtkActor	=	NULL;
	_bboxMapper		=	NULL;
	_pts			=	NULL;
	_pd				=	NULL;
}



// ----------------------------------------------------------------------------
vtkActor* manualViewPoint::CreateVtkPointActor()
{
	DeleteVtkObjects();

	_pts = vtkPoints::New();
	_pts->SetNumberOfPoints(8);

//EED
//	_pts->SetPoint(0, -1000	, -1000	, 0 );
//	_pts->SetPoint(1,  1000	, -1000	, 0 );
//	_pts->SetPoint(2,  1000	,  1000	, 0 );
//	_pts->SetPoint(3, -1000	,  1000	, 0 );
//	_pts->SetPoint(4, -1000	,  1000	, 0 );
//	_pts->SetPoint(5, -1000	,  1000	, 0 );
//	_pts->SetPoint(6, -1000	,  1000	, 0 );
//	_pts->SetPoint(7, -1000	,  1000 , 0 );
	
	vtkCellArray *lines = vtkCellArray::New();
	lines->InsertNextCell(17);
	lines->InsertCellPoint(0);
	lines->InsertCellPoint(1);
	lines->InsertCellPoint(2);
	lines->InsertCellPoint(3);
	lines->InsertCellPoint(0);
	lines->InsertCellPoint(4);
	lines->InsertCellPoint(5);
	lines->InsertCellPoint(6);
	lines->InsertCellPoint(7);
	lines->InsertCellPoint(4);
	lines->InsertCellPoint(0);
	lines->InsertCellPoint(3);
	lines->InsertCellPoint(7);
	lines->InsertCellPoint(6);
	lines->InsertCellPoint(2);
	lines->InsertCellPoint(1);
	lines->InsertCellPoint(5);

	_pd = vtkPolyData::New();
	_pd->SetPoints( _pts );
	_pd->SetLines( lines );
//	lines->Delete();  //do not delete lines ??

	_pointVtkActor	=	vtkActor::New();
    _bboxMapper		=	vtkPolyDataMapper::New();



//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_bboxMapper->SetInput(_pd);
#else
	_bboxMapper->SetInputData(_pd);
#endif


//	_bboxMapper->ImmediateModeRenderingOn();
	_pointVtkActor->SetMapper(_bboxMapper);
//	_pointVtkActor->GetProperty()->BackfaceCullingOn();
	UpdateColorActor();
//	_pd->ComputeBounds();

	return _pointVtkActor;
}


// ----------------------------------------------------------------------------
vtkActor* manualViewPoint::GetVtkActor(){
	return _pointVtkActor;
}
// ----------------------------------------------------------------------------
void manualViewPoint::SetPositionXY(double x, double y,double i_range,double posZ)
{
	double range=i_range;

//EED 27 sep 2006
	x	 = x * _spc[0];
	y	 = y * _spc[1];
	posZ = posZ * _spc[2];

	if (_pts!=NULL){
		_pts->SetPoint(0, x-range, y+range, posZ-range);
		_pts->SetPoint(1, x+range, y+range, posZ-range);
		_pts->SetPoint(2, x+range, y-range, posZ-range);
		_pts->SetPoint(3, x-range, y-range, posZ-range);
		_pts->SetPoint(4, x-range, y+range, posZ+range);
		_pts->SetPoint(5, x+range, y+range, posZ+range);
		_pts->SetPoint(6, x+range, y-range, posZ+range);
		_pts->SetPoint(7, x-range, y-range, posZ+range);

//EED 2017-03-02
		_pts->Modified();
	}
}


// ----------------------------------------------------------------------------
void manualViewPoint::UpdateColorActor()
{
	if (_pointVtkActor!=NULL){
//EED03
		_pointVtkActor->GetProperty()->SetLineWidth( _widthline );
		_pointVtkActor->GetProperty()->SetDiffuseColor(_colorNormal_r,_colorNormal_g,_colorNormal_b);
		if (_posibleSelected==true){
			_pointVtkActor->GetProperty()->SetDiffuseColor(_colorPosibleSelected_r,_colorPosibleSelected_g,_colorPosibleSelected_b);
		}
	}
}

// ----------------------------------------------------------------------------
void manualViewPoint::UpdateColorActor(double nR, double nG, double nB)
{
	_colorNormal_r = nR;
	_colorNormal_g = nG;
	_colorNormal_b = nB;
	UpdateColorActor();
}

// ----------------------------------------------------------------------------
void manualViewPoint::GetSpacing(double spc[3])
{
	spc[0] = _spc[0];
	spc[1] = _spc[1];
	spc[2] = _spc[2];
}
// ----------------------------------------------------------------------------
void manualViewPoint::SetSpacing(double spc[3])
{
	_spc[0] = spc[0];
	_spc[1] = spc[1];
	_spc[2] = spc[2];
}

