/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualViewPoints.h"

// ----------------------------------------------------------------------------
manualViewPoints::manualViewPoints()
{
}

// ----------------------------------------------------------------------------
manualViewPoints::~manualViewPoints()
{
	int i,size=_copyViewPoints.size();
	for (i=0;i<size; i++)
	{
		delete _copyViewPoints[i];
	}
	_copyViewPoints.clear();
}

 
// ----------------------------------------------------------------------------
manualViewPoints * manualViewPoints::Clone()
{
	manualViewPoints * clone = new manualViewPoints();
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------
void manualViewPoints::CopyAttributesTo( manualViewPoints * cloneObject)
{
	// Fathers object
	manualViewBaseContour::CopyAttributesTo(cloneObject);
}

// ----------------------------------------------------------------------------
int manualViewPoints::GetType() // VIRTUAL
{
	return 7;
}


// ----------------------------------------------------------------------------
bool manualViewPoints::ifTouchContour(int x,int y,int z) //VIRTUAL
{
	bool result=false;
	double xx=x;
	double yy=y;
	double zz=z;
	TransfromCoordViewWorld(xx,yy,zz);

//EED 27 sep 2006
	xx = xx * _spc[0];
	yy = yy * _spc[1];
	zz = zz * _spc[2];

	int id = _manContModel->GetIdPoint(xx,yy,zz,_range,2);

	if(id!=-1)
	{
		result = true;
	}
	

	return result;
}

// ----------------------------------------------------------------------------
void manualViewPoints::Refresh() // VIRTUAL
{
	RefreshContour();
	manualViewBaseContour::Refresh();
}

// ----------------------------------------------------------------------------
void manualViewPoints::RefreshContour()  // VIRTUAL
{
	int np = GetNumberOfPoints();
	int copynp= _copyViewPoints.size();

	while(copynp!=np)
	{

		if(copynp<np)
		{
			manualViewPoint *mvp = new manualViewPoint(_wxvtkbaseview);
			vtkActor *actor = mvp->CreateVtkPointActor();
			_wxvtkbaseview->GetRenderer()->AddActor( actor );	

			_copyViewPoints.push_back(mvp);
		}//if
		else if(copynp>np)
		{
			manualViewPoint *t = _copyViewPoints[0];
			_wxvtkbaseview->GetRenderer()->RemoveActor( t->GetVtkActor() );
			std::vector<manualViewPoint*>::iterator itNum = _copyViewPoints.begin();
			_copyViewPoints.erase(itNum);			
			delete t;
		}// else if
		copynp= _copyViewPoints.size();

	}// while

	int i;
	for(i=0;i<np;i++)
	{
		double xx = _manContModel->GetManualPoint(i)->GetX();
		double yy = _manContModel->GetManualPoint(i)->GetY();
		
		
//EED 21 mars 2012  FLIP probleme  ..PLOP..
//		double zz = 900; // RaC REVISAR !!
		
		double zz = -900; // RaC REVISAR !!

		manualViewPoint *mv = _copyViewPoints[i];

		//Paints new Rectangular points bigger than the actual control points
		mv->SetPositionXY(xx, yy, _range*2, zz);

		vtkActor *_pointVtkActor = mv->GetVtkActor();

		_pointVtkActor->GetProperty()->SetDiffuseColor( _coulorNormal_r , _coulorNormal_g , _coulorNormal_b );
		if (_posibleSelected || (_posibleSelected && GetEditable() ) )
		{
			_pointVtkActor->GetProperty()->SetDiffuseColor( _coulorEdit_r , _coulorEdit_g , _coulorEdit_b );
		}
		if( _selected )
		{
			_pointVtkActor->GetProperty()->SetDiffuseColor( _coulorSelection_r , _coulorSelection_g , _coulorSelection_b );
		}

		//IF you want to customize the points which are going to be painted
		//mv->UpdateColorActor(_colorViewPoints_r,_colorViewPoints_g,_colorViewPoints_b);
		//mv->SetWidthLine(1.3);
	}
}

// ----------------------------------------------------------------------------
void manualViewPoints::ConstructVTKObjects() // VIRTUAL
{
	InitTextActor();
}

// ----------------------------------------------------------------------------
void manualViewPoints::AddSplineActor()  // VIRTUAL
{
	int i,size=_copyViewPoints.size();
	for (i=0;i<size;i++)
	{
		_wxvtkbaseview->GetRenderer()->AddActor( _copyViewPoints[i]->GetVtkActor() );
	}
}

// ----------------------------------------------------------------------------
void manualViewPoints::RemoveSplineActor()  // VIRTUAL  
{
	int i,size=_copyViewPoints.size();
	for (i=0;i<size;i++)
	{
		_wxvtkbaseview->GetRenderer()->RemoveActor(_copyViewPoints[i]->GetVtkActor());

	}
}



