/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "manualViewRoi.h"

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

manualViewRoi::manualViewRoi()
{
	_sizePointsContour=5;
}
// ----------------------------------------------------------------------------
manualViewRoi::~manualViewRoi()
{
}


// ----------------------------------------------------------------------------
manualViewRoi * manualViewRoi :: Clone()
{
	manualViewRoi * clone = new manualViewRoi();
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------

void manualViewRoi::CopyAttributesTo( manualViewRoi * cloneObject)
{
	// Fathers object
	manualViewBaseContour::CopyAttributesTo(cloneObject);
}

// ----------------------------------------------------------------------------
void manualViewRoi::RefreshContour() // virtual
{
    unsigned int i,ii, np;
    np	= GetNumberOfPoints( );
//EED01	
	if ( np > 0)
	{
		if (np>=2)
		{
			manualPoint	*mp;
			for( i = 0; i < np+1; i++ ) 
			{
				ii=i%np;
				mp = _manContModel->GetManualPoint(ii);
	//EEDx6
				double XX=mp->GetX(),YY=mp->GetY(),ZZ=mp->GetZ();
	//			wxVtk2DBaseView *wxvtk2Dbasevie = (wxVtk2DBaseView*)this->GetWxVtkBaseView();
	//			wxvtk2Dbasevie->TransformCoordinate_spacing_ModelToView(XX,YY,ZZ);

	//EED 27 sep 2007
	//			_pts->SetPoint(i, XX,YY,ZZ );
				_pts->SetPoint(i, XX*_spc[0] , YY*_spc[1] , ZZ*_spc[2] );
			} //  for
		} else {
				_pts->SetPoint(0, 0 , 0 , 0);
				_pts->SetPoint(1, 0 , 0 , 0);
		} // if
	}
//EED 2017-03-02
	if (_pts!=NULL) 
	{
		_pts->Modified();
	}
}

// ----------------------------------------------------------------------------
int manualViewRoi::GetType() // virtual
{
	return 2;
}

// ----------------------------------------------------------------------------

void manualViewRoi::GetMinMax(double &minX,double &minY, double &maxX, double &maxY)
{
	double	pp[3];
	manualPoint *mp;
    unsigned int i;

	minX=99999;
	minY=99999;
	maxX=-99999;
	maxY=-99999;

	unsigned int size=(unsigned int) _manContModel->GetSizeLstPoints();

	for( i = 0; i < size; i++ )
	{

		mp=_manContModel->GetManualPoint(i);
		pp[0]=mp->GetX();
		pp[1]=mp->GetY();

		// min X
		if (pp[0]<minX)
		{
			minX=pp[0];
		}
		//min Y
		if (pp[1]<minY)
		{
			minY=pp[1];
		}
		//max X
		if (pp[0]>maxX)
		{
			maxX=pp[0];
		}
		// max Y
		if (pp[1]>maxY)
		{
			maxY=pp[1];
		}
	}

	if ( size<1 )
	{
		minX=0;
		maxX=0;
		minY=0;
		maxY=0;
	}
}

// ----------------------------------------------------------------------------


bool manualViewRoi::ifTouchContour(int x,int y, int z) // virtual
{
	bool	result=false;
	double	px1=99999,py1=99999,px2=-99999,py2=-99999;

	GetMinMax(px1,py1, px2, py2);

	double xx=x;
	double yy=y;
	double zz=z;
	TransfromCoordViewWorld(xx,yy,zz);

	bool ok1=false;
	bool ok2=false;
	double ddx=GetRange();
	double ddy=GetRange();

	if ((xx>px1-ddx)&&(xx<px2+ddx) &&  (yy>py1-ddy)&&(yy<py2+ddy))
	{
		ok1=true;
	}

	if ((xx>px1+ddx)&&(xx<px2-ddx) &&  (yy>py1+ddy)&&(yy<py2-ddy))
	{
		ok2=true;
	}

	if ((ok1==true) && (ok2==false))
	{
		result=true;
	}
		
	return result;
}

// ----------------------------------------------------------------------------

void manualViewRoi::InitMove(int x, int y, int z)  // virtual
{
	manualPoint *mp;
	double XX=x;
	double YY=y;
	double ZZ=z;
	TransfromCoordViewWorld(XX,YY,ZZ);

	if (_manContModel->GetSizeLstPoints()==4){
		mp = _manContModel->GetManualPoint(0);
		_dp0[0]= mp->GetX() - XX;
		_dp0[1]= mp->GetY() - YY;
		_dp0[2]= mp->GetZ();

		mp = _manContModel->GetManualPoint(1);
		_dp1[0]= mp->GetX() - XX;
		_dp1[1]= mp->GetY() - YY;
		_dp1[2]= mp->GetZ();

		mp = _manContModel->GetManualPoint(2);
		_dp2[0]= mp->GetX() - XX;
		_dp2[1]= mp->GetY() - YY;
		_dp2[2]= mp->GetZ();

		mp = _manContModel->GetManualPoint(3);
		_dp3[0]= mp->GetX() - XX;
		_dp3[1]= mp->GetY() - YY;
		_dp3[2]= mp->GetZ();
	}
}

// ----------------------------------------------------------------------------

void manualViewRoi::MoveContour(int x, int y, int z) // virtual
{
	manualPoint *mp;
	double XX=x;
	double YY=y;
	double ZZ=z;
	TransfromCoordViewWorld(XX,YY,ZZ);

	mp = _manContModel->GetManualPoint(0);
	mp->SetPoint(_dp0[0]+XX,_dp0[1]+YY,_dp0[2]);

	mp = _manContModel->GetManualPoint(1);
	mp->SetPoint(_dp1[0]+XX,_dp1[1]+YY,_dp0[2]);

	mp = _manContModel->GetManualPoint(2);
	mp->SetPoint(_dp2[0]+XX,_dp2[1]+YY,_dp0[2]);

	mp = _manContModel->GetManualPoint(3);
	mp->SetPoint(_dp3[0]+XX,_dp3[1]+YY,_dp0[2]);

	UpdateViewPoint(0);
	UpdateViewPoint(1);
	UpdateViewPoint(2);
	UpdateViewPoint(3);

}
