/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "manualInteractorWindowLevel.h"
#include "wxVtk2DBaseView.h"
//-------------------------------------------------------------------
//-------------------------------------------------------------------
//-------------------------------------------------------------------

manualInteractorWindowLevel::manualInteractorWindowLevel()
{
	_stateWindowLevel	=	false;
	_backPx				=	0;
	_backPy				=	0;
	_backWindow			=	-1;
	_backLevel			=	-1;
}

//-------------------------------------------------------------------

manualInteractorWindowLevel::~manualInteractorWindowLevel()
{
}

//-------------------------------------------------------------------

bool manualInteractorWindowLevel::OnMouseMove()			// virtual 
{
	if (_stateWindowLevel==true)
	{
		int tmpPx,tmpPy;
		crea::wxVTKRenderWindowInteractor *wxVTKiren;
		wxVTKiren = _vtkInteractorStyleBaseView->GetWxVtk2DBaseView()->GetWxVTKRenderWindowInteractor();
		wxVTKiren->GetEventPosition( tmpPx , tmpPy );
		double colorWin;
		double colorLev;
		vtkImageData* imgrange = ((wxVtk2DBaseView*)_vtkInteractorStyleBaseView->GetWxVtk2DBaseView())->GetVtkBaseData()->GetImageData();
		if(imgrange != NULL)
		{
			double* scalarrange = imgrange->GetScalarRange();
			double scalarr;
			if (scalarrange[1] == scalarrange[0])
			{
				scalarr=scalarrange[1];
				if (scalarrange[1]==0) {scalarr=100;}
			} else {
				scalarr = scalarrange[1] - scalarrange[0];
			}
			//std::cout<<"scalar r="<<scalarr<<std::endl;
			int w, h;
			((wxWindow*)wxVTKiren)->GetSize(&w, &h);			
			double dw=w,dh=h;
			double dx = (scalarr*( _backPx - tmpPx ))/dw;
			double dy = (scalarr*( _backPy - tmpPy ))/dh;
			//colorWin=_backWindow - (scalarr)*( _backPx - tmpPx );
			colorWin=_backWindow - dx;
			colorLev=_backLevel  + dy;
		} else {
			colorWin=_backWindow - 2*( _backPx - tmpPx );
			colorLev=_backLevel  + 2*( _backPy - tmpPy );
		}
		if (colorWin<0)
		{ 
			colorWin=0;
		}
		if (colorWin>100000)
		{ 
			colorWin=100000;
		}	
//EED 2 Nov 2012  This lets see negative values with the interaction of Window-Level Color
//		if (colorLev<0)
//		{ 
//			colorLev=0;
//		}	
		if (colorLev>100000)
		{ 
			colorLev=100000;
		}
		wxVtk2DBaseView *wxvtk2Dbaseview	= (wxVtk2DBaseView*)_vtkInteractorStyleBaseView->GetWxVtk2DBaseView();
		vtkBaseData *vtkbasedata			= wxvtk2Dbaseview->GetVtkBaseData();
//EED Borrame
//		vtkImageViewer2 *vtkimageviewer2	= wxvtk2Dbaseview->_imageViewer2XYZ->GetVtkImageViewer2();		
//		vtkimageviewer2->SetColorWindow(colorWin);
//		vtkimageviewer2->SetColorLevel(colorLev);
		vtkbasedata->SetColorWindow(colorWin);
		vtkbasedata->SetColorLevel(colorLev);		
		this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();
//		vtkimageviewer2->Render();
	}
	return true;
}

//-------------------------------------------------------------------

bool manualInteractorWindowLevel::OnMiddleButtonDown()	// virtual 
{
	if ((_vtkInteractorStyleBaseView->GetInteractor()->GetControlKey()==0) &&
	 	(_vtkInteractorStyleBaseView->GetInteractor()->GetShiftKey()==0) ){
		_stateWindowLevel	= true;
		crea::wxVTKRenderWindowInteractor *wxVTKiren;
		wxVTKiren = _vtkInteractorStyleBaseView->GetWxVtk2DBaseView()->GetWxVTKRenderWindowInteractor();
		wxVTKiren->GetEventPosition( _backPx , _backPy );
		_backWindow = ((wxVtk2DBaseView*)_vtkInteractorStyleBaseView->GetWxVtk2DBaseView())->_imageViewer2XYZ->GetVtkImageViewer2()->GetColorWindow();
		_backLevel  = ((wxVtk2DBaseView*)_vtkInteractorStyleBaseView->GetWxVtk2DBaseView())->_imageViewer2XYZ->GetVtkImageViewer2()->GetColorLevel();
	}
	return true;
}

//-------------------------------------------------------------------

bool manualInteractorWindowLevel::OnMiddleButtonUp()		// virtual
{
	if (_stateWindowLevel==true)
	{
		_stateWindowLevel=false;
	}
	return true;
}
