/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "BrushFilter.h"

BrushFilter::BrushFilter() 
{
	_brushsize = 5;
	_brushform = 0; // 0 rectangle-cube  ,   1 circle-sphere
	_brushtool = 0; // 0 pencil         ,   1 fill
}

//---------------------------------------------------------------------------
BrushFilter::~BrushFilter() // virtual
{
}

//---------------------------------------------------------------------------
void BrushFilter::FindMinMaxBrush(int px, int py, int pz,int &minX, int &maxX, int &minY, int &maxY,
		int &minZ, int &maxZ, int &size) 
{
	size = _brushsize - 1;
//EED 2020-04-28  BORRAME Change to local variables to use with openmp
/*
	minX = _px - size;
	maxX = _px + size;
	minY = _py - size;
	maxY = _py + size;
	minZ = _pz - size;
	maxZ = _pz + size;
	if (_2D3D == 0) //2D
	{
		if (_direction == 0) // YZ
		{
			minX = _px;
			maxX = _px;
		}
		if (_direction == 1) // XZ
		{
			minY = _py;
			maxY = _py;
		}
		if (_direction == 2) // XY
		{
			minZ = _pz;
			maxZ = _pz;
		}
	} // _2D3D
*/
	minX = px - size;
	maxX = px + size;
	minY = py - size;
	maxY = py + size;
	minZ = pz - size;
	maxZ = pz + size;
	if (_2D3D == 0) //2D
	{
		if (_direction == 0) // YZ
		{
			minX = px;
			maxX = px;
		}
		if (_direction == 1) // XZ
		{
			minY = py;
			maxY = py;
		}
		if (_direction == 2) // XY
		{
			minZ = pz;
			maxZ = pz;
		}
	} // _2D3D

	if (_2D3D == 1) {  }  // 3D 

	if (minX < _minX) { minX = _minX; }
	if (minY < _minY) { minY = _minY; }
	if (minZ < _minZ) { minZ = _minZ; }

	if (maxX >= _dimX) { maxX = _dimX-1; }
	if (maxY >= _dimY) { maxY = _dimY-1; }
 	if (maxZ >= _dimZ) { maxZ = _dimZ-1; }

//EED 2020-04-28  BORRAME Change to local variables to use with openmp
//	SetGeneralMinMax(minX, maxX, minY, maxY, minZ, maxZ);
}

//---------------------------------------------------------------------------
void BrushFilter::Run(int px, int py, int pz) // virtual
{
	if (_image != NULL)
	{
//EED 2020-04-28  BORRAME Change to local variables to use with openmp
//		this->_IMManager->BaseInitialPoint(_px, _py ,_pz);
		this->_IMManager->BaseInitialPoint(px, py ,pz);

		float value = (float) _graylevel;
		int i, j, k;

		int size;
		int minX, maxX, minY, maxY, minZ, maxZ;
		FindMinMaxBrush(px,py,pz,minX, maxX, minY, maxY, minZ, maxZ, size);

		double xx, yy, zz, rr = size * size;
		float scalarComponent;
		bool pixelModify;

		for (i = minX; i <= maxX; i++) 
		{
//EED 2020-04-28  BORRAME Change to local variables to use with openmp
//			xx = _px - i;  
			xx = px - i;  
			xx = xx * xx;
			for (j = minY; j <= maxY; j++) 
			{
//EED 2020-04-28  BORRAME Change to local variables to use with openmp
//				yy = _py - j;
				yy = py - j;
				yy = yy * yy;
				for (k = minZ; k <= maxZ; k++) 
				{
					pixelModify=false;
					scalarComponent = _image->GetScalarComponentAsFloat(i,j, k, 0);
					if ((_RangeMin <= scalarComponent) && (scalarComponent <= _RangeMax )) 
					{
						if (_brushform == 0) 
						{
							pixelModify=true;
//							this->_IMManager->AddModifiedPixel(i, j, k); //DFCH
//							_image->SetScalarComponentFromFloat(i, j, k, 0,value);
						} // _brushform 0
						if (_brushform == 1) 
						{
//EED 2020-04-28  BORRAME Change to local variables to use with openmp
//							zz = _pz - k;
							zz = pz - k;
							zz = zz * zz;
							if ((xx + yy + zz) <= rr) {
								pixelModify=true;
//								this->_IMManager->AddModifiedPixel(i, j, k); //DFCH
//								_image->SetScalarComponentFromFloat(i, j, k, 0,value);
							}
						} // _brushform 1
						if (pixelModify==true)
						{
								this->_IMManager->AddModifiedPixel(i, j, k); //DFCH
								if (_image2!=NULL)
								{
									_image2->SetScalarComponentFromFloat(i, j, k, 0,value);
								}else {
									_image->SetScalarComponentFromFloat(i, j, k, 0,value);
								}
						} // if pixelModify
					} //   GetRangeMin && GetRangeMax

				} //for k
			} //for j
		} //for i
		_image->Modified();
	} else {
		printf(
				"ERROR : bbcreaMaracasvisu::vtkInteractorManualPaint::PaintImage :  Image not set. \n");
	} // _image
}

//---------------------------------------------------------------------------
void BrushFilter::SetBrushSize(int brushsize) 
{
	_brushsize = brushsize;
}

//---------------------------------------------------------------------------
void BrushFilter::SetBrushForm(int brushform) 
{
	_brushform = brushform;
}

//---------------------------------------------------------------------------
void BrushFilter::SetBrushTool(int brushtool) 
{
	_brushtool = brushtool;
}


