/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "FillFilter.h"
#include "creaVtk_MACROS.h"

#include <vector>



FillFilter::FillFilter() 
{
	_tolerancefill 		 = 125;
	_GeneralAuxImageFill = NULL;
//EED 2020-04-28  BORRAME Change to local variables to use with openmp
//	_auxImageFill 		= NULL;
//	_maxXback			= 0;
//	_maxYback			= 0;
//	_maxZback			= 0;
	SetDistanceFill(5);
}

//---------------------------------------------------------------------------
FillFilter::~FillFilter() 
{
/*//EED 2020-04-28  BORRAME Change to local variables to use with openmp
	if (_auxImageFill != NULL)
	{
		_auxImageFill->Delete();
	}//_auxImageFill
*/
}

//---------------------------------------------------------------------------
void FillFilter::SetImages(vtkImageData *image,vtkImageData *image2) // virtual
{	
	baseFilterManualPaint::SetImages(image,image2);	

/* //EED 2020-04-28  BORRAME Change to local variables to use with openmp
	if ((_maxX!=_maxXback) || (_maxY!=_maxYback) || (_maxZ!=_maxZback)) 
	{
		if (_auxImageFill != NULL)
		{
			_auxImageFill->Delete();
		}
		_auxImageFill = vtkImageData::New();
		_auxImageFill->SetDimensions(_maxX + 1, _maxY + 1, _maxZ + 1);
		_auxImageFill->SetOrigin(0, 0, 0);
		_auxImageFill->SetExtent(0, _maxX, 0, _maxY, 0, _maxZ);
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		_auxImageFill->SetWholeExtent(0, _maxX, 0, _maxY, 0, _maxZ);
		_auxImageFill->SetScalarTypeToUnsignedChar();
		_auxImageFill->AllocateScalars();
#else
		_auxImageFill->AllocateScalars(VTK_UNSIGNED_CHAR,1);
#endif
	}
	unsigned char 	* ptrAuxImageFill = (unsigned char 	*)_auxImageFill->GetScalarPointer();
	memset(ptrAuxImageFill, 0, (_maxX+1) * (_maxY+1) * (_maxZ+1) );
	_maxXback = _maxX;
	_maxYback = _maxY;
	_maxZback = _maxZ;	
*/

		if (_GeneralAuxImageFill != NULL)
		{
			_GeneralAuxImageFill->Delete();
		}
		_GeneralAuxImageFill = vtkImageData::New();
		_GeneralAuxImageFill->SetDimensions(_dimX,_dimY,_dimZ );
		_GeneralAuxImageFill->SetOrigin(0, 0, 0);
		_GeneralAuxImageFill->SetExtent(0, _dimX-1, 0, _dimY-1, 0, _dimZ-1);
		_GeneralAuxImageFill->AllocateScalars(VTK_UNSIGNED_CHAR,1);
		unsigned char *ptrAuxImageFill = (unsigned char*)_GeneralAuxImageFill->GetScalarPointer();
		memset(ptrAuxImageFill, 0, _dimX*_dimY*_dimZ*sizeof(unsigned char) );
}

//---------------------------------------------------------------------------
void FillFilter::Run(int px, int py, int pz) // virtual
{
	long int ivi;

/* //EED 2020-04-28  BORRAME Change to local variables to use with openmp
	if (	(_px >= _minX) && (_px < _dimX) && 
			(_py >= _minY) && (_py < _dimY) && 
			(_pz >= _minZ) && (_pz < _dimZ)		) 
	{
		this->_IMManager->BaseInitialPoint(_px, _py ,_pz);
		FillToolLoop(_px, _py, _pz);
 	} //if _minX _maxX _minY _maxY _minZ _maxZ
*/

	if (	(px >= _minX) && (px < _dimX) && 
			(py >= _minY) && (py < _dimY) && 
			(pz >= _minZ) && (pz < _dimZ)		) 
	{
		this->_IMManager->BaseInitialPoint(px, py ,pz);
		FillToolLoop(px, py, pz);
 	} //if _minX _maxX _minY _maxY _minZ _maxZ



}


//---------------------------------------------------------------------------
vtkImageData* FillFilter::CreateAuxImageFill(	long int &OneColumnAux, long int &OneLineAux , long int &OnePlaneAux, 
												int px,			int py,			int pz, 
												int &pxAux,		int &pyAux, 	int &pzAux,
 												int &minXAux,	int &minYAux,	int &minZAux )
{
	// _2D3D = 1     3D

	minXAux = px-_distancefill;  if (minXAux>=0) { pxAux=px-minXAux; } else { pxAux=px; minXAux=0; }
	minYAux = py-_distancefill;  if (minYAux>=0) { pyAux=py-minYAux; } else { pyAux=py; minYAux=0; }
	minZAux = pz-_distancefill;  if (minZAux>=0) { pzAux=pz-minZAux; } else { pzAux=pz; minZAux=0; }

	int maxXAux = px+_distancefill;  if (maxXAux>_dimX) { maxXAux=_dimX; }
	int maxYAux = py+_distancefill;  if (maxYAux>_dimY) { maxYAux=_dimY; }
	int maxZAux = pz+_distancefill;  if (maxZAux>_dimZ) { maxZAux=_dimZ; }


	int auxDimX = maxXAux-minXAux+1;
	int auxDimY = maxYAux-minYAux+1;
	int auxDimZ = maxZAux-minZAux+1;

	// new vtkImageData
	if (_2D3D==0)  // 2D
	{	
		if (_direction==0) // YZ
		{
			auxDimX = 1;
		}
		if (_direction==1) // XZ
		{
			auxDimY = 1;
		}
		if (_direction==2) // XY
		{
			auxDimZ = 1;
		}
	} // if 2D

	OneColumnAux	= 1;
	OneLineAux		= auxDimX;
	OnePlaneAux		= auxDimX*auxDimY;

	vtkImageData *auxImageFill;
	auxImageFill = vtkImageData::New();
	auxImageFill->SetDimensions(auxDimX, auxDimY, auxDimZ);
	auxImageFill->SetOrigin(0, 0, 0);
	auxImageFill->SetExtent(0, auxDimX-1, 0, auxDimY-1, 0, auxDimZ-1);
	auxImageFill->AllocateScalars(VTK_UNSIGNED_CHAR,1);
	unsigned char 	* ptrAuxImageFill = (unsigned char 	*)auxImageFill->GetScalarPointer();
	memset( ptrAuxImageFill, 0, auxDimX*auxDimY*auxDimZ );
	return auxImageFill;
}

void FillFilter::Copy_AuxImageFill_To_GeneralAuxFill(int minXAux, int minYAux, int minZAux, vtkImageData *auxImageFill)
{
	// copy information from the litle image auxImageFill to the big image _GeneralAuxImageFill
	DEF_POINTER_IMAGE_VTK_CREA(vAuxImageFill,ssAuxImageFill,pAuxImageFill,stAuxImageFill,auxImageFill)
	DEF_POINTER_IMAGE_VTK_CREA(v_GeneralAuxImageFill,ss_GeneralAuxImageFill,p_GeneralAuxImageFill,st_GeneralAuxImageFill,_GeneralAuxImageFill)
	int ext[6];
	auxImageFill->GetExtent(ext);
	int auxDimX = ext[1]-ext[0]+1;
	int auxDimY = ext[3]-ext[2]+1;
	int auxDimZ = ext[5]-ext[4]+1;
	int i,j,k;	
	long int indexAux=0;
	long int indexGeneralAux;
	for (k=0;k<auxDimZ;k++)
	{
		for (j=0;j<auxDimY;j++)
		{
			indexGeneralAux=minXAux + (minYAux+j)*_OneLine + (minZAux+k)*_OnePlane;
//			indexAux = j*OneLineAux + k*OnePlaneAux;
			for (i=0;i<auxDimX;i++)
			{
				GETVALUE2_VTK_CREA(vAuxImageFill,pAuxImageFill,stAuxImageFill,indexAux) 	
				indexAux++;
				if (vAuxImageFill==1) 
				{
					SETVALUE2_VTK_CREA(vAuxImageFill,p_GeneralAuxImageFill,st_GeneralAuxImageFill,indexGeneralAux)
				} // if vAuxImageFill
				indexGeneralAux = indexGeneralAux+_OneColumn;
			} //  for i
		} // for j
	} // for k
}

void FillFilter::Copy_GeneralAuxFill_to_Results()
{
	DEF_POINTER_IMAGE_VTK_CREA(v_GeneralAuxImageFill,ss_GeneralAuxImageFill,p_GeneralAuxImageFill,st_GeneralAuxImageFill,_GeneralAuxImageFill)
	long int i,size = _dimX*_dimY*_dimZ;
	if (_image2==NULL)
	{
			DEF_POINTER_IMAGE_VTK_CREA(v_image,ss_image,p_image,st_image,_image)
//			DEF_POINTER_IMAGE_VTK_CREA_set(v_image,ss_image,p_image,st_image,_image)		
#pragma omp parallel for 
			for (i=0;i<size;i++)
			{
				int value;
				GETVALUE2_VTK_CREA(value,p_GeneralAuxImageFill,st_GeneralAuxImageFill,i)
				if (value!=0) 
				{
					SETVALUE2_VTK_CREA(_graylevel,p_image,st_image,i)
				} // if v_GeneralAuxImageFill
			} // for	
	}  else {
			DEF_POINTER_IMAGE_VTK_CREA(v_image2,ss_image2,p_image2,st_image2,_image2)
//			DEF_POINTER_IMAGE_VTK_CREA_set(v_image2,ss_image2,p_image2,st_image2,_image2)		
#pragma omp parallel for 
			for (i=0;i<size;i++)
			{
				int value;
				GETVALUE2_VTK_CREA(value,p_GeneralAuxImageFill,st_GeneralAuxImageFill,i)
				if (value!=0) 
				{
					SETVALUE2_VTK_CREA(_graylevel,p_image2,st_image2,i)
				} // if v_GeneralAuxImageFill
			} // for	
	}// if _image2
	

}



//---------------------------------------------------------------------------
void FillFilter::FillToolLoop(int px, int py, int pz) 
{
    double          distbasefill;
    double          graylevelbasefill;
    double          tmpiglfill;
    double          tmpiglfill2;
    bool            auxGrayLevelValidationFill;

	distbasefill 	= _distancefill * _distancefill;
	double difX,difY,difZ,_tmpDistfill;
	std::vector<int> lstX;
   	std::vector<int> lstY;
   	std::vector<int> lstZ;
	lstX.push_back(px);
	lstY.push_back(py);
	lstZ.push_back(pz);
  	std::vector<long long int> lstivi;
	lstivi.push_back( px + py*_OneLine+ pz*_OnePlane );

	long int OneColumnAux, OneLineAux, OnePlaneAux;  // how to jump in the little image auxImageFill
	int pxAux, pyAux, pzAux;						 // position inside little image auxImageFill
	int minXAux, minYAux, minZAux;					 // Where start the little image auxImageFill in the big image
	vtkImageData* auxImageFill = CreateAuxImageFill( 	OneColumnAux,OneLineAux,OnePlaneAux,
														px,py,pz,
														pxAux,pyAux,pzAux, 
														minXAux,minYAux,minZAux );
  	std::vector<long long int> lstiviAux;
	lstiviAux.push_back( pxAux + pyAux*OneLineAux + pzAux*OnePlaneAux );

	DEF_POINTER_IMAGE_VTK_CREA(v_image,ss_image,p_image,st_image,_image)
//	DEF_POINTER_IMAGE_VTK_CREA_set(v_image,ss_image,p_image,st_image,_image)		

	double 			v_image2;
	int 			ss_image2;
	char 		   *p_image2;
	int				st_image2;


	if (_image2!=NULL)
	{
//		DEF_POINTER_IMAGE_VTK_CREA(v_image2,ss_image2,p_image2,st_image2,_image2)		
		DEF_POINTER_IMAGE_VTK_CREA_set(v_image2,ss_image2,p_image2,st_image2,_image2)		
	} // if _image2

	GETVALUE2_VTK_CREA(graylevelbasefill,p_image,st_image,lstivi[0]) 	

//EED 2020-04-28  BORRAME Change to local variables to use with openmp
//	DEF_POINTER_IMAGE_VTK_CREA(v_auxImageFill,ss_auxImageFill,p_auxImageFill,st_auxImageFill,_auxImageFill)		
	DEF_POINTER_IMAGE_VTK_CREA(vAuxImageFill,ssAuxImageFill,pAuxImageFill,stAuxImageFill,auxImageFill)

	while ( lstX.size()!=0 )
	{
		// if point inside image
		if ((lstX[0] >= _minX) && (lstX[0] < _dimX) && (lstY[0] >= _minY) && (lstY[0] < _dimY) && (lstZ[0] >= _minZ) && (lstZ[0] < _dimZ)) 
		{   
			difX = px-lstX[0];
			difY = py-lstY[0];
			difZ = pz-lstZ[0];
			_tmpDistfill = difX*difX + difY*difY + difZ*difZ;
			// if distance of center point
			if (_tmpDistfill<=distbasefill)
			{
				// if point not visited
				GETVALUE2_VTK_CREA(vAuxImageFill,pAuxImageFill,stAuxImageFill,lstiviAux[0] );	
				if (vAuxImageFill==0)
				{ 
					// If Gray Level valid

					//EED01 
					//		tmpiglfill 	= _image->GetScalarComponentAsDouble(px, py, pz, 0);
					GETVALUE2_VTK_CREA(tmpiglfill,p_image,st_image,lstivi[0]) 	

					if (_image2!=NULL)
					{
						//EED01
						//			tmpiglfill2 	= 	_image2->GetScalarComponentAsDouble(px, py, pz, 0);
						GETVALUE2_VTK_CREA(tmpiglfill2,p_image2,st_image2,lstivi[0]) 	
					} else {
						tmpiglfill2	=	tmpiglfill;
					}

					float grayLBFMTOL 	= graylevelbasefill - _tolerancefill;
					float grayLBFPTOL 	= graylevelbasefill + _tolerancefill;
					bool isInRange 		= false;
					//DFCH
					if (_RangeMin <= grayLBFMTOL && _RangeMax >= grayLBFPTOL) {
						isInRange 		= true;
					} //fi esle
					else if (_RangeMin > grayLBFMTOL && _RangeMax >= grayLBFPTOL) {
						grayLBFMTOL 	= _RangeMin;
						isInRange 		= true;
					} //fi esle
					else if (_RangeMin <= grayLBFMTOL && _RangeMax < grayLBFPTOL) {
						grayLBFPTOL 	= _RangeMax;
						isInRange 		= true;
					} //fi esle
					else if ((_RangeMin <= graylevelbasefill) && (graylevelbasefill <= _RangeMax)) {
						grayLBFMTOL 	= _RangeMin;
						grayLBFPTOL 	= _RangeMax;
						isInRange 		= true;
					} //fi Range

					if (isInRange) 
					{
						auxGrayLevelValidationFill = 	(tmpiglfill  != _graylevel)	&& 
														(tmpiglfill2 != _graylevel)	&&  // <<<<<<<<< xxxxxxxxxxxxxxxxxxxxxx
														(tmpiglfill  >= grayLBFMTOL)	&& 
														(tmpiglfill  <= grayLBFPTOL)	&& 
														(_tmpDistfill <= distbasefill) ; //DFCH
					} else {
						auxGrayLevelValidationFill = false;
					} // if isInRange

					if (auxGrayLevelValidationFill==true)  
					{
						this->_IMManager->AddModifiedPixel(lstX[0], lstY[0], lstZ[0]); //DFCH
/*
						// Modifie image
						if (_image2!=NULL)
						{
							//				_image2->SetScalarComponentFromFloat(px, py, pz, 0,(float) _graylevel);
							SETVALUE2_VTK_CREA(_graylevel,p_image2,st_image2,lstivi[0])
						} else {
							//				_image->SetScalarComponentFromFloat(px, py, pz, 0,(float) _graylevel);
							SETVALUE2_VTK_CREA(_graylevel,p_image,st_image,lstivi[0])
						} // if _image2

*/
						// Add point to already visited
						SETVALUE2_VTK_CREA(1,pAuxImageFill,stAuxImageFill,lstiviAux[0]);

						// Add neighborhood points in the list 


						if (_2D3D == 0) //2D
						{
							if (_direction == 0) // YZ
							{
//lstX.push_back(lstX[0]+1); lstY.push_back(lstY[0]);   lstZ.push_back(lstZ[0]);   lstivi.push_back(lstivi[0]+_OneColumn); lstiviAux.push_back(lstiviAux[0]+OneColumnAux);
//lstX.push_back(lstX[0]-1); lstY.push_back(lstY[0]);   lstZ.push_back(lstZ[0]);   lstivi.push_back(lstivi[0]-_OneColumn); lstiviAux.push_back(lstiviAux[0]-OneColumnAux); 
  lstX.push_back(lstX[0]  ); lstY.push_back(lstY[0]+1); lstZ.push_back(lstZ[0]  ); lstivi.push_back(lstivi[0]+_OneLine);   lstiviAux.push_back(lstiviAux[0]+OneLineAux);
  lstX.push_back(lstX[0]  ); lstY.push_back(lstY[0]-1); lstZ.push_back(lstZ[0]  ); lstivi.push_back(lstivi[0]-_OneLine);   lstiviAux.push_back(lstiviAux[0]-OneLineAux);
  lstX.push_back(lstX[0]  ); lstY.push_back(lstY[0]  ); lstZ.push_back(lstZ[0]+1); lstivi.push_back(lstivi[0]+_OnePlane);  lstiviAux.push_back(lstiviAux[0]+OnePlaneAux);
  lstX.push_back(lstX[0]  ); lstY.push_back(lstY[0]  ); lstZ.push_back(lstZ[0]-1); lstivi.push_back(lstivi[0]-_OnePlane);  lstiviAux.push_back(lstiviAux[0]-OnePlaneAux);
							}
							if (_direction == 1) // XZ
							{
  lstX.push_back(lstX[0]+1); lstY.push_back(lstY[0]);   lstZ.push_back(lstZ[0]);   lstivi.push_back(lstivi[0]+_OneColumn); lstiviAux.push_back(lstiviAux[0]+OneColumnAux);
  lstX.push_back(lstX[0]-1); lstY.push_back(lstY[0]);   lstZ.push_back(lstZ[0]);   lstivi.push_back(lstivi[0]-_OneColumn); lstiviAux.push_back(lstiviAux[0]-OneColumnAux); 
//  lstX.push_back(lstX[0]  ); lstY.push_back(lstY[0]+1); lstZ.push_back(lstZ[0]  ); lstivi.push_back(lstivi[0]+_OneLine);   lstiviAux.push_back(lstiviAux[0]+OneLineAux);
//  lstX.push_back(lstX[0]  ); lstY.push_back(lstY[0]-1); lstZ.push_back(lstZ[0]  ); lstivi.push_back(lstivi[0]-_OneLine);   lstiviAux.push_back(lstiviAux[0]-OneLineAux);
  lstX.push_back(lstX[0]  ); lstY.push_back(lstY[0]  ); lstZ.push_back(lstZ[0]+1); lstivi.push_back(lstivi[0]+_OnePlane);  lstiviAux.push_back(lstiviAux[0]+OnePlaneAux);
  lstX.push_back(lstX[0]  ); lstY.push_back(lstY[0]  ); lstZ.push_back(lstZ[0]-1); lstivi.push_back(lstivi[0]-_OnePlane);  lstiviAux.push_back(lstiviAux[0]-OnePlaneAux);
							}
							if (_direction == 2) // XY
							{
lstX.push_back(lstX[0]+1); lstY.push_back(lstY[0]);   lstZ.push_back(lstZ[0]);   lstivi.push_back(lstivi[0]+_OneColumn); lstiviAux.push_back(lstiviAux[0]+OneColumnAux);
lstX.push_back(lstX[0]-1); lstY.push_back(lstY[0]);   lstZ.push_back(lstZ[0]);   lstivi.push_back(lstivi[0]-_OneColumn); lstiviAux.push_back(lstiviAux[0]-OneColumnAux); 
  lstX.push_back(lstX[0]  ); lstY.push_back(lstY[0]+1); lstZ.push_back(lstZ[0]  ); lstivi.push_back(lstivi[0]+_OneLine);   lstiviAux.push_back(lstiviAux[0]+OneLineAux);
  lstX.push_back(lstX[0]  ); lstY.push_back(lstY[0]-1); lstZ.push_back(lstZ[0]  ); lstivi.push_back(lstivi[0]-_OneLine);   lstiviAux.push_back(lstiviAux[0]-OneLineAux);
//lstX.push_back(lstX[0]  ); lstY.push_back(lstY[0]  ); lstZ.push_back(lstZ[0]+1); lstivi.push_back(lstivi[0]+_OnePlane);  lstiviAux.push_back(lstiviAux[0]+OnePlaneAux);
//lstX.push_back(lstX[0]  ); lstY.push_back(lstY[0]  ); lstZ.push_back(lstZ[0]-1); lstivi.push_back(lstivi[0]-_OnePlane);  lstiviAux.push_back(lstiviAux[0]-OnePlaneAux);
							}
						} else { // 3D
  lstX.push_back(lstX[0]+1); lstY.push_back(lstY[0]);   lstZ.push_back(lstZ[0]);   lstivi.push_back(lstivi[0]+_OneColumn); lstiviAux.push_back(lstiviAux[0]+OneColumnAux);
  lstX.push_back(lstX[0]-1); lstY.push_back(lstY[0]);   lstZ.push_back(lstZ[0]);   lstivi.push_back(lstivi[0]-_OneColumn); lstiviAux.push_back(lstiviAux[0]-OneColumnAux); 
  lstX.push_back(lstX[0]  ); lstY.push_back(lstY[0]+1); lstZ.push_back(lstZ[0]  ); lstivi.push_back(lstivi[0]+_OneLine);   lstiviAux.push_back(lstiviAux[0]+OneLineAux);
  lstX.push_back(lstX[0]  ); lstY.push_back(lstY[0]-1); lstZ.push_back(lstZ[0]  ); lstivi.push_back(lstivi[0]-_OneLine);   lstiviAux.push_back(lstiviAux[0]-OneLineAux);
  lstX.push_back(lstX[0]  ); lstY.push_back(lstY[0]  ); lstZ.push_back(lstZ[0]+1); lstivi.push_back(lstivi[0]+_OnePlane);  lstiviAux.push_back(lstiviAux[0]+OnePlaneAux);
  lstX.push_back(lstX[0]  ); lstY.push_back(lstY[0]  ); lstZ.push_back(lstZ[0]-1); lstivi.push_back(lstivi[0]-_OnePlane);  lstiviAux.push_back(lstiviAux[0]-OnePlaneAux);
						} // 2D 3D
					} // if gray level valid      auxGrayLevelValidationFill
				} // if point not visited
			} // if distance of center point	
		} // if point inside image
		// Remove point from the list
		lstX.erase( lstX.begin() );
		lstY.erase( lstY.begin() );
		lstZ.erase( lstZ.begin() );
		lstivi.erase( lstivi.begin() );
		lstiviAux.erase( lstiviAux.begin() );
	} // while _lstX.size

	Copy_AuxImageFill_To_GeneralAuxFill( minXAux, minYAux, minZAux, auxImageFill );
	
	auxImageFill->Delete();
}

//---------------------------------------------------------------------------
void FillFilter::SetToleranceFill(double tolerancefill) 
{
	_tolerancefill = tolerancefill;
}

//---------------------------------------------------------------------------
void FillFilter::SetDistanceFill(int distancefill) 
{
	_distancefill = distancefill;
}

/*//EED 2020-04-28  BORRAME Change to local variables to use with openmp
//---------------------------------------------------------------------------
vtkImageData* FillFilter::GetAuxImageFill() 
{
	return _auxImageFill;
}
*/

