/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef _FILL_FILTER_H_
#define _FILL_FILTER_H_

#include "baseFilterManualPaint.h"


class FillFilter : public baseFilterManualPaint {
public:
	FillFilter();
	virtual ~FillFilter();
    void 			Run(int px, int py, int pz);
	void 			FillToolLoop(int px, int py, int pz);
    void 			SetToleranceFill(double tolerancefill);
    void 			SetDistanceFill(int distancefill);
    virtual void 	SetImages(vtkImageData *image,vtkImageData *image2);
//	vtkImageData*	GetAuxImageFill();
void 			Copy_GeneralAuxFill_to_Results();


private:
    double          _tolerancefill;
    int             _distancefill;

//EED 2020-04-28  BORRAME Change to local variables to use with openmp
//    double          _distbasefill;
//    double          _graylevelbasefill;
//    double          _tmpiglfill;
//    double          _tmpiglfill2;
//    bool            _auxGrayLevelValidationFill;

//EED 2020-04-28  BORRAME Change to local variables to use with openmp
//   vtkImageData    *_auxImageFill;
//	int 			_maxXback;
//	int 			_maxYback;
//	int 			_maxZback;
   vtkImageData    *_GeneralAuxImageFill;

vtkImageData* 	CreateAuxImageFill(	long int &OneColumnAux, long int &OneLineAux , long int &OnePlaneAux, 
									int px,			int py,			int pz, 
									int &pxAux, 	int &pyAux, 	int &pzAux, 
									int &minXAux,	int &minYAux, 	int &minZAux   );
void 			Copy_AuxImageFill_To_GeneralAuxFill(int minXAux, int minYAux, int minZAux, vtkImageData *auxImageFill);


protected:



//Change to local variables to use with openmp
// DEF_POINTER_IMAGE_VTK_CREA_definition( v_image , ss_image , p_image , st_image )		
//	double 			v_image;
//	int 			ss_image;
//	char 			*p_image;
//	int				st_image;

// //macro not working ???    
// DEF_POINTER_IMAGE_VTK_CREA_definition(v_image2,ss_image2,p_image2,st_image2)		
//	double 			v_image2;
//	int 			ss_image2;
//	char 			*p_image2;
//	int				st_image2;

};


#endif // _FILL_FILTER_H_
