/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include <wxMPRBaseData.h>

#include "ManualPaintControler.h"
#include "vtkInteractorManualPaint.h"
#include "vtkImageActor.h"

//---------------------------------------------------------------------------
ManualPaintControler::ManualPaintControler() 
{
	auxZ 				= 0;
//	_wxvtk2Dbaseview 	= NULL;
	_wxvtk2Dbaseview1	= NULL;
	_wxvtk2Dbaseview2	= NULL;
	_wxvtk2Dbaseview3	= NULL;
	_wxvtk2Dbaseview4	= NULL;
}

//---------------------------------------------------------------------------
ManualPaintControler::~ManualPaintControler() 
{
}

//---------------------------------------------------------------------------
void ManualPaintControler::SetManualPaintModel( ManualPaintModel* manualPaintModel ) 
{
	_manualPaintModel 	= manualPaintModel;
}

//---------------------------------------------------------------------------
ManualPaintModel* ManualPaintControler::GetManualPaintModel( ) 
{
	return _manualPaintModel;
}

//---------------------------------------------------------------------------
void ManualPaintControler::SetWxVtk2DBaseView( int id, wxVtk2DBaseView *wxvtk2Dbaseview )
{
	if (id==1) { _wxvtk2Dbaseview1 	= wxvtk2Dbaseview; }
	if (id==2) { _wxvtk2Dbaseview2 	= wxvtk2Dbaseview; }
	if (id==3) { _wxvtk2Dbaseview3 	= wxvtk2Dbaseview; }
	if (id==4) { _wxvtk2Dbaseview4 	= wxvtk2Dbaseview; }
}

//---------------------------------------------------------------------------
void ManualPaintControler::Config() 
{
	if (_wxvtk2Dbaseview1 != NULL) 
	{
		vtkInteractorStyleBaseView *isbv = (vtkInteractorStyleBaseView*) (_wxvtk2Dbaseview1->GetInteractorStyleBaseView());
		isbv->AddInteractorStyleMaracas(new vtkInteractorManualPaint(this));
	} // if _wxvtk2Dbaseview
	if (_wxvtk2Dbaseview2 != NULL) 
	{
		vtkInteractorStyleBaseView *isbv = (vtkInteractorStyleBaseView*) (_wxvtk2Dbaseview2->GetInteractorStyleBaseView());
		isbv->AddInteractorStyleMaracas(new vtkInteractorManualPaint(this));
	} // if _wxvtk2Dbaseview
	if (_wxvtk2Dbaseview3 != NULL) 
	{
		vtkInteractorStyleBaseView *isbv = (vtkInteractorStyleBaseView*) (_wxvtk2Dbaseview3->GetInteractorStyleBaseView());
		isbv->AddInteractorStyleMaracas(new vtkInteractorManualPaint(this));
	} // if _wxvtk2Dbaseview
	if (_wxvtk2Dbaseview4 != NULL) 
	{
		vtkInteractorStyleBaseView *isbv = (vtkInteractorStyleBaseView*) (_wxvtk2Dbaseview4->GetInteractorStyleBaseView());
		isbv->AddInteractorStyleMaracas(new vtkInteractorManualPaint(this));
	} // if _wxvtk2Dbaseview
}

//---------------------------------------------------------------------------
void ManualPaintControler::PaintImage(int px, int py, int pz,int direction) 
{
	_manualPaintModel->SetDirection( direction );
	_manualPaintModel->PaintImage(px, py, pz);
	// The refresh mechanisme is made in the vtkInteractorManualPaint
	//    RefreshView();
}

//---------------------------------------------------------------------------
void ManualPaintControler::SetImageUndo()
{
	_manualPaintModel->SetUndoImage();
}

//---------------------------------------------------------------------------
void ManualPaintControler::Undo()
{
	_manualPaintModel->Undo();
	Refresh_UndoRedo();
}

void ManualPaintControler::Redo()
{
	_manualPaintModel->Redo();
	Refresh_UndoRedo();
}

void ManualPaintControler::Refresh_UndoRedo()
{
	wxVtk2DBaseView *wxvtk2Dbaseview = NULL;
	if (_wxvtk2Dbaseview1!=NULL){ wxvtk2Dbaseview=_wxvtk2Dbaseview1; }
	if (_wxvtk2Dbaseview2!=NULL){ wxvtk2Dbaseview=_wxvtk2Dbaseview2; }
	if (_wxvtk2Dbaseview3!=NULL){ wxvtk2Dbaseview=_wxvtk2Dbaseview3; }
	if (_wxvtk2Dbaseview4!=NULL){ wxvtk2Dbaseview=_wxvtk2Dbaseview4; }
	if (wxvtk2Dbaseview!=NULL)
	{
	   	vtkMPRBaseData* vtkmprbasedata = (vtkMPRBaseData*) (wxvtk2Dbaseview->GetVtkBaseData());
		vtkmprbasedata->SetX( _manualPaintModel->GetRestorBaseInitialPointX() );
		vtkmprbasedata->SetY( _manualPaintModel->GetRestorBaseInitialPointY() );
		vtkmprbasedata->SetZ( _manualPaintModel->GetRestorBaseInitialPointZ() );
		wxCommandEvent newevent(wxEVT_COMMAND_MENU_SELECTED,12121);  // Refresh
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
		wxvtk2Dbaseview->GetWxVTKRenderWindowInteractor ()->GetParent()->ProcessEvent( newevent );
#else
		wxvtk2Dbaseview->GetWxVTKRenderWindowInteractor ()->GetParent()->ProcessWindowEvent( newevent );
#endif				
	} // _wxvtk2Dbaseview
}


