/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "ManualPaintModel.h"

ManualPaintModel::ManualPaintModel() 
{
	_active 				= true;
	_tool 					= 0; // 0 pencil         ,   1 fill
	_brushfilter 			= new BrushFilter();
	_fillfilter 			= new FillFilter();
	_imageUndoRedo 			= new ImageUndoRedo();
//EED 2020-04-28  BORRAME Change to local variables to use with openmp
//	_imageUndoRedo_visited	= new ImageUndoRedo();
}

//---------------------------------------------------------------------------
ManualPaintModel::~ManualPaintModel() 
{
	delete _brushfilter;
	delete _fillfilter;
}


//---------------------------------------------------------------------------
void ManualPaintModel::SetActive( bool active )
{
  _active = active;
}

//---------------------------------------------------------------------------
void ManualPaintModel::PaintImage(int px, int py, int pz) 
{
  if (_active==true)
  {
	if (_tool == 0) 
	{
//		_brushfilter->SetPoint(px, py, pz);
		_brushfilter->Run(px,py,pz);
	} // _tool 2
	if (_tool == 1) 
	{
//		_fillfilter->SetPoint(px, py, pz);
		_fillfilter->Run(px,py,pz);
	} // _tool 1
  } // _active
}

//---------------------------------------------------------------------------
void ManualPaintModel::SetTool(int tool) 
{
	_tool = tool;
}

//---------------------------------------------------------------------------
void ManualPaintModel::Set2D3D(int dim2D3D) 
{
	_brushfilter -> Set2D3D(dim2D3D);
	_fillfilter  -> Set2D3D(dim2D3D);
}

//---------------------------------------------------------------------------
void ManualPaintModel::SetImages(vtkImageData *image,vtkImageData *image2) 
{
	if (image!=NULL)
	{
		_brushfilter -> SetImages(image,image2);
		_fillfilter  -> SetImages(image,image2);
		if (image2!=NULL)
		{
			_imageUndoRedo->SetImage(image2);
		} else {
			_imageUndoRedo->SetImage(image);
		}
//EED 2020-04-28  BORRAME Change to local variables to use with openmp
//		_imageUndoRedo_visited->SetImage( _fillfilter->GetAuxImageFill() );
	} else {
		printf("EED Warning image=NULL in ManualPaintModel::SetImages(image,image2)\n ");
	}
}

//---------------------------------------------------------------------------
void ManualPaintModel::SetGrayLevel(double graylevel) 
{
	_brushfilter->SetGrayLevel(graylevel);
	_fillfilter->SetGrayLevel(graylevel);
}

//---------------------------------------------------------------------------
void ManualPaintModel::SetRangeMin(int min) 
{
	_brushfilter->SetRangeMin(min);
	_fillfilter->SetRangeMin(min);
}

//---------------------------------------------------------------------------
void ManualPaintModel::SetRangeMax(int max) 
{
	_brushfilter->SetRangeMax(max);
	_fillfilter->SetRangeMax(max);
}

//---------------------------------------------------------------------------
void ManualPaintModel::SetDirection(int direction) 
{
	_brushfilter->SetDirection(direction);
	_fillfilter->SetDirection(direction);
}

//---------------------------------------------------------------------------
void ManualPaintModel::SetBrushSize(int brushsize) 
{
	_brushfilter->SetBrushSize(brushsize);
}

//---------------------------------------------------------------------------
void ManualPaintModel::SetBrushForm(int brushform) 
{
	_brushfilter->SetBrushForm(brushform);
}

//--------------------C:\Eduardo\Creatis\C11\ct\cs\creaMaracasVisu-------------------------------------------------------
void ManualPaintModel::SetToleranceFill(double tolerancefill) 
{
	_fillfilter->SetToleranceFill(tolerancefill);
}

//---------------------------------------------------------------------------
void ManualPaintModel::SetDistanceFill(int distancefill) 
{
	_fillfilter->SetDistanceFill(distancefill);
}

//---------------------------------------------------------------------------
void ManualPaintModel::GetScalarRange(double * range) 
{
	_fillfilter->GetScalarRange(range);
}

//---------------------------------------------------------------------------
void ManualPaintModel::SetUndoImage() 
{
	ImageMManager* imMManager = NULL;
	if (_tool == 0) 
	{
	 	imMManager = this->_brushfilter->GetImageMManager();
	} // if 0
	if (_tool == 1) 
	{
		imMManager = this->_fillfilter->GetImageMManager();
	} // if 1
	this->_imageUndoRedo			-> SetURImages(imMManager);
//EED 2020-04-28  BORRAME Change to local variables to use with openmp
//	this->_imageUndoRedo_visited	-> SetURImages(imMManager);
	this->_brushfilter				-> CleanImageMManager();
	this->_fillfilter				-> CleanImageMManager();
}
//---------------------------------------------------------------------------

void ManualPaintModel::Undo() 
{
	this->_imageUndoRedo->Undo();
//EED 2020-04-28  BORRAME Change to local variables to use with openmp
//	this->_imageUndoRedo_visited->Undo();
}

void ManualPaintModel::Redo() 
{
	this->_imageUndoRedo->Redo();
//EED 2020-04-28  BORRAME Change to local variables to use with openmp
//	this->_imageUndoRedo_visited->Redo();
}


int ManualPaintModel::GetRestorBaseInitialPointX() 
{
	return 	this->_imageUndoRedo->GetRestorBaseInitialPointX();
}

int ManualPaintModel::GetRestorBaseInitialPointY() 
{
	return 	this->_imageUndoRedo->GetRestorBaseInitialPointY();
}

int ManualPaintModel::GetRestorBaseInitialPointZ() 
{
	return 	this->_imageUndoRedo->GetRestorBaseInitialPointZ();
}

void ManualPaintModel::Copy_GeneralAuxFill_to_Results()
{
	if (_tool == 0) 
	{
		//
	} // if 0
	if (_tool == 1)   // fillfilter
	{
		this->_fillfilter->Copy_GeneralAuxFill_to_Results();
	} // if 1
}

