/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "ManualPaintPanel.h"


ManualPaintPanel::ManualPaintPanel()
{
    _manualPaintControler=NULL;
}

//---------------------------------------------------------------------------
ManualPaintPanel::~ManualPaintPanel()
{
}

//---------------------------------------------------------------------------
void ManualPaintPanel::SetManualPaintControler(ManualPaintControler* manualPaintControler)
{
    _manualPaintControler = manualPaintControler;
}


//---------------------------------------------------------------------------
void ManualPaintPanel::SetBrushSize( int brushsize )
{
    if (_manualPaintControler!=NULL)
    {
        _manualPaintControler->GetManualPaintModel()->SetBrushSize( brushsize );
    } else {
       printf("ERROR  in  ManualPaintPanel  _manualPaintModel not set.\n");
    }
}

//---------------------------------------------------------------------------
void ManualPaintPanel::SetRangeMin( int min )
{
    if (_manualPaintControler!=NULL)
    {
    	_manualPaintControler->GetManualPaintModel()->SetRangeMin( min );
    } else {
       printf("ERROR  in  ManualPaintPanel  _manualPaintModel not set.\n");
    }
}

//---------------------------------------------------------------------------
void ManualPaintPanel::SetRangeMax( int max )
{
    if (_manualPaintControler!=NULL)
    {
    	_manualPaintControler->GetManualPaintModel()->SetRangeMax( max );
    } else {
       printf("ERROR  in  ManualPaintPanel  _manualPaintModel not set.\n");
    }
}

//---------------------------------------------------------------------------
void ManualPaintPanel::SetGrayLevel( double graylevel )
{
    if (_manualPaintControler!=NULL)
    {
        _manualPaintControler->GetManualPaintModel()->SetGrayLevel( graylevel );
    } else {
       printf("ERROR  in  ManualPaintPanel  _manualPaintModel not set.\n");
    }
}

//---------------------------------------------------------------------------
void ManualPaintPanel::SetTool(int tool)
{
    if (_manualPaintControler!=NULL)
    {
        _manualPaintControler->GetManualPaintModel()->SetTool( tool );
    } else {
       printf("ERROR  in  ManualPaintPanel  _manualPaintModel not set.\n");
    }
}

//---------------------------------------------------------------------------
void ManualPaintPanel::Set2D3D(int dim2D3D)
{
    if (_manualPaintControler!=NULL)
    {
        _manualPaintControler->GetManualPaintModel()->Set2D3D( dim2D3D );
    } else {
       printf("ERROR  in  ManualPaintPanel  _manualPaintModel not set.\n");
    }
}

//---------------------------------------------------------------------------
void ManualPaintPanel::SetBrushForm(int brushform)
{
    if (_manualPaintControler!=NULL)
    {
        _manualPaintControler->GetManualPaintModel()->SetBrushForm( brushform );
    } else {
       printf("ERROR  in  ManualPaintPanel  _manualPaintModel not set.\n");
    }
}

//---------------------------------------------------------------------------
void ManualPaintPanel::SetToleranceFill(double tolerancefill)
{
    if (_manualPaintControler!=NULL)
    {
        _manualPaintControler->GetManualPaintModel()->SetToleranceFill( tolerancefill );
    } else {
       printf("ERROR  in  ManualPaintPanel  _manualPaintModel not set.\n");
    }
}

//---------------------------------------------------------------------------
void ManualPaintPanel::SetDistanceFill(int distancefill)
{
    if (_manualPaintControler!=NULL)
    {
        _manualPaintControler->GetManualPaintModel()->SetDistanceFill( distancefill );
    } else {
       printf("ERROR  in  ManualPaintPanel  _manualPaintModel not set.\n");
    }
}

//---------------------------------------------------------------------------
void ManualPaintPanel::GetScalarRange( double * range )
{
	if (_manualPaintControler!=NULL)
	{
	    _manualPaintControler->GetManualPaintModel()->GetScalarRange( range );
	} else {
	   printf("ERROR  in  ManualPaintPanel  _manualPaintModel not set.\n");
	}
}

//---------------------------------------------------------------------------
void ManualPaintPanel::SetActive( bool active )
{
	if (_manualPaintControler!=NULL)
	{
	    _manualPaintControler->GetManualPaintModel()->SetActive( active );
	} else {
	   printf("ERROR  in  ManualPaintPanel  _manualPaintModel not set.\n");
	}
}

