/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "baseFilterManualPaint.h"

baseFilterManualPaint::baseFilterManualPaint() 
{
	_IMManager = new ImageMManager();
	_IMManager->CleanModifiedRegion();
	_graylevel 	= 0.0;
	_2D3D 		= 1; // 0 2D             ,   1 true 3D
	_direction 	= 0; // 1 XZ             ,   0 YZ            ,   2 XY
	_image 		= NULL;
	_image2 	= NULL;
	_minX 		= 0;
	_minY 		= 0;
	_minZ 		= 0;

//EED 2020-04-28  BORRAME Change to local variables to use with openmp
//	_maxX 		= 0;
//	_maxY 		= 0;
//	_maxZ 		= 0;
//	_pMinX 		= 0;
//	_pMinY 		= 0;
//	_pMinZ 		= 0;
//	_pMaxX 		= 0;
//	_pMaxY 		= 0;
//	_pMaxZ 		= 0;

	_dimX 		= 0;
	_dimY 		= 0;
	_dimZ 		= 0;
	_RangeMin 	= 0;
	_RangeMax	= 6000;
}

//---------------------------------------------------------------------------
baseFilterManualPaint::~baseFilterManualPaint() // virtual
{
}

//---------------------------------------------------------------------------
void baseFilterManualPaint::Run(int px, int py, int pz) // virtual
{
}

//---------------------------------------------------------------------------
void baseFilterManualPaint::SetGrayLevel(double graylevel) 
{
	_graylevel = graylevel;
}

//---------------------------------------------------------------------------
void baseFilterManualPaint::Set2D3D(int dim2D3D) 
{
	_2D3D = dim2D3D;
}

//---------------------------------------------------------------------------
void baseFilterManualPaint::SetDirection(int direction) 
{
	_direction = direction;
}

/* //EED 2020-04-28  BORRAME Change to local variables to use with openmp
//---------------------------------------------------------------------------
void baseFilterManualPaint::SetPoint(int px, int py, int pz) 
{
	_px = px;
	_py = py;
	_pz = pz;
}
*/
 
//---------------------------------------------------------------------------
void baseFilterManualPaint::SetImages(vtkImageData *image, vtkImageData *image2) 
{
	_image 	= image;
	_image2 = image2;
	int ext[6];
//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
	_image->GetWholeExtent(ext);
#else
	_image->GetExtent(ext);
#endif
	_minX = 0;
	_minY = 0;
	_minZ = 0;
	if (_image2!=NULL)
	{
		int extB[6];

//EED 2017-01-01 Migration VTK7
#if VTK_MAJOR_VERSION <= 5
		_image2->GetWholeExtent(extB);
#else
		_image2->GetExtent(extB);
#endif

		_dimX = std::min( ext[1]-ext[0]+1 , extB[1]-extB[0]+1 );
		_dimY = std::min( ext[3]-ext[2]+1 , extB[3]-extB[2]+1 );
		_dimZ = std::min( ext[5]-ext[4]+1 , extB[5]-extB[4]+1 );
	} else {
		_dimX = ext[1]-ext[0]+1;
		_dimY = ext[3]-ext[2]+1;
		_dimZ = ext[5]-ext[4]+1;
	} // if

	_OneColumn	= 1;
	_OneLine	= _dimX;
	_OnePlane	= _dimX*_dimY;
}



/*//EED 2020-04-28  BORRAME Change to local variables to use with openmp

//---------------------------------------------------------------------------
void baseFilterManualPaint::ResetGeneralMinMax() 
{
	_pMinX = 10000;
	_pMinY = 10000;
	_pMinZ = 10000;
	_pMaxX = -10000;
	_pMaxY = -10000;
	_pMaxZ = -10000;
}

//---------------------------------------------------------------------------
void baseFilterManualPaint::SetGeneralMinMax(int minX, int maxX, int minY,
		int maxY, int minZ, int maxZ) 
{
	if (_pMinX > minX) { _pMinX = minX; }
	if (_pMinY > minY) { _pMinY = minY; }
	if (_pMinZ > minZ) { _pMinZ = minZ; }
	if (_pMaxX < maxX) { _pMaxX = maxX; }
	if (_pMaxY < maxY) { _pMaxY = maxY; }
	if (_pMaxZ < maxZ) { _pMaxZ = maxZ; }
}
*/


//---------------------------------------------------------------------------
void baseFilterManualPaint::GetScalarRange(double * range) 
{
	range = this->_image->GetScalarRange();
}

//---------------------------------------------------------------------------
ImageMManager* baseFilterManualPaint::GetImageMManager() 
{
	return (this->_IMManager);
} //DFCH

//---------------------------------------------------------------------------
void baseFilterManualPaint::CleanImageMManager() 
{
	this->_IMManager->CleanModifiedRegion();
} //DFCH

//---------------------------------------------------------------------------
void baseFilterManualPaint::SetRangeMin(int min) 
{
	_RangeMin = min;
}

//---------------------------------------------------------------------------
void baseFilterManualPaint::SetRangeMax(int max) 
{
	_RangeMax = max;
}

//---------------------------------------------------------------------------
int baseFilterManualPaint::GetRangeMin() 
{
	return _RangeMin;
}

//---------------------------------------------------------------------------
int baseFilterManualPaint::GetRangeMax() 
{
	return _RangeMax;
}

