/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "vtkInteractorManualPaint.h"

#include "wxVtk2DBaseView.h"
#include "creawxVTKRenderWindowInteractor.h"

vtkInteractorManualPaint::vtkInteractorManualPaint(ManualPaintControler* mpc) 
{
	_manualPaintControler 	= mpc;
	_state 					= false;
	_stateKey 				= false;
	_stateMouse 			= false;
}

//---------------------------------------------------------------------------
vtkInteractorManualPaint::~vtkInteractorManualPaint() 
{
}

//---------------------------------------------------------------------------
bool vtkInteractorManualPaint::OnChar() 
{
	vtkRenderWindowInteractor *interactor = _vtkInteractorStyleBaseView->GetInteractor();
	if (interactor->GetKeyCode() == 97) 
	{
		_stateKey = !_stateKey;
	}
	return true;
}

//---------------------------------------------------------------------------
bool vtkInteractorManualPaint::OnLeftButtonDown() 
{
	vtkRenderWindowInteractor *interactor = _vtkInteractorStyleBaseView->GetInteractor();
	if (interactor->GetControlKey() == 1) {
		_state = true;
//      wxVtk2DBaseView             *wxvtk2Dbaseview    = (wxVtk2DBaseView*)_vtkInteractorStyleBaseView->GetWxVtk2DBaseView();
//      _Z      =   wxvtk2Dbaseview->GetActualSlice();
	}
	return true;
}

//---------------------------------------------------------------------------
bool vtkInteractorManualPaint::OnLeftButtonUp() 
{
    if((_state == true) || (_stateKey == true))
	{
//    	_manualPaintControler->SetImageUndo();
	}
	_state = false;
	return true;
}

//---------------------------------------------------------------------------
bool vtkInteractorManualPaint::OnMouseMove() 
{
	if ((_state == true) || (_stateKey == true)) 
	{
		wxVtk2DBaseView 					*wxvtk2Dbaseview 	= (wxVtk2DBaseView*) _vtkInteractorStyleBaseView->GetWxVtk2DBaseView();
		crea::wxVTKRenderWindowInteractor 	*wxVTKiren 			= wxvtk2Dbaseview->GetWxVTKRenderWindowInteractor();
		int px, py;
		wxVTKiren->GetEventPosition(px, py);
		double X = (double) px;
		double Y = (double) py;
		double Z = wxvtk2Dbaseview->GetActualSlice();
		wxvtk2Dbaseview->TransFromCoordScreenToWorld(X, Y, Z, true);
		_manualPaintControler->PaintImage((int) X, (int) Y, (int) Z,  wxvtk2Dbaseview->GetDirection() );
		this->_vtkInteractorStyleBaseView->SetParent_refresh_waiting();
    	_manualPaintControler->SetImageUndo();
	} // if _state
	return true;
}

