/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "wxManualPaintPanel.h"
#include <wx/radiobox.h>

wxManualPaintPanel::wxManualPaintPanel( wxWindow * parent )
		: wxPanel( parent, -1 )
{
	wxSizer *sizer = new wxFlexGridSizer( 1 );
	// Widget interface
	wxStaticText *tittleText = new wxStaticText( this, -1,_T("             Manual Paint") );
	//Title
	sizer->Add( tittleText );
	//giving some blank spaces
	sizer->Add( new wxStaticText( this, -1, _T("          key A : Enable/Disable   ") ) );
	this->ConfigureActiveCBButton( );
	this->ConfigureBrushToolRadioButton( );
	this->Configure2D3DRadioButton( );
	this->ConfigureBrushFormRadioButton( );
	this->ConfigureRangeBar( );
	this->ConfigureGrayLevelSld( );
	this->ConfigureBrushSizeSld( );
	this->ConfigureDistanceFillSld( );
	this->ConfigureTolFillSld( );
	this->ConfigureEditButtons( );
	//Buttons
	wxStaticText *editButtonsText 	= new wxStaticText( this, -1,_T("Edit Buttons") );
	this->_buttonsSizer 			= new wxFlexGridSizer( 4 );
	this->_buttonsSizer->Add( _btnUndo, 1, wxGROW );
	this->_buttonsSizer->Add( _btnRedo, 1, wxGROW );
	this->_buttonsSizer->Add( _btnCopy, 1, wxGROW );
	this->_gConfigSizer = new wxFlexGridSizer( 1 );
	//BrushTool Radio Button
	//giving blank space
	this->_gConfigSizer->Add(  new wxStaticText( this, -1, _T("             ") ) );
	//end of blank space
	this->_gConfigSizer->Add( _rbBrushTool, 1, wxGROW );
	//2D/3D Radio Button
	this->_gConfigSizer->Add( _rb2D3D, 1, wxGROW );
	//RangeBar
	this->_gConfigSizer->Add( new wxStaticText( this, -1, _T( "Select Range" ) ), 1, wxGROW );
	this->_gConfigSizer->Add( _mBarSlices, 1, wxGROW );
	//GrayLevel Slider
	this->_gConfigSizer->Add( _txtGrayLevel );

//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	wxFlexGridSizer *sizerGrayLevel = new wxFlexGridSizer( 2, wxHORIZONTAL );
#else
	wxFlexGridSizer *sizerGrayLevel = new wxFlexGridSizer( 2 );
#endif

	sizerGrayLevel->Add( _sldGrayLevel, 1, wxGROW );
	sizerGrayLevel->Add( _graylevelCtrl, 1,
		wxALIGN_BOTTOM | wxALIGN_LEFT | wxALL, 5 );
	this->_gConfigSizer->Add( sizerGrayLevel, 1, wxGROW );

	//Brush
	this->_brushSizer = new wxFlexGridSizer( 1 );
	//giving blank space
	this->_brushSizer->Add( new wxStaticText( this, -1, _T("             ") ) );
	//end of blank space
	this->_brushSizer->Add( new wxStaticText( this, -1, _T("Brush Settings") ) );
	//BrushSize Slider
	this->_brushSizer->Add( _txtBrushSize );

//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	wxFlexGridSizer *sizersdlBrushSize = new wxFlexGridSizer( 2, wxHORIZONTAL );
#else
	wxFlexGridSizer *sizersdlBrushSize = new wxFlexGridSizer( 2 );
#endif

	sizersdlBrushSize->Add( _sldBrushSize, 1, wxGROW );
	sizersdlBrushSize->Add( _BrushSizeCtrl, 1,
		wxALIGN_BOTTOM | wxALIGN_LEFT | wxALL, 5 );
	this->_brushSizer->Add( sizersdlBrushSize );
	//BrushForm RadioButton
	this->_brushSizer->Add( _rbBrushForm, 1, wxGROW );
	//Fill
	this->_FillSizer = new wxFlexGridSizer( 1 );
	//giving blank space
	this->_FillSizer->Add( new wxStaticText( this, -1, _T("             ") ) );
	//end of blank space
	this->_FillSizer->Add( new wxStaticText( this, -1, _T("Fill Settings") ) );
	//ToleranceFill
	this->_FillSizer->Add( _txtToleranceFill );
	wxFlexGridSizer *sizerTolerance = new wxFlexGridSizer( 2 );
	sizerTolerance->Add( _sldToleranceFill, 1, wxGROW );
	sizerTolerance->Add( _tolerancefillCtrl, 1, wxALIGN_BOTTOM | wxALIGN_LEFT | wxALL, 5 );
	this->_FillSizer->Add( sizerTolerance, 1, wxGROW );
	//Distance Fill
	this->_FillSizer->Add( _txtDistanceFill );
	wxFlexGridSizer *sizerDistance = new wxFlexGridSizer( 2 );
	sizerDistance->Add( _sldDistanceFill, 1, wxGROW );
	sizerDistance->Add( _distancefillCtrl, 1, wxALIGN_BOTTOM | wxALIGN_LEFT | wxALL, 5 );
	this->_FillSizer->Add( sizerDistance );
	sizer->Add( _activeCB );
	sizer->Add( editButtonsText );
	sizer->Add( _buttonsSizer );
	sizer->Add( _gConfigSizer );
	sizer->Add( _brushSizer );
	sizer->Add( _FillSizer );
	this->ConnectComponents( ); //DFCH
	this->_FillSizer->Show( false );
	this->SetSizer( sizer );
	this->SetAutoLayout( true );
	this->Layout( );
}

//---------------------------------------------------------------------------
wxManualPaintPanel::~wxManualPaintPanel( )
{
}

//--------------------------------------------------------------------------
void wxManualPaintPanel::ConfigureActiveCBButton( )
{
   _activeCB = new wxCheckBox (this, -1, _T("Active") );
   _activeCB->SetValue(true);
   SetActive( _activeCB->GetValue() );
}


//Panel Config
//--------------------------------------------------------------------------
void wxManualPaintPanel::ConfigureBrushToolRadioButton( )
{
	wxString lstBrushForm[ 2 ];
	lstBrushForm[ 0 ] = _T("rectangle/cube");
	lstBrushForm[ 1 ] = _T("circle/sphere");
	_rbBrushForm = new wxRadioBox( this, -1, _T("Brush form"),
		wxDefaultPosition, wxSize( 270, 45 ), 2, lstBrushForm, 2,
		wxRA_SPECIFY_COLS );
}

//--------------------------------------------------------------------------
void wxManualPaintPanel::Configure2D3DRadioButton( )
{
	wxString lst2D3D[ 2 ];
	lst2D3D[ 0 ] = _T("2D");
	lst2D3D[ 1 ] = _T("3D");
	_rb2D3D = new wxRadioBox( this, -1, _T("2D / 3D"), wxDefaultPosition,
		wxSize( 270, 45 ), 2, lst2D3D, 2, wxRA_SPECIFY_COLS );
	_rb2D3D->SetSelection( 1 );

}

//--------------------------------------------------------------------------
void wxManualPaintPanel::ConfigureBrushFormRadioButton( )
{
	wxString lstBrushTool[ 2 ];
	lstBrushTool[ 0 ] = _T("Brush");
	lstBrushTool[ 1 ] = _T("Fill");
	_rbBrushTool = new wxRadioBox( this, -1, _T("Brush tool"),
		wxDefaultPosition, wxSize( 270, 45 ), 2, lstBrushTool, 2,
		wxRA_SPECIFY_COLS );
}

//--------------------------------------------------------------------------
void wxManualPaintPanel::ConfigureRangeBar( )
{
	//DFCH -- BarSlices
	double range[ 2 ];
	GetScalarRange( range );
	int min = 0; //range[0];
	int max = 6000; //range[1];
	_mBarSlices = new mBarRange( this, 70, 65 );
	_mBarSlices->SetMin( 0 );
	_mBarSlices->SetStart( 0 );
	_mBarSlices->SetOrientation( true );
	_mBarSlices->setActiveStateTo( true );
	_mBarSlices->setVisibleLabels( true );
	_mBarSlices->setDeviceEndMargin( 10 );
	_mBarSlices->setDeviceBlitStart( 10, 10 );
	_mBarSlices->setIfWithActualDrawed( false );
	_mBarSlices->setRepresentedValues( min, max );
	_mBarSlices->SetStart( min );
	_mBarSlices->SetEnd( max );
	_mBarSlices->Update( );
	SetRangeMin( min );
	SetRangeMax( max );
	//DFCH -- End BarSlices
}

//--------------------------------------------------------------------------
void wxManualPaintPanel::ConfigureGrayLevelSld( )
{
	_txtGrayLevel = new wxStaticText( this, -1,
	wxString( _T("  Gray Level  ") ) );
	_sldGrayLevel = new wxSlider( this, -1, 0, 0, 255, wxDefaultPosition,
	wxDefaultSize, wxSL_LABELS );
	_sldGrayLevel->SetMinSize( wxSize( 200, -1 ) );
	_sldGrayLevel->SetMaxSize( wxSize( 200, -1 ) );
	_graylevelCtrl = new wxSpinCtrl( this, wxID_ANY, wxEmptyString,
	wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 65535, 0 );
}

//--------------------------------------------------------------------------
void wxManualPaintPanel::ConfigureBrushSizeSld( )
{
	_txtBrushSize = new wxStaticText( this, -1,
	wxString( _T("  Brush size  ") ) );
	_sldBrushSize = new wxSlider( this, -1, 5, 1, 50, wxDefaultPosition,
	wxDefaultSize, wxSL_LABELS );
	_BrushSizeCtrl = new wxSpinCtrl( this, wxID_ANY, wxEmptyString,
	wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 65535, 0 );
	_sldBrushSize->SetMinSize( wxSize( 200, -1 ) );
	_sldBrushSize->SetMaxSize( wxSize( 200, -1 ) );
}

//--------------------------------------------------------------------------
void wxManualPaintPanel::ConfigureDistanceFillSld( )
{
	_txtDistanceFill = new wxStaticText( this, -1,
	wxString( _T("  Distance fill  ") ) );
	_sldDistanceFill = new wxSlider( this, -1, 5, 1, 500, wxDefaultPosition,
	wxDefaultSize, wxSL_LABELS );
	_sldDistanceFill->SetMinSize( wxSize( 200, -1 ) );
	_sldDistanceFill->SetMaxSize( wxSize( 200, -1 ) );
	_distancefillCtrl = new wxSpinCtrl( this, wxID_ANY, wxEmptyString,
	wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 500, 50 );
	_txtDistanceFill->Disable( );
	_sldDistanceFill->Disable( );
	_distancefillCtrl->Disable( );
}

//--------------------------------------------------------------------------
void wxManualPaintPanel::ConfigureTolFillSld( )
{
	_txtToleranceFill = new wxStaticText( this, -1,wxString( _T("  Tolerance fill  ") ) );
	_sldToleranceFill = new wxSlider( this, -1, 125, 0, 255, wxDefaultPosition,wxDefaultSize, wxSL_LABELS );
	_sldToleranceFill->SetMinSize( wxSize( 200, -1 ) );
	_sldToleranceFill->SetMaxSize( wxSize( 200, -1 ) );
	_tolerancefillCtrl = new wxSpinCtrl( this, wxID_ANY, wxEmptyString,wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 65535, 50 );
	_txtToleranceFill->Disable( );
	_sldToleranceFill->Disable( );
	_tolerancefillCtrl->Disable( );
}

//--------------------------------------------------------------------------
void wxManualPaintPanel::ConfigureEditButtons( )
{
	_btnCopy = new wxButton( this, -1, _T("Copy") );
	_btnCopy->Disable( );
	_btnUndo = new wxButton( this, -1, _T("Undo") );
	_btnRedo = new wxButton( this, -1, _T("Redo") );
	//btnUndo->Disable();
}
//--------------------------------------------------------------------------

/*
 * The following function allows the management of the events
 */
void wxManualPaintPanel::ConnectComponents( ) //DFCH
{
	this->Connect(_sldBrushSize->GetId( ),
		wxEVT_SCROLL_THUMBRELEASE,
		(wxObjectEventFunction) (void(wxPanel::*)(
		wxScrollEvent& )) (&wxManualPaintPanel::OnBrushSize) );this ->Connect (_sldGrayLevel->GetId(),
		wxEVT_SCROLL_THUMBRELEASE,
                (wxObjectEventFunction) (void(wxPanel::*)( wxScrollEvent&)) &wxManualPaintPanel::OnSldGrayLevel);

		this->Connect(  _graylevelCtrl->GetId(),
				wxEVT_COMMAND_TEXT_UPDATED,
				(wxObjectEventFunction) (void(wxPanel::*)(
								wxCommandEvent&)) &wxManualPaintPanel::OnCtrTxtGrayLevel);

		this->Connect (
				_sldToleranceFill->GetId(),
				wxEVT_SCROLL_THUMBRELEASE,
				(wxObjectEventFunction) (void(wxPanel::*)(
								wxScrollEvent&)) &wxManualPaintPanel::OnSldToleranceFill);this->Connect
		(
				_tolerancefillCtrl->GetId(),
				wxEVT_COMMAND_TEXT_UPDATED,
				(wxObjectEventFunction) (void(wxPanel::*)(
								wxCommandEvent&)) &wxManualPaintPanel::OnCtrTxtToleranceFill);

		this->Connect (
				_sldDistanceFill->GetId(),
				wxEVT_SCROLL_THUMBRELEASE,
				(wxObjectEventFunction) (void(wxPanel::*)(
								wxScrollEvent&)) &wxManualPaintPanel::OnSldDistanceFill);this->Connect
		(
				_distancefillCtrl->GetId(),
				wxEVT_COMMAND_TEXT_UPDATED,
				(wxObjectEventFunction) (void(wxPanel::*)(
								wxCommandEvent&)) &wxManualPaintPanel::OnCtrTxtDistanceFill);

		this->Connect (
				_rb2D3D->GetId(),
				wxEVT_COMMAND_RADIOBOX_SELECTED,
				(wxObjectEventFunction) (void(wxPanel::*)(
								wxCommandEvent&)) &wxManualPaintPanel::On2D3D);this->Connect
		(
				_rbBrushForm->GetId(),
				wxEVT_COMMAND_RADIOBOX_SELECTED,
				(wxObjectEventFunction) (void(wxPanel::*)(
								wxCommandEvent&)) &wxManualPaintPanel::OnBrushForm);this->Connect
		(
				_rbBrushTool->GetId(),
				wxEVT_COMMAND_RADIOBOX_SELECTED,
				(wxObjectEventFunction) (void(wxPanel::*)(
								wxCommandEvent&)) &wxManualPaintPanel::OnTool);this->Connect
		(
				_btnCopy->GetId(),
				wxEVT_COMMAND_BUTTON_CLICKED,
				(wxObjectEventFunction) (void(wxPanel::*)(
								wxCommandEvent&)) &wxManualPaintPanel::OnCopy);

		this->Connect (
				_btnUndo->GetId(),
				wxEVT_COMMAND_BUTTON_CLICKED,
				(wxObjectEventFunction) (void(wxPanel::*)(
								wxCommandEvent&)) &wxManualPaintPanel::OnUndo);
		this->Connect(_btnRedo->GetId(),
				wxEVT_COMMAND_BUTTON_CLICKED,
				(wxObjectEventFunction) (void(wxPanel::*)(
								wxCommandEvent&)) &wxManualPaintPanel::OnRedo); //DFCH

		this->Connect(
				_mBarSlices->GetId(),
				wxEVT_TSBAR,
				(wxObjectEventFunction) (wxCommandEventFunction) &wxManualPaintPanel::onBarrange);
		//			Connect(modBarRange->GetId(),98765,(wxObjectEventFunction) (wxCommandEventFunction)  &wxWidgetSliderMinMax::onActualChange_Bar );
		this->Connect(
				_mBarSlices->GetId(),
				wxEVT_TSBAR_ACTUAL,
				(wxObjectEventFunction) (wxCommandEventFunction) &wxManualPaintPanel::onActualChange_Bar);
		this->Connect(
				_mBarSlices->GetId(),
				wxEVT_TSBAR_START,
				(wxObjectEventFunction) (wxCommandEventFunction) &wxManualPaintPanel::onStartChange_Bar);
		this->Connect(
				_mBarSlices->GetId(),
				wxEVT_TSBAR_END,
				(wxObjectEventFunction) (wxCommandEventFunction) &wxManualPaintPanel::onEndChange_Bar);
		this->Connect(
				_mBarSlices->GetId(),
				wxEVT_SELECTION_END,
				(wxObjectEventFunction) (wxCommandEventFunction) &wxManualPaintPanel::onSelectionEnd);
		this->Connect(
				_mBarSlices->GetId(),
				wxEVT_TSBAR_MOVED,
				(wxObjectEventFunction) (wxCommandEventFunction) &wxManualPaintPanel::onMovedBar);
		this->Connect
		(
				_BrushSizeCtrl->GetId(),
				wxEVT_COMMAND_TEXT_UPDATED,
				(wxObjectEventFunction) (void(wxPanel::*)(
								wxCommandEvent&)) &wxManualPaintPanel::OnCtrBrushSize);
		this->Connect
		(
			_activeCB->GetId(),
	     		wxEVT_COMMAND_CHECKBOX_CLICKED, 
	     		(wxObjectEventFunction) (void (wxPanel::*)(wxCommandEvent&))&wxManualPaintPanel::OnActive);
	}


  //-------------------------------------------------------------------------
  void wxManualPaintPanel::OnActive(wxCommandEvent& event)
  {
	SetActive( _activeCB->GetValue() );
  }


//---------------------------------------------------------------------------
void wxManualPaintPanel::OnBrushSize( wxScrollEvent& event )
{
	SetBrushSize( this->_sldBrushSize->GetValue( ) );
	wxString text;
	text.Printf( wxT("%d"), this->_sldBrushSize->GetValue( ) );
	_BrushSizeCtrl->SetValue( text );
}

//---------------------------------------------------------------------------
void wxManualPaintPanel::OnSldGrayLevel( wxScrollEvent& event )
{
	SetGrayLevel( (double) ( _sldGrayLevel->GetValue( )) );
	wxString text;
	text.Printf( wxT("%d"), _sldGrayLevel->GetValue( ) );
	_graylevelCtrl->SetValue( text );
}

//---------------------------------------------------------------------------
void wxManualPaintPanel::OnCtrTxtGrayLevel( wxCommandEvent &event )
{
	int graylevel = this->_graylevelCtrl->GetValue( );
	this->_sldGrayLevel->SetValue( graylevel );
	SetGrayLevel( graylevel );
}

//---------------------------------------------------------------------------
void wxManualPaintPanel::OnSldDistanceFill( wxScrollEvent& event )
{
	SetDistanceFill( (double) ( _sldDistanceFill->GetValue( )) );
	wxString text;
	text.Printf( wxT("%d"), _sldDistanceFill->GetValue( ) );
	_distancefillCtrl->SetValue( text );
}

//---------------------------------------------------------------------------
void wxManualPaintPanel::OnCtrTxtDistanceFill( wxCommandEvent &event )
{
	int distancefill = this->_distancefillCtrl->GetValue( );
	this->_sldDistanceFill->SetValue( distancefill );
	SetDistanceFill( distancefill );
}
//---------------------------------------------------------------------------
void wxManualPaintPanel::OnCtrBrushSize( wxCommandEvent &event )
{
	int brushSize = _BrushSizeCtrl->GetValue( );
	this->_sldBrushSize->SetValue( brushSize );
	SetBrushSize( brushSize );
}

//---------------------------------------------------------------------------
void wxManualPaintPanel::OnSldToleranceFill( wxScrollEvent& event )
{
	SetToleranceFill( (double) ( _sldToleranceFill->GetValue( )) );
	wxString text;
	text.Printf( wxT("%d"), _sldToleranceFill->GetValue( ) );
	_tolerancefillCtrl->SetValue( text );
}

//---------------------------------------------------------------------------
void wxManualPaintPanel::OnCtrTxtToleranceFill( wxCommandEvent &event )
{
	int tolerance = _tolerancefillCtrl->GetValue( );
	this->_sldToleranceFill->SetValue( tolerance );
	SetToleranceFill( tolerance );
}

//---------------------------------------------------------------------------
void wxManualPaintPanel::DisableControls( )
{
	_txtBrushSize->Disable( );
	_sldBrushSize->Disable( );
	_rbBrushForm->Disable( );

	_txtToleranceFill->Disable( );
	_sldToleranceFill->Disable( );
	_tolerancefillCtrl->Disable( );

	_txtDistanceFill->Disable( );
	_sldDistanceFill->Disable( );
	_distancefillCtrl->Disable( );
}

//---------------------------------------------------------------------------
void wxManualPaintPanel::On2D3D( wxCommandEvent &event )
{
	Set2D3D( _rb2D3D->GetSelection( ) );
}

//---------------------------------------------------------------------------
void wxManualPaintPanel::OnBrushForm( wxCommandEvent &event )
{
	SetBrushForm( _rbBrushForm->GetSelection( ) );
}

//---------------------------------------------------------------------------
void wxManualPaintPanel::OnTool( wxCommandEvent &event )
{
	DisableControls( );
	SetTool( _rbBrushTool->GetSelection( ) );

	if( _rbBrushTool->GetSelection( ) == 0 ) //Brush tool
	{
		_txtBrushSize->Enable( );
		_sldBrushSize->Enable( );
		_rbBrushForm->Enable( );
		_brushSizer->Show( true );
		_FillSizer->Show( false );
		this->Layout( );
	}

	if( _rbBrushTool->GetSelection( ) == 1 ) //Fill tool
	{
		_txtToleranceFill->Enable( );
		_sldToleranceFill->Enable( );
		_tolerancefillCtrl->Enable( );
		_txtDistanceFill->Enable( );
		_sldDistanceFill->Enable( );
		_distancefillCtrl->Enable( );
		_FillSizer->Show( true );
		_brushSizer->Show( false );
		this->Layout( );
	}
}

//---------------------------------------------------------------------------
void wxManualPaintPanel::OnCopy( wxCommandEvent &event )
{
}

//---------------------------------------------------------------------------
void wxManualPaintPanel::OnUndo( wxCommandEvent &event )
{
	this->_manualPaintControler->Undo( );
}

//---------------------------------------------------------------------------
void wxManualPaintPanel::OnRedo( wxCommandEvent &event )
{
	this->_manualPaintControler->Redo( );
}

//--------------------------------------------------------------------------------------------------------------------------------
// Min-Max Barrange received events
//--------------------------------------------------------------------------------------------------------------------------------
void wxManualPaintPanel::onBarrange( wxCommandEvent& event )
{
}

void wxManualPaintPanel::onActualChange_Bar( wxCommandEvent& event )
{
	/*mbbtkSliderMinMax->bbSetOutputOutActual(modBarRange->GetActual());
	 mbbtkSliderMinMax->bbSignalOutputModification(std::string("OutActual"));*/
}

void wxManualPaintPanel::onStartChange_Bar( wxCommandEvent& event )
{
	SetRangeMin( _mBarSlices->GetStart( ) );
}

void wxManualPaintPanel::onEndChange_Bar( wxCommandEvent& event )
{
	SetRangeMax( _mBarSlices->GetEnd( ) );
}

void wxManualPaintPanel::onSelectionEnd( wxCommandEvent& event )
{
}

void wxManualPaintPanel::onMovedBar( wxCommandEvent& event )
{
}
//-------------------------------------------------------------------------
//--------------------------------------------------------------------------
//--------------------------------------------------------------------------

