/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "manualViewPerpPlaneContour.h"

#include "vtkPlane2DView.h"

manualViewPerpPlaneContour::manualViewPerpPlaneContour()
{
}
// ----------------------------------------------------------------------------
manualViewPerpPlaneContour::~manualViewPerpPlaneContour()
{
}


// ----------------------------------------------------------------------------
manualViewPerpPlaneContour * manualViewPerpPlaneContour :: Clone()
{
	manualViewPerpPlaneContour * clone = new manualViewPerpPlaneContour();
	CopyAttributesTo(clone);
	return clone;
}

// ---------------------------------------------------------------------------

void manualViewPerpPlaneContour::CopyAttributesTo( manualViewPerpPlaneContour * cloneObject)
{
	// Fathers object
	manualViewContour::CopyAttributesTo(cloneObject);
}




// ----------------------------------------------------------------------------
void manualViewPerpPlaneContour::UpdateViewPoint(int id)
{  // virtual
	double x,y,z;
	manualPoint *mp = _manContModel->GetManualPoint(id);
	x = mp->GetX();
	y = mp->GetY();
	z = mp->GetZ();
	FilterCordinateXYZ(x,y,z);

	_lstViewPoints[id]->SetPositionXY( x , y ,GetRange(), z );
	if ((z>=-1) && (z<=1))
	{
		_lstViewPoints[id]->GetVtkActor()->VisibilityOn();
	} else {
		_lstViewPoints[id]->GetVtkActor()->VisibilityOff();
	}
}
// ----------------------------------------------------------------------------
void manualViewPerpPlaneContour::FilterCordinateXYZ (double &x, double &y, double &z)
{
	vtkPlane2DView *vtkplane2Dview = (vtkPlane2DView*)( this->GetWxVtkBaseView() );
	vtkMPRBaseData *vtkmprbasedata = vtkplane2Dview->GetVtkmprbasedata();
	vtkTransform *transf1 = vtkTransform::New();
	vtkTransform *transf2 = vtkmprbasedata->GetTransformOrientation();
	transf1->SetMatrix( transf2->GetMatrix() ); 
	transf1->Inverse();

	double in[4], out[4];
	double center = vtkplane2Dview->GetImgSize() / 2;

	in[0] = x - vtkmprbasedata->GetX();
	in[1] = y - vtkmprbasedata->GetY();
	in[2] = z - vtkmprbasedata->GetZ();
	in[3] = 0;

	transf1->MultiplyPoint(in,out);
	z = out[0];
	x = out[1]+center;
	y = out[2]+center;

	double spc[3];
	this->GetWxVtkBaseView()->GetSpacing(spc);
	x = x / spc[0];
	y = y / spc[1];
	z = z / spc[2];

	transf1->Delete();
}

// ----------------------------------------------------------------------------
void manualViewPerpPlaneContour::TransfromCoordViewWorld( double &X,double &Y,double &Z,int type )
{
	Z = 0;
	vtkPlane2DView *vtkplane2Dview = (vtkPlane2DView*)( this->GetWxVtkBaseView() );
	vtkplane2Dview->TransfromCoordViewWorld2(X,Y,Z);
}


// ----------------------------------------------------------------------------
void manualViewPerpPlaneContour::RefreshContour() // virtual
{
//	manualViewContour::RefreshContour();

	double pp1[3];
	double pp2[3];
	double u;
		
// JSTG 25-02-08 ----------------------------------------------------------
//		tt;
//--------------------------------------------------------

	double pp[3];
	double ppB[3];
	double ppC[3];
	ppB[0] = 999999;
	double dist,distMin = 99999999;

	vtkPlane2DView *vtkplane2Dview = (vtkPlane2DView*)( this->GetWxVtkBaseView() );
	double center = vtkplane2Dview->GetImgSize() / 2;

	int i,np,nps;
	np		= GetNumberOfPoints( );

//JSTG 25-02-08 ------------------------------------------
	//double t,delta;
    //nps		= GetNumberOfPointsSpline(); 
	nps = _manContModel->GetNumberOfPointsSpline();
	//delta	= ( double ) ( np  ) / ( double ) ( nps-1  );
	_manContModel->UpdateSpline();
//--------------------------------------------------------

	if ( np >= 2 )
	{
		for( i = 0; i < nps; i++ ) 
		{
// JSTG 25-02-08 ----------------------------------------------------------
			//t	= delta * (double)i ;
			//tt	= delta * (double)(i+1) ;
			//_manContModel->GetSplinePoint(t ,pp1[0],pp1[1],pp1[2]);
			//_manContModel->GetSplinePoint(tt,pp2[0],pp2[1],pp2[2]);
			_manContModel->GetSpline_i_Point(i ,&pp1[0],&pp1[1],&pp1[2]);
			_manContModel->GetSpline_i_Point(i+1,&pp2[0],&pp2[1],&pp2[2]);
//--------------------------------------------------------------------------
			FilterCordinateXYZ(pp1[0],pp1[1],pp1[2]);
			FilterCordinateXYZ(pp2[0],pp2[1],pp2[2]);
			if (pp2[2]*pp1[2]<=0)
			{
				if (pp1[2]-pp2[2]!=0) { 
					u = -pp2[2] / (pp1[2]-pp2[2]);
				} else  {
					u=9999999;
				}
				pp[0]	 = ( pp1[0]-pp2[0] )*u + pp2[0];
				pp[1]	 = ( pp1[1]-pp2[1] )*u + pp2[1];
				pp[2]	 = ( pp1[2]-pp2[2] )*u + pp2[2];
				ppC[0] = pp[0] - center;
				ppC[1] = pp[1] - center;
				ppC[2] = pp[2] ;
				dist = sqrt( ppC[0]*ppC[0] + ppC[1]*ppC[1] + ppC[2]*ppC[2] );
				if (dist<distMin)
				{
					distMin=dist;
					ppB[0] = pp[0];
					ppB[1] = pp[1];
					ppB[2] = pp[2];
				}
			}

		}// for 
	} else {
			_pts->SetPoint(0, 0 , 0 , 0);	
			_pts->SetPoint(1, 0 , 0 , 0);	
	} // if

//EED 27 sep 2006
	ppB[0]=ppB[0]*_spc[0];
	ppB[1]=ppB[1]*_spc[1];

	_pts->SetPoint( 0, ppB[0]   , ppB[1]+1 , 1 );	
	_pts->SetPoint( 1, ppB[0]   , ppB[1]-1 , 1 );	
	_pts->SetPoint( 2, ppB[0]   , ppB[1]   , 1 );	
	_pts->SetPoint( 3, ppB[0]-1 , ppB[1]   , 1 );	
	_pts->SetPoint( 4, ppB[0]+1 , ppB[1]   , 1 );	


	for( i = 5; i < nps; i++ ) 
	{
		_pts->SetPoint( i, ppB[0] , ppB[1] , 1 );	
	}

}

//---------------------------------------------------------------------------
bool manualViewPerpPlaneContour::ifTouchContour( int x, int y, int z)
{
	bool ok=false;
	vtkPlane2DView *vtkplane2Dview = (vtkPlane2DView*)( this->GetWxVtkBaseView() );
	double X=x;
	double Y=y;
	double Z=z;
	vtkplane2Dview->TransFromCoordScreenToWorld(X,Y,Z);
	
	double ppA[3];
	_pts->GetPoint(0, ppA);
	if (sqrt( (ppA[0]-X)*(ppA[0]-X) + (ppA[1]-Y)*(ppA[1]-Y) ) <=2)
	{
		ok = true;
	}
	return ok;
}

