/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*
 This class plots image's histograms in a plotter
*/

 //---------------------
 // Includes
 //----------------------
 #include "Histogram.h"
 #include  "vtkImageCast.h"
 #include  <math.h>
// ----------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------

	#ifndef WX_PRECOMP
	#include <wx/wx.h>
	#endif

//----------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------

IMPLEMENT_CLASS(Histogram, wxWindow)
//----------------------------------------------------------------------------
// Event Table
//----------------------------------------------------------------------------

BEGIN_EVENT_TABLE(Histogram, wxWindow)
	EVT_SIZE  (Histogram::OnSize)
END_EVENT_TABLE()
 //---------------------
 // Constructor
 //----------------------

//EED Borrame 07Mai2009
//Histogram::Histogram( wxWindow *parent, wxWindowID id, const wxPoint &pos, const wxSize &size, int flag,vtkImageData* imageData):
	Histogram::Histogram( wxWindow *parent, wxWindowID id, const wxPoint &pos, const wxSize &size, int flag):
	wxPanel(parent,id,pos,size,flag)
	{
		 SetBackgroundColour(wxColour(255,255,255));
		//histogram
//EED Borrame 07Mai2009
//		histogram= new pHistogram(imageData);
		
		//plotter
		plotter=new pPlotterWindow(this, -1, wxPoint(0,0), wxSize(742,476), wxSUNKEN_BORDER );
		
		plotter->AddLayer(new pPlotterScaleX());
		plotter->AddLayer(new pPlotterScaleY());
		//is a plotter of histograms
		plotter->setType(2);
		//setting the popMenu
		plotter->setPopUpMenu(true,true,true,true,true,true,false,false,false,false,false,false,false);
		histogramSize=0;
		
		idHistogram=-1;
		
//EED Borrame 07Mai2009
		//drawing
//		drawHistogram();
		
		
	}

	Histogram::~Histogram()
	{
		delete histogram;
		delete plotter;

	}

   void Histogram::Configure(vtkImageData* imageData)
	{
		histogram= new pHistogram(imageData);
		drawHistogram();
	}

	/*
	Draw the histogram in the plotter
	*/
	void Histogram::drawHistogram()
	{
		//int xValues[MAX],yValues[MAX],extent[6];
		double* xValues;
		double* yValues;
		
		vtkImageData* histogramImageData=histogram->getHistogram();
		
		//size
		histogramSize=histogram->getSize();

		//plotting
		xValues=(double*)malloc(NUM_POINTS*sizeof(double));
		yValues=(double*)malloc(NUM_POINTS*sizeof(double));
		
		double* histogramPointer=(double*)histogramImageData->GetScalarPointer(0,0,0);
		
		int i;
		for(i=0; i< histogramSize; i++)
		{
			xValues[i]=i;
			if (histogramPointer[i]==0)
			{
				yValues[i]=0;
			} else {
				yValues[i]=log(histogramPointer[i])*10;
			} // if histogramPointer
		} // for i

		
		pGraphicalFunction* histogramFunction=plotter->getFunctionForVectors(xValues,histogramSize,yValues,histogramSize);
		
		if (histogramFunction)
		{
			histogramFunction->setEditable(false);
			//smooth function
			histogramFunction->setType(2);
			//it is an histogram
			histogramFunction->setmType(2);
			idHistogram=plotter->addFunction(histogramFunction);
			//for setting range the vision
			plotter->addFunctionToMove(histogramFunction);
			wxPen mypen1(*wxBLUE, 1, wxSOLID );
			mypen1.SetWidth(2);
			histogramFunction->SetPen( mypen1 );
		}
		
		
			free(xValues);
			free(yValues);
		
		//plotter->setPopUpMenu(true,true,false,false,true,true,false,false,false,false,false,false,false);
	}
	
	/*
		if the user resize the window	
	*/
	void Histogram::OnSize(wxSizeEvent &WXUNUSED(event))
	{
		int scrX,scrY;
		GetClientSize(&scrX,&scrY);
		plotter->SetSize(scrX,scrY);

		/*
		pGraphicalFunction* actual=plotter->getFunction(idTransferenceFunction);
		actual->setScreens(scrX,scrY);
		actual->setScales();
		*/
	}
	
	/*
		get a point of the Histogram
		given the grey value
	*/
	int Histogram::getHistogramPoint(int gValue)
	{
		return histogram->getHistogramPoint(gValue);
	}
	

	//-------------------
	// Getter and setters
	//-------------------

	int Histogram::getHistogramSize()
	{
		return histogramSize;
	}

	wxWindow* Histogram::GetWindow()
	{
		return this;
	}

	pPlotterWindow* Histogram::GetPlotterWindow()
	{
		return plotter;
	} 



