/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#include "HistogramBase.h"

// -- inluces for HistogramMinMaxLevel
#include "pPlotterWindow.h"
#include "Histogram.h"




//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
	HistogramBase::HistogramBase()
	{		
	}

//-----------------------------------------------------------------------------
	HistogramBase::~HistogramBase()
	{
	}

//-----------------------------------------------------------------------------
	HistogramBase* HistogramBase::GetConcretComponent()
	{
		return this;
	}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
	HistogramDecorator::HistogramDecorator()
	{		
	}

//-----------------------------------------------------------------------------
	HistogramDecorator::~HistogramDecorator()
	{
	}

//-----------------------------------------------------------------------------
	HistogramBase* HistogramDecorator::GetConcretComponent()
	{
		return _histogrambase->GetConcretComponent();
	}



//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
	HistogramMinMaxLevel::HistogramMinMaxLevel(HistogramBase* histogrambase)
	{		
								_histogrambase = histogrambase;
		wxWindow *histogramebasePanel		=_histogrambase->GetWindow();
		wxPanel *panel 						= new wxPanel( histogramebasePanel->GetParent() , -1, wxDefaultPosition, wxSize(600,600) );
		histogramebasePanel->Reparent(panel);
								_barrange2 		= new mBarRange2(panel, 30, 20); 
		_barrange2->PushEventHandler((wxEvtHandler*)this);
		Connect(_barrange2->GetId(), wxEVT_BarRange2_Change ,
					(wxObjectEventFunction) (wxCommandEventFunction) &HistogramMinMaxLevel::onBarRangeChange );
		wxFlexGridSizer* 	sizer				= new wxFlexGridSizer(1);
		sizer->Add( histogramebasePanel	, 1, wxGROW );
		sizer->Add( _barrange2				, 1, wxGROW );
		panel->SetSizer( sizer );
		panel->SetAutoLayout( true );
		panel->Layout();
		_panel = panel;
	}

//-----------------------------------------------------------------------------
	HistogramMinMaxLevel::~HistogramMinMaxLevel()
	{
	}

//-----------------------------------------------------------------------------
	wxWindow* HistogramMinMaxLevel::GetWindow()
	{
		return _panel;
	}

//-----------------------------------------------------------------------------
	void HistogramMinMaxLevel::Configure(vtkImageData* img)
	{
		_histogrambase->Configure(img);	
		double range[2];
		img->GetScalarRange(range);
		_barrange2->SetScalarType( img->GetScalarType() );
		_barrange2->SetMinMaxValue(range[0],range[1]);
	}

//-----------------------------------------------------------------------------
void HistogramMinMaxLevel::onBarRangeChange(wxCommandEvent& event)
{
	Histogram* 			histogram 		= (Histogram*)GetConcretComponent();
	pPlotterWindow* 	plotterwindow 	= histogram->GetPlotterWindow();	

	plotterwindow->setLineGuidesCondition(true);
	double startvalue = _barrange2->GetStartValue();
	plotterwindow->setRealGuideX( startvalue*100 );
	plotterwindow->setRealGuideY( startvalue*100 );
	
	if (plotterwindow->drawGuideLines()==true)
	{
		printf ("YES \n");
	} else {
		printf ("NO \n");
	}

	plotterwindow->UpdateAll();

}




