/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "HistogramDialog.h"
#include <vector>

#include "OpenImage.xpm"
#include "Save.xpm"
#include "Ok.xpm"
#include "Cancel.xpm"
#include "Delete.xpm"

#include "creaSystem.h"



// IMPLEMENT_CLASS(HistogramDialog, wxDialog)


//id for events
enum {
    ID_SAVE  = 108,
	ID_LOAD,
	ID_REFRESH
};

//-------------------------
//Constructor
//-------------------------
HistogramDialog::HistogramDialog(wxWindow *parent,wxString title,vtkImageData* imageData,bool extracontrols)
:wxDialog(parent,-1,title,wxDefaultPosition,wxDefaultSize,wxRESIZE_BORDER|wxDEFAULT_DIALOG_STYLE   ,_T("dialogBox"))
{

	initializeHistogramDialog(extracontrols);
	initializeHistogram(imageData);

}

HistogramDialog::HistogramDialog(wxWindow *parent,wxString title,bool extracontrols)
:wxDialog(parent,-1,title,wxDefaultPosition,wxDefaultSize,wxRESIZE_BORDER|wxDEFAULT_DIALOG_STYLE   ,_T("dialogBox")){
	
	initializeHistogramDialog(extracontrols);
}
HistogramDialog::~HistogramDialog(){	

}

void HistogramDialog::initializeHistogramDialog(bool extracontrols){
	_currentcolorselectedbitmap = -1;
    _ctfun=NULL;
	_tfun=NULL;
	_panextracontrols=NULL;
	_maxgreyvalue = 1;

	SetBackgroundColour(wxColour(255,255,255));
	/*
	Pointers
	*/
	//wxvtkmpr3Dview=NULL;
	//wxvtkclipping3Dview=NULL;
	
	/*
	 Histogram
	*/
	
	histogramW=new HistogramWidget(this, -1);
	
	/*
	Buttons
	*/
	wxBitmap bitmap0(Ok_xpm);
	okBtn = new wxBitmapButton(this, wxID_OK, bitmap0,wxDefaultPosition,wxDefaultSize);		
	
	wxBitmap bitmap1(Cancel_xpm);
	cancelBtn = new wxBitmapButton(this, wxID_CANCEL, bitmap1,wxDefaultPosition,wxDefaultSize);	
	
	//saveDataBtn = new wxButton(this,ID_SAVE,_T("Save"));
	//loadDataBtn = new wxButton(this,ID_LOAD,_T("Load"));
	//refreshBtn = new wxButton(this,ID_REFRESH,_T("Refresh"));
	
	//Connect(saveDataBtn->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &HistogramDialog::OnSaveData	);
	//Connect(loadDataBtn->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &HistogramDialog::OnLoadData	);
	//Connect(refreshBtn->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &HistogramDialog::OnRefreshBtn	);
	
	//-------------------
	//GUI
	//-------------------
	
	//Upper Box
	wxBoxSizer * upper_box = new wxBoxSizer( wxHORIZONTAL );
	//Including components for plotter control
	
	upper_box->Add( histogramW, 4, wxGROW);
	upper_box->Add( getControls(extracontrols),wxSizerFlags().Center() );	

	//bottom Sizer
	wxBoxSizer *bottomBox = new wxBoxSizer( wxHORIZONTAL );
	bottomBox->Add( okBtn, wxSizerFlags().Center());
	bottomBox->AddSpacer(40);
	//bottomBox->Add( saveDataBtn,wxSizerFlags().Center() );
	//bottomBox->AddSpacer(40);
	//bottomBox->Add( loadDataBtn,wxSizerFlags().Center() );
	//bottomBox->AddSpacer(40);
	//bottomBox->Add( refreshBtn,wxSizerFlags().Center() );
	//bottomBox->AddSpacer(40);
	bottomBox->Add( cancelBtn,wxSizerFlags().Center() );
	
	//Sizer
	wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);
	sizer->Add(upper_box,1,wxEXPAND);	
    sizer->Add(bottomBox,0,wxCENTER);
	SetAutoLayout( TRUE );
	SetSizer( sizer );
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	SetBestSize(wxSize(600,600));
#else
	SetSize(wxSize(600,600));
#endif
}
wxPanel* HistogramDialog::getPanExtraControls(){
	wxBoxSizer* sizer0 = new wxBoxSizer(wxVERTICAL);
    _panextracontrols = new wxPanel(this);	

	_panextracontrols->SetSizer(sizer0);
	_panextracontrols->SetAutoLayout(true);

    return _panextracontrols;
}
/**
** Set to true in the constructor
**/
void HistogramDialog::setInfoPanExtraControls(std::vector<HistogramDialogComboBoxItem*> comboitems){
	_comboitems = comboitems;
	if(_panextracontrols!=NULL){
		_panextracontrols->Show(false);
		for(int i=0; i < comboitems.size();i++){

			wxBitmap bitmap = comboitems[i]->GetBitmap();
			
			
			_panextracontrols->GetSizer()->Add(getBitmapButtonDelete(bitmap),wxSizerFlags().Center());			
			_panextracontrols->GetSizer()->AddSpacer(5);
            
		}	
		
		wxButton* button = new wxButton(_panextracontrols,wxID_ANY);			
		button->SetToolTip(wxString("Add the current color to the list of predefined",wxConvUTF8));
		button->SetLabel(wxString(_T("Add")));
		Connect(button->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&HistogramDialog::OnEditColorsCombo);				
		_panextracontrols->GetSizer()->Add(button);					        
		_panextracontrols->Layout();		
		_panextracontrols->Refresh();
		_panextracontrols->Show(true);
		this->Layout();
		this->Refresh();

	}
}
wxSizer* HistogramDialog::getBitmapButtonDelete(wxBitmap bitmap){
	//wxCheckBox* checkbox = new wxCheckBox(_panextracontrols,wxID_ANY,_T(""));
	wxBitmap bitmap0(Delete_xpm);
	wxBitmapButton* deletebutton = new wxBitmapButton(_panextracontrols,wxID_ANY,bitmap0,wxDefaultPosition,wxSize(20,20));
	deletebutton->SetToolTip(wxString("Delete the color from the list",wxConvUTF8));
	Connect(deletebutton->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&HistogramDialog::OnDeleteColor);
	 _deletebuttonsvector.push_back(deletebutton);
	
	//wxBitmap bitmap0(OpenImage_xpm);
	wxBitmapButton* button = new wxBitmapButton(_panextracontrols,wxID_ANY,bitmap,wxDefaultPosition,wxSize(30,30));			
	button->SetToolTip(wxString("Load the current color configuration.",wxConvUTF8));
	bitmapbuttonsvect.push_back(button);			
	Connect(button->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&HistogramDialog::OnEditColorsCombo);
	/*char c[10];
	wxString s;
	s.Printf(_T("%d"),i);*/
	
	//button->SetBitmapLabel(comboitems[i]->GetBitmap());
	// wxStaticBitmap* button = new wxStaticBitmap(_panextracontrols,i,comboitems[i]->GetBitmap(),wxDefaultPosition,wxSize(30,30));			
	wxBoxSizer* sizer = new wxBoxSizer(wxHORIZONTAL);
	sizer->Add(button,wxSizerFlags().Center());
	sizer->AddSpacer(5);
	sizer->Add(deletebutton,wxSizerFlags().Center());
	return sizer;
}
void HistogramDialog::OnDeleteColor(wxCommandEvent& event){
    for(int i = 0; i < _deletebuttonsvector.size();i++){
		if(event.GetId()==_deletebuttonsvector[i]->GetId()){
			_currentcolorselectedbitmap = -1;
			//this->eraseColorPoints();
			//this->erasePointsTransferenceFunction();
			HistogramDialogComboBoxItem* temp;
			temp = _comboitems[i];
			_deletebuttonsvector[i]->Hide();
			bitmapbuttonsvect[i]->Hide();
			delete temp;
			//Remove buttons
			_panextracontrols->GetSizer()->Remove(i*2);
			//Remove Space
			_panextracontrols->GetSizer()->Remove(i*2);
			for(int k = i; k < _comboitems.size()-1;k++){
                _comboitems[k] = _comboitems[k+1];
				_deletebuttonsvector[k] = _deletebuttonsvector[k+1];
				bitmapbuttonsvect[k] = bitmapbuttonsvect[k+1];
			}			
			_comboitems.pop_back();	
			_deletebuttonsvector.pop_back();
			bitmapbuttonsvect.pop_back();
		}
	}
    _panextracontrols->Layout();
}
void HistogramDialog::OnEditColorsCombo(wxCommandEvent& event){
	bool loadconfig = false;
	UpdateCurrentComboElement();
	for(int i = 0; i < bitmapbuttonsvect.size();i++){
		if(event.GetId()==bitmapbuttonsvect[i]->GetId()){
			if(i<_comboitems.size()){
				_currentcolorselectedbitmap = i;
				loadconfig = true;
				HistogramDialogComboBoxItem* currentconfig = _comboitems[i];
				std::vector<double> greyvect = currentconfig->getGreyVector();
				std::vector<double> _redvect = currentconfig->getRedVector();
				std::vector<double> _greenvect = currentconfig->getGreenVector();
				std::vector<double> _bluevect= currentconfig->getBlueVector();
				this->eraseColorPoints();
				this->erasePointsTransferenceFunction();
				for(int i = 0; i < currentconfig->getGreyVector().size();i++){
					double greyv = currentconfig->getGreyVector()[i];
					double red = currentconfig->getRedVector()[i];
					double green = currentconfig->getGreenVector()[i];
					double blue = currentconfig->getBlueVector()[i];

					this->addColorPoint(greyv*_maxgreyvalue, red*255.0, green*255.0, blue*255.0);
				}
				for(int i = 0; i < currentconfig->getGreyVectorTransfer().size();i++){
					double greyv = currentconfig->getGreyVectorTransfer()[i];	
					double value = currentconfig->getValueVector()[i];
					std::cout<<"void HistogramDialog::OnEditColorsCombo(wxCommandEvent& event){"<<greyv<<" "<<value<<std::endl;
					this->addPointToTransferenceFunction(greyv*_maxgreyvalue, value*100);
				}
			}
		}
	}
	if(!loadconfig){		
		AddNewBitmapButton();		
	}
	
	_panextracontrols->Layout();
	this->Layout();
	this->Refresh();
}
void HistogramDialog::UpdateCurrentComboElement(){
	if(_currentcolorselectedbitmap >= 0 && _currentcolorselectedbitmap < _comboitems.size()){
		setCurrentColorConfigurationIntoButton();
	}
}
void HistogramDialog::AddNewBitmapButton(){	
	this->eraseColorPoints();
	this->erasePointsTransferenceFunction();
	HistogramDialogComboBoxItem* boxitem = new HistogramDialogComboBoxItem();	
	wxBitmap bitmap = boxitem->GetBitmap();
	wxSizer* sizer = getBitmapButtonDelete(bitmap);
    _panextracontrols->GetSizer()->Insert(_comboitems.size()*2,sizer,wxSizerFlags().Center());	                
	_panextracontrols->GetSizer()->InsertSpacer(_comboitems.size()*2+1,5);
	_comboitems.push_back(boxitem);		
	_currentcolorselectedbitmap = _comboitems.size()-1;
}
void HistogramDialog::setCurrentColorConfigurationIntoButton(){
		
		std::vector<double> greylevel;
		std::vector<double> red;
		std::vector<double> green;
		std::vector<double> blue;
		std::vector<double> red0;
		std::vector<double> green0;
		std::vector<double> blue0;
		GetValuesColorPointsFunction(greylevel,red,green,blue);

		for(int i = 0;i< greylevel.size();i++){
			greylevel[i] = greylevel[i]/_maxgreyvalue;
			/*std::cout<<"HistogramDialog::setCurrentColorConfigurationIntoButton(){red"<<red[i]<<std::endl;
			std::cout<<"HistogramDialog::setCurrentColorConfigurationIntoButton(){green"<<green[i]<<std::endl;
			std::cout<<"HistogramDialog::setCurrentColorConfigurationIntoButton(){blue"<<blue[i]<<std::endl;*/
			red0.push_back(red[i]);
			green0.push_back(green[i]);
			blue0.push_back(blue[i]);			
			/*std::cout<<"HistogramDialog::setCurrentColorConfigurationIntoButton(){red"<<red0[i]<<std::endl;
			std::cout<<"HistogramDialog::setCurrentColorConfigurationIntoButton(){green"<<green0[i]<<std::endl;
			std::cout<<"HistogramDialog::setCurrentColorConfigurationIntoButton(){blue"<<blue0[i]<<std::endl;*/
		}
		
		std::vector<double> greylevel1;
		std::vector<double> value;		
		this->GetValuesPointsFunction(greylevel1,value);		

		for(int i = 0;i< greylevel1.size();i++){
			greylevel1[i] = greylevel1[i]/_maxgreyvalue;
			value[i] = value[i];
			std::cout<<"void HistogramDialog::setCurrentColorConfigurationIntoButton(){"<<greylevel1[i]<<std::endl;
			std::cout<<"void HistogramDialog::setCurrentColorConfigurationIntoButton(){"<<value[i]<<std::endl;
		}
	if(_currentcolorselectedbitmap >= 0 && _currentcolorselectedbitmap < _comboitems.size()){
		_comboitems[_currentcolorselectedbitmap]->SetColors(greylevel,red0,green0,blue0);
		_comboitems[_currentcolorselectedbitmap]->SetTransferFunction(greylevel1,value);	
		bitmapbuttonsvect[_currentcolorselectedbitmap]->SetBitmapLabel(_comboitems[_currentcolorselectedbitmap]->GetBitmap());
	}
}

wxSizer* HistogramDialog::getControls(bool extracontrols){		
		
	wxSizer* sizer = new wxBoxSizer(wxVERTICAL);
	
	wxBitmap bitmap0(OpenImage_xpm);
	wxBitmapButton* opendata = new wxBitmapButton(this, -1, bitmap0,wxDefaultPosition,wxSize(30,30));	
	Connect(opendata->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&HistogramDialog::OnLoadData);			
	sizer->Add(opendata,wxSizerFlags().Center());	
	sizer->AddSpacer(5);

	

	wxBitmap bitmap1(Save_xpm);
	wxBitmapButton* savedata = new wxBitmapButton(this, -1, bitmap1,wxDefaultPosition,wxSize(30,30));	
	Connect(savedata->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&HistogramDialog::OnSaveData);			
	sizer->Add(savedata,wxSizerFlags().Center());
	sizer->AddSpacer(5);

	if(extracontrols){
		sizer->Add(getPanExtraControls(),wxSizerFlags().Center());
	}
    //sizer->Add(getBitmapCombo(),wxSizerFlags().Center());
	
	
	
	return sizer;


}

//-----------------------
//Handling events
//-----------------------

void HistogramDialog::OnSaveData(wxCommandEvent& event)
{
	//wxFileSelector(_T("Save Data"),wxSAVE);
//EED 2017-09-16 Migration wxWidgets 2.8 to 3.0
#if wxMAJOR_VERSION <= 2
	wxString nameF=wxFileSelector(_T("Save Data"), _T(" "),_T(""),_T(""),_T("*.*"),wxSAVE, NULL, -1,  -1);
#else
	wxString nameF=wxFileSelector(_T("Save Data"), _T(" "),_T(""),_T(""),_T("*.*"),wxFD_SAVE, NULL, -1,  -1);
#endif

	std::ofstream file;
	if(nameF.CompareTo( _T("/0") )>0)
		file.open( (const char*)(nameF.mb_str()) );

	if(file.is_open())
	{
		file << "<histogram Data>" << std::endl;
		//histograms points
		/*
		file << "	<histogramPoints>" << std::endl;
		int histogramS=histogramW->getHistogramSize();
		int i=0;	
		while(i<histogramS)
		{
			file << "		<HistogramPoint>" << std::endl;
			file << "			<greyValue>" << i << "</greyValue>" <<std::endl;
			file << "			<number>" << histogramW->getHistogramPoint(i) << "</number>"<<std::endl;
			file << "		</HistogramPoint>" << std::endl;
			i++;
		}
		file << "	</histogramPoints>" << std::endl;
		*/
		//points transference Function
		file << " <TransferenceFunction>"<< std::endl;
		int tfPointS=histogramW->getSizeTransferenceFunction();
		int i=0;
		int gv,in;
		while(i<tfPointS)
		{
			
			histogramW->getTransferenceFunctionPoint(i,gv,in);
			file << "		<Transferencepoint>" << std::endl;
			file << "			<greyValue>" << gv << "</greyValue>" <<std::endl;
			file << "			<intensity>" << in << "</intensity> "<<std::endl;
			file << "		</Transferencepoint>" << std::endl;
			i++;
		}
		file << "	</TransferenceFunction>"<< std::endl;
		//colorPoints
		file << "	<Colors>"<< std::endl;
		int ctfPointS=histogramW->getSizeBarColor();

		i=0;
		int red,green,blue;
		while(i<ctfPointS)
		{
			
			histogramW->getDataBarColorPoint(i,gv,red,green,blue);
			file << "		<greyValueRGBpoint>" << std::endl;
			file << "			<RGBgreyValue>" << gv << "</RGBgreyValue>" <<std::endl;
			file << "			<red>" << red << "</red>" <<std::endl;
			file << "			<green>" << green << "</green>" <<std::endl;
			file << "			<blue>" << blue << "</blue>" <<std::endl;
			file << "		</greyValueRGBpoint>" << std::endl;
			i++;
		}

		file << "	</Colors>"<< std::endl;
		file << "</histogram Data>" << std::endl;
	}
	file.close();
}

void HistogramDialog::OnLoadData(wxCommandEvent& event)
{
	wxString nameF=wxFileSelector(_T("Load Data") );
	//std::string line;
	std::ifstream file;
	if(nameF.CompareTo( _T("/0") )>0)
		file.open(  (const char*) (nameF.mb_str()) );
	
	bool histogramReading=false,/*histogramPoints=false,histogramPoint=false,*/tf=false,ctf=false,tfp=false,ctfp=false;  // JPRx
	int gv=-1,in=-1,red=-1,gr=-1,bl=-1/*,nPoints=-1*/; // JPRx
	if(file.is_open())
	{
		//-------------
		erasePointsTransferenceFunction();
		eraseColorPoints();
		//--------------
	
		//std::getline(file,line);
		//int i=0;  // JPRx
		while(!file.eof())
		{
			std::string line;
			std::getline(file,line);
			//int a=line.find("histogram Data");
			if( (int)(line.find("histogram Data"))!=-1)
			{
				histogramReading=true;
			
			}
			/*
			else if(line.find("histogramPoints")!=0 && histogramReading)
			{
				histogramPoints=true;
			}
			else if(line.find("histogramPoint")!=0 && histogramReading && histogramPoints)
			{

			}
			else if(line.find("greyValue")!=0 && histogramReading && histogramPoints)
			{
				int pos1=line.find(">");
				int pos2=line.find("<",pos+1);
				std::string x=line.substr(pos1+1,pos2-1);
				gv=atoi(x.c_str());
			}
			else if(line.find("number")!=0 && histogramReading && histogramPoints)
			{
				int pos1=line.find(">");
				int pos2=line.find("<",pos+1);
				std::string x=line.substr(pos1+1,pos2-1);
				nP=atoi(x.c_str());
				//add to the histogram
				//histogramW->addPointToTransferenceFunction(gc,in);
			}
			*/
			else if( (int)(line.find("TransferenceFunction"))!=-1 && histogramReading)
			{
				tf=true;
			}
			else if( (int)(line.find("<Transferencepoint>"))!=-1 && histogramReading && tf)
			{
				tfp=true;
			}
			else if( (int)(line.find("greyValue"))!=-1 && histogramReading && tf && tfp)
			{
				int pos1=line.find(">");
				int pos2=line.find("<",pos1+1);
				std::string x=line.substr(pos1+1,pos2-pos1-1);
				gv=atoi(x.c_str());
				
			}
			else if( (int)(line.find("intensity"))!=-1 && histogramReading && tf && tfp)
			{
				int pos1=line.find(">");
				int pos2=line.find("<",pos1+1);
				std::string x=line.substr(pos1+1,pos2-pos1-1);
				in=atoi(x.c_str());
				histogramW->addPointToTransferenceFunction(gv,in);
				tfp=false;
				
			}
			else if( (int)(line.find("Colors"))!=-1 && histogramReading)
			{
				ctf=true;
			}
			
			else if( (int)(line.find("greyValueRGBpoint"))!=-1 && histogramReading && ctf )
			{
				ctfp=true;
				
			}
			else if( (int)(line.find("RGBgreyValue"))!=-1 && histogramReading && ctf && ctfp)
			{
				int pos1=line.find(">");
				int pos2=line.find("<",pos1+1);
				std::string x=line.substr(pos1+1,pos2-pos1-1);
				gv=atoi(x.c_str());
				
			}
			else if( (int)(line.find("red"))!=-1 && histogramReading && ctf && ctfp)
			{
				int pos1=line.find(">");
				int pos2=line.find("<",pos1+1);
				std::string x=line.substr(pos1+1,pos2-pos1-1);
				red=atoi(x.c_str());
				
			}
			else if( (int)(line.find("green"))!=-1 && histogramReading && ctf && ctfp)
			{
				int pos1=line.find(">");
				int pos2=line.find("<",pos1+1);
				std::string x=line.substr(pos1+1,pos2-pos1-1);
				gr=atoi(x.c_str());
			}
			else if( (int)(line.find("blue"))!=-1 && histogramReading && ctf && ctfp)
			{
				int pos1=line.find(">");
				int pos2=line.find("<",pos1+1);
				std::string x=line.substr(pos1+1,pos2-pos1-1);
				bl=atoi(x.c_str());
				histogramW->addColorPoint(gv,red,gr,bl);
				ctfp=false;
			}
			line.clear();
	     }
     }
	
	file.close();
	histogramW->updatePlotter();
}
/*
 On refresh btn
*/

void HistogramDialog::OnRefreshBtn(wxCommandEvent &event)
{
	refreshed=true;
			
			int i=0,xi,yi,r,g,b;
			
			// -- TransferenceFunction --
			int nPointsTF=getSizeTransferenceFunction();

			if(nPointsTF>0)
			{

				int nTFPoints=getSizeTransferenceFunction();
				i=0;
				while(i<nTFPoints)
				{
					getTransferenceFunctionPoint(i,xi,yi);
					_tfun->AddPoint( xi , yi/100.0 );
					i++;
				}
			}
			//-- Color bar --
			//clean colors
			int nPointsCTF=getSizeBarColor();
			if(nPointsCTF>0)
			{			
				_ctfun->RemoveAllPoints();
				
				int nCTFpoints=getSizeBarColor();
				i=0;	
				while(i<nCTFpoints)
				{
					getDataBarColorPoint(i,xi,r,g,b);
					_ctfun->AddRGBPoint(xi,r/255.0,g/255.0,b/255.0 );
					i++;
				}
			}

//EED Borrame

	/*
	 NOTE I NEED THE UPDATE
	*/
	//if it was call from the clipping ctnrl panel
	//if(wxvtkclipping3Dview!=NULL)
	//{
	//	wxvtkclipping3Dview->Refresh();

	//}
	//else if(wxvtkmpr3Dview!=NULL)
	//{
	//	wxvtkmpr3Dview->Refresh();

	//}
}


//-----------------------
//Methods
//-----------------------

/*
		get number of points of the transference function
	*/
	int HistogramDialog::getSizeTransferenceFunction()
	{
		return histogramW->getSizeTransferenceFunction();
		
	}
	/*
		get number of points of the barColor
	*/
	int HistogramDialog::getSizeBarColor()
	{
		return histogramW->getSizeBarColor();
	}
	/*
		get a point of the transference function
	*/
	void HistogramDialog::getTransferenceFunctionPoint(int index,int& x,int& y)
	{
		histogramW->getTransferenceFunctionPoint(index,x,y);
	}
	/*
		get a  color int the bqr color
	*/
	void HistogramDialog::getDataBarColorPoint(int index,int&x, int& red,int& green,int& blue)
	{
		histogramW->getDataBarColorPoint(index,x,red,green,blue);
	}
	/*
		get a point of the Histogram
		given the grey value
	*/
	int HistogramDialog::getHistogramPoint(int gValue)
	{
		return histogramW->getHistogramPoint(gValue);
	}

	//--------------------
	// bar Information
	//---------------------
	/*
	 Get the porcentage of the positions of 
	 the min,max and actual in the bar range
	*/
	float HistogramDialog::getMaxShowedPorcentage()
	{
		return histogramW->getMaxShowedPorcentage();
	}
	float HistogramDialog::getMinShowedPorcentage()
	{
		return histogramW->getMinShowedPorcentage();
	}
	float HistogramDialog::getActualShowedPorcentage()
	{
		return histogramW->getActualShowedPorcentage();
	}
	//---------------------------------------
	// setting data in transferences function
	// and in bar color
	//----------------------------------------
	bool  HistogramDialog::addPointToTransferenceFunction(double x, double y)
	{
		return histogramW->addPointToTransferenceFunction(x,y);
	}
	bool  HistogramDialog::addColorPoint(double x,int red,int green, int blue)
	{
		return histogramW->addColorPoint(x,red,green,blue);
	}
	//------------------------
	//Erase data
	//------------------------
	
	/*
	 Erase all the points that are in the transference function
	*/
	void HistogramDialog::erasePointsTransferenceFunction()
	{
		histogramW->erasePointsTransferenceFunction();
	}
	/*
	Erase the  color points in the plotter
	*/
	void HistogramDialog::eraseColorPoints()
	{
		histogramW->eraseColorPoints();
	}

	//-------------------
	// Getter and setters
	//-------------------

	void HistogramDialog::setCTF(vtkColorTransferFunction *cf)
	{
		_ctfun=cf;
	
	}
	void HistogramDialog:: setTF(vtkPiecewiseFunction *tf)
	{
		_tfun=tf;
	}

	bool HistogramDialog::getRefreshed()
	{
		return refreshed;
	}
	
#if (VTK_MAJOR_VERSION <= 7) 
	void HistogramDialog::setVolumeMapper(vtkVolumeRayCastMapper* volMapper)
#else 
	void HistogramDialog::setVolumeMapper(vtkFixedPointVolumeRayCastMapper* volMapper)
#endif
	{
		volumeMapper=volMapper;
	}
	void HistogramDialog::setVolume(vtkVolume* vol)
	{
		newvol=vol;	
	}
	//void HistogramDialog::setMPR3Dview(wxVtkMPR3DView *wxvtkmpr3Dview1)
	//{
	//	wxvtkmpr3Dview=wxvtkmpr3Dview1;
	//}
	//void HistogramDialog::setClipping3DView(wxVtkClipping3DView *wxvtkclipping3Dview1)
	//{
	//	wxvtkclipping3Dview=wxvtkclipping3Dview1;
	//}


	void  HistogramDialog::setTransferenceFunctionHasPoints(bool hasPoints)
	{
		histogramW->setTransferenceFunctionHasPoints(hasPoints);
	}
	void  HistogramDialog::setTransferenceFunctionHasColor(bool hasColorPoints)
	{
		histogramW->setTransferenceFunctionHasColor(hasColorPoints);
	}

	//--------------------
	// plotter Information
	//---------------------
	void  HistogramDialog::updatePlotter()
	{
		histogramW->updatePlotter();
	}


/**
**	Initialize the histogram 
*/
	void HistogramDialog::initializeHistogram(vtkImageData* img){	
		_maxgreyvalue = img->GetScalarRange()[1];
		histogramW->initializeHistogram(img);
	}
/**
**	Returns two vectors, the grey level of the point and its value, the value is between [0,1]
**/
	void HistogramDialog::GetValuesPointsFunction(std::vector<double>& greylevel,std::vector<double>& value){

		histogramW->GetValuesPointsFunction(greylevel, value);
	}

/**
**	Returns two vectors, the grey level of the point and its value, the red, green
**	and blue value is between [0,1]
**/
void HistogramDialog::GetValuesColorPointsFunction(std::vector<double>& greylevel,
								std::vector<double>& red,
								std::vector<double>& green,
								std::vector<double>& blue)
{
	histogramW->GetValuesColorPointsFunction(greylevel, red, green, blue);
}

void HistogramDialog::SetFunctions(vtkPiecewiseFunction* _opac, vtkColorTransferFunction* _color){
	_tfun = _opac;
	_ctfun = _color;	
}
