/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


#ifndef __HISTOGRAMSDIALOG__
#define __HISTOGRAMSDIALOG__


// ----------------------------------------------------------------------------
// wx headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------
#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

 //---------------------
 // Includes
 //----------------------
 #include "HistogramWidget.h"
 #include <vtkVersionMacros.h>
 #include "vtkImageData.h"
 //#include <vector>
 #include <vtkPiecewiseFunction.h>
 #include <vtkColorTransferFunction.h>
#if (VTK_MAJOR_VERSION <= 7) 
	#include <vtkVolumeRayCastMapper.h>
#else 
	#include <vtkFixedPointVolumeRayCastMapper.h>
#endif
 #include <vtkVolume.h>
 //#include "../wxMPRWidget.h"

#include "HistogramDialogComboBoxItem.h"
#include <wx/checkbox.h>
#include <wx/statbmp.h>

class HistogramDialog:public wxDialog
{
public:
	/*
	 Constructor
	*/
	HistogramDialog(wxWindow *parent,wxString title,vtkImageData* imageData,bool extracontrols=false);
	/*
	 Constructor
	*/
	HistogramDialog(wxWindow *parent,wxString title,bool extracontrols=false);
	~HistogramDialog();
	/*
	 Methods
	*/
	/*
		get number of points of the transference function
	*/
	int getSizeTransferenceFunction();
	/*
		get number of points of the barColor
	*/
	int getSizeBarColor();
	/*
		get a point of the transference function
	*/
	void getTransferenceFunctionPoint(int index,int& x,int& y);
	/*
		get a  color int the bqr color
	*/
	void getDataBarColorPoint(int index,int&x, int& red,int& green,int& blue);
	/*
		get a point of the Histogram
		given the grey value
	*/
	int getHistogramPoint(int gValue);

	//--------------------
	// bar Information
	//---------------------
	/*
	 Get the porcentage of the positions of 
	 the min,max and actual in the bar range
	*/
	float getMaxShowedPorcentage();
	float getMinShowedPorcentage();	
	float getActualShowedPorcentage();

	//---------------------------------------
	// setting data in transferences function
	// and in bar color
	//----------------------------------------
	/*
	  Adds a point to the transference function
	*/
	bool addPointToTransferenceFunction(double x, double y);
	/*
		add a color point to the histogram
		@param x the level of grey to which the color is assigned
		@param red the level of red for the color
		@param green the level of red for the color
		@param blue the level of red for the color
	*/
	bool addColorPoint(double x,int red,int green, int blue);
	//------------------------
	//Erase data
	//------------------------
	
	/*
	 Erase all the points that are in the transference function
	*/
	void erasePointsTransferenceFunction();
	void eraseColorPoints();
	//-------------------
	// Getter and setters
	//-------------------

	void setTransferenceFunctionHasPoints(bool hasPoints);
	void setTransferenceFunctionHasColor(bool hasColorPoints);
	
	//returns if the user has pressed refresh	
	
	bool getRefreshed();
	void setCTF(vtkColorTransferFunction* cf);
	void setTF(vtkPiecewiseFunction* tf);
#if (VTK_MAJOR_VERSION <= 7) 
	void setVolumeMapper(vtkVolumeRayCastMapper* volMapper);
#else 
	void setVolumeMapper(vtkFixedPointVolumeRayCastMapper* volMapper);
#endif
	void setVolume(vtkVolume* vol);
	//void setMPR3Dview(wxVtkMPR3DView *wxvtkmpr3Dview1);
	//void setClipping3DView(wxVtkClipping3DView *wxvtkclipping3Dview1);

	//--------------------
	// plotter Information
	//---------------------
	void updatePlotter();
	
	//-----------------------
	//Handling events
	//-----------------------

	void OnSaveData(wxCommandEvent& event);
	void OnLoadData(wxCommandEvent& event);
	void OnRefreshBtn(wxCommandEvent& event);
	

	/**
	**	Initialize the histogram 
	*/
	void initializeHistogram(vtkImageData* img);
	/**
	**	Returns two vectors, the grey level of the point and its value, the value is between [0,1]
	**/
	void GetValuesPointsFunction(std::vector<double>& greylevel,std::vector<double>& value);

	/**
	**	Returns two vectors, the grey level of the point and its value, the red, green
	**	and blue value is between [0,1]
	**/
	void GetValuesColorPointsFunction(std::vector<double>& greylevel,
									std::vector<double>& red,
									std::vector<double>& green,
									std::vector<double>& blue);
	void SetFunctions(vtkPiecewiseFunction* _opac, vtkColorTransferFunction* _color);

	/**
	** Set to true in the constructor
	**/
	void setInfoPanExtraControls(std::vector<HistogramDialogComboBoxItem*> comboitems);
	

	/**
	*
	*/
	void OnEditColorsCombo(wxCommandEvent& event);
	void OnDeleteColor(wxCommandEvent& event);

	std::vector<HistogramDialogComboBoxItem*> getComboBoxItems(){return _comboitems;}

	void UpdateCurrentComboElement();
	
private:
	/*
	Histogram Widget
	*/
	HistogramWidget*  histogramW;
/**
**	
**/
	/*
	 ok Button
	*/
	//wxButton			*okBtn;
	wxBitmapButton		*okBtn;
	/*
	 cancel Button
	*/
	//wxButton							*cancelBtn;
	wxBitmapButton						*cancelBtn;
	/*
	 save Button
	*/
	wxButton							*saveDataBtn;	
	/*
	Load Button
	*/
	wxButton							*loadDataBtn;
	/*
	Refresh Button
	*/
	wxButton							*refreshBtn;
	wxPanel								*_panextracontrols;
	
	// the user had pressed refresh
	bool refreshed;
	
	vtkColorTransferFunction			*_ctfun;
	vtkPiecewiseFunction				*_tfun;
#if (VTK_MAJOR_VERSION <= 7) 
	vtkVolumeRayCastMapper				*volumeMapper; 
#else 
	vtkFixedPointVolumeRayCastMapper	*volumeMapper; 
#endif
	vtkVolume							*newvol;

	//things to refresh
	//wxVtkMPR3DView					*wxvtkmpr3Dview;
	//wxVtkClipping3DView				*wxvtkclipping3Dview;

	
	wxSizer* getControls(bool extracontrols = false);

	
	
//	DECLARE_CLASS(HistogramDialog);
	// any class wishing to process wxWindows events must use this macro
	//DECLARE_EVENT_TABLE()

	void initializeHistogramDialog(bool extracontrols);

	 wxPanel* getPanExtraControls();

	 std::vector<wxBitmapButton*> bitmapbuttonsvect;
	 std::vector<HistogramDialogComboBoxItem*> _comboitems;

	 void setCurrentColorConfigurationIntoButton();
	 void AddNewBitmapButton();
	 wxSizer* getBitmapButtonDelete(wxBitmap bitmap);
	 std::vector<wxBitmapButton*> _deletebuttonsvector;

	 int _maxgreyvalue;
	 int _currentcolorselectedbitmap;
};

#endif



