/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "HistogramDialogComboBox.h"
#include <vector>

#include "Edit.xpm"

#include "creaSystem.h"
#include "HistogramDialog.h"
//-------------------------
//Constructor
//-------------------------
HistogramDialogComboBox::HistogramDialogComboBox(wxWindow* parent)
: wxPanel(parent)
{
	_img				= NULL;
	_bitmapcombo		= NULL;
	_slidercolor		= NULL;
	_sliderwindowlevel	= NULL;
	_ckboxActive		= NULL;
	colorBar_Bitmap		= NULL;
	_bitmapsizer		= NULL;
	InitCurrentPathColorsFuntion();
	this->SetSizer(getBitmapCombo());
	_img				= NULL;
	_currentitem		= -1;    
	_maxgreyvalue		= 0;
}


HistogramDialogComboBox::~HistogramDialogComboBox()
{
}

void HistogramDialogComboBox::SetColors(std::vector<double> greyvect, std::vector<double> redvect, std::vector<double> greenvect, std::vector<double> bluevect)
{
	_greyvect	= greyvect;
	_redvect	= redvect;
	_greenvect	= greenvect;
	_bluevect	= bluevect;
}

wxSizer* HistogramDialogComboBox::getBitmapCombo()
{
	//_bitmapsizer = new wxBoxSizer(wxVERTICAL);
	_bitmapsizer = new wxBoxSizer(wxVERTICAL);

	wxBoxSizer* comboeditsizer = new wxBoxSizer(wxHORIZONTAL);
	_bitmapcombo = getBitmapComboElements();
    BitmapComboItemSelect(0);
	wxBitmap bitmap1(Edit_xpm);
	wxBitmapButton* edit = new wxBitmapButton(this, -1, bitmap1,wxDefaultPosition,wxSize(30,30));
	Connect(edit->GetId(), wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&HistogramDialogComboBox::OnEditBitmapCombo);
	_ckboxActive= new wxCheckBox( this, 
			      -1, 
			      _T(" "),
			      wxDefaultPosition, 
			      //wxSize(sizeX,sizeY),
			      wxDefaultSize, 
			      wxCHK_2STATE | wxALIGN_RIGHT);      
	_ckboxActive->SetValue(false);

    Connect( _ckboxActive->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) (void (wxPanel::*)(wxScrollEvent&))  &HistogramDialogComboBox::OnChkBoxActive);

	comboeditsizer->Add(_ckboxActive,wxSizerFlags().Center().FixedMinSize());
	comboeditsizer->Add(_bitmapcombo,wxSizerFlags().Center().FixedMinSize());
	comboeditsizer->Add(edit,wxSizerFlags().Center());
	_bitmapsizer->Add(comboeditsizer,wxSizerFlags().FixedMinSize().Center());
	_bitmapsizer->AddSpacer(5);
	_bitmapsizer->Add(getSlidersWlCo(),wxSizerFlags().Expand().Center());
	return _bitmapsizer;
}

wxSizer* HistogramDialogComboBox::getSlidersWlCo()
{
	wxBoxSizer* sizersliders 	= new wxBoxSizer(wxVERTICAL);
	_slidercolor 				= new wxSlider(this, -1,1,0,1,wxDefaultPosition,wxDefaultSize,wxSL_LABELS);
	_sliderwindowlevel 			= new wxSlider(this, -1,1,0,1,wxDefaultPosition,wxDefaultSize,wxSL_LABELS);
	sizersliders->Add(_slidercolor,wxSizerFlags().Expand().Center());
	sizersliders->Add(_sliderwindowlevel,wxSizerFlags().Expand().Center());
    Connect(_slidercolor->GetId(), wxEVT_SCROLL_THUMBTRACK, (wxObjectEventFunction)&HistogramDialogComboBox::OnColorLevelChanged);
	Connect(_sliderwindowlevel->GetId(), wxEVT_SCROLL_THUMBTRACK, (wxObjectEventFunction)&HistogramDialogComboBox::OnWindowLevelChanged);
	return sizersliders;
}

double HistogramDialogComboBox::GetWindowLevel()
{
   double val(0.0);
   if(_sliderwindowlevel != NULL)
	{
      val= _sliderwindowlevel->GetValue();
	}
   return val; // JPR
}

double HistogramDialogComboBox::GetColorLevel()
{
   double val(0.0);
   if(_slidercolor != NULL)
	{
      val = _slidercolor->GetValue();
	}
   return val; // JPR
}


bool HistogramDialogComboBox::GetActive()
{
	bool result = false;
	if (_ckboxActive!=NULL) 
	{
		result = _ckboxActive->GetValue();
	}
	return result;
}


void HistogramDialogComboBox::OnChkBoxActive(wxCommandEvent& event)
{
   wxCommandEvent newevent(wxEVT_COMMAND_COMBOBOX_SELECTED,this->GetId());
   ProcessEvent(newevent);
}


void HistogramDialogComboBox::OnColorLevelChanged(wxCommandEvent& event)
{
   _slidercolor->GetValue();
   wxCommandEvent newevent(wxEVT_SCROLL_THUMBTRACK,this->GetId());
   ProcessEvent(newevent);
}

void HistogramDialogComboBox::OnWindowLevelChanged(wxCommandEvent& event)
{
   _sliderwindowlevel->GetValue();
   wxCommandEvent newevent(wxEVT_SCROLL_THUMBTRACK,this->GetId());
   ProcessEvent(newevent);
}

void HistogramDialogComboBox::setImageData(vtkImageData* img)
{
   _maxgreyvalue = img->GetScalarRange()[1];
   _img = img;
   setSlidersValue();
}

void HistogramDialogComboBox::setSlidersValue()
{
	if(_img!=NULL){
		if(_slidercolor!=NULL){
			_slidercolor->SetRange(_img->GetScalarRange()[0],_img->GetScalarRange()[1]);
			_slidercolor->SetValue((_img->GetScalarRange()[0]+_img->GetScalarRange()[1])/2);
		}
		if(_sliderwindowlevel!=NULL){
			_sliderwindowlevel->SetRange(_img->GetScalarRange()[0],_img->GetScalarRange()[1]);
			_sliderwindowlevel->SetValue((_img->GetScalarRange()[0]+_img->GetScalarRange()[1])/2);
		}
	}
}

void HistogramDialogComboBox::OnEditBitmapCombo(wxCommandEvent& event)
{
	if(_img!=NULL)
	{
		bool createaddandremovecontrols = true;
		HistogramDialog* dialog = new HistogramDialog(this,_T("Color Configuration"),createaddandremovecontrols);
        	dialog->initializeHistogram(_img);
		dialog->setInfoPanExtraControls(_bitmapsitems);

		if(dialog->ShowModal()==wxID_OK)
		{
			dialog->UpdateCurrentComboElement();
			_bitmapsitems = dialog->getComboBoxItems();

			std::vector<double> redvect,greenvect,bluevect;
			std::vector<double> greyvect;

			saveCurrentConfiguration(_bitmapsitems, GetFileNameOfColorsFunction() );
			wxBitmapComboBox* tempbitmapcombo = _bitmapcombo;
			for(int i = 0; i < _bitmapsitems.size();i++)
			{
				delete _bitmapsitems[i];
			}
			_bitmapsitems.clear();
			_bitmapcombo = getBitmapComboElements();
			
// EED Eraseme			
//			if(_bitmapsizer->Replace(tempbitmapcombo,_bitmapcombo))
//			{
//				tempbitmapcombo->Destroy();
//			} else {
//				printf ("EED ERROR HistogramDialogComboBox::OnEditBitmapCombo. Can't replace bitmapcombo \n");
//			}
			
			this->Layout();
		}
		dialog->Destroy();
	}
}


void HistogramDialogComboBox::saveCurrentConfiguration(std::vector<HistogramDialogComboBoxItem*>& itembitmaps,std::string filename)
{
	std::ofstream file;
	file.open(  (const char*) (filename.c_str()) );
	double gv=-1,red=-1,gr=-1,bl=-1;
	int in=-1;

	if(file.is_open())
	{
		file << "<ComboBoxData>" << std::endl;
		for(int i = 0; i < itembitmaps.size();i++)
		{
			HistogramDialogComboBoxItem* item = itembitmaps[i];
			std::vector<double> vecttransfer = item->getGreyVectorTransfer();
			std::vector<double> value = item->getValueVector();

			file << " <ComboBoxItem>"<< std::endl;
			for(int j = 0; j < vecttransfer.size();j++)
			{
				if(j==0){
					file << " <TransferenceFunction>"<< std::endl;
				}
				file << "		<Transferencepoint>" << std::endl;
				file << "			<greyValue>" << vecttransfer[j] << "</greyValue>" <<std::endl;
				file << "			<intensity>" << value[j] << "</intensity> "<<std::endl;
				file << "		</Transferencepoint>" << std::endl;
				if(j==vecttransfer.size()-1){
                    file << " </TransferenceFunction>"<< std::endl;
				}
			}
			std::vector<double> greyv = item->getGreyVector();
			std::vector<double> red = item->getRedVector();
			std::vector<double> green = item->getGreenVector();
			std::vector<double> blue = item->getBlueVector();
			for(int j = 0; j < greyv.size();j++)
			{
				if(j==0){
					file << "	<Colors>" << std::endl;
				}
				file << "		<greyValueRGBpoint>" << std::endl;
				file << "			<RGBgreyValue>" << greyv[j] << "</RGBgreyValue>" <<std::endl;
				file << "			<red>" << red[j] << "</red>" <<std::endl;
				file << "			<green>" << green[j] << "</green>" <<std::endl;
				file << "			<blue>" << blue[j] << "</blue>" <<std::endl;
				file << "		</greyValueRGBpoint>" << std::endl;
				if(j==greyv.size()-1){
					file << "	</Colors>" << std::endl;
				}
			}
			file << "	</ComboBoxItem>"<< std::endl;
		}
		file << "</ComboBoxData>" << std::endl;
	}
	file.close();
}

void HistogramDialogComboBox::InitCurrentPathColorsFuntion()
{
      _currentpathColorsFuntion = "";
#ifdef WIN32
	_currentpathColorsFuntion = crea::System::GetDllAppPath("bbcreaMaracasVisu");
	_currentpathColorsFuntion.append("/data/");
#endif
#ifdef LINUX
	_currentpathColorsFuntion = crea::System::GetExecutablePath();
	_currentpathColorsFuntion.append("/../share/creaMaracasVisu/data/");
#endif
	crea::System::createDirectory(_currentpathColorsFuntion.c_str());
}



std::string HistogramDialogComboBox::GetFileNameOfColorsFunction()
{
   std::string filename;
   filename = _currentpathColorsFuntion;                                                       
   filename.append(COLORSFUNCTIONFILENAME);                                                                                                                       
   return filename;
}


wxBitmapComboBox* HistogramDialogComboBox::getBitmapComboElements()
{
	std::vector<HistogramDialogComboBoxItem*> bitmapsitems;
	OnLoadComboBoxData(bitmapsitems, GetFileNameOfColorsFunction() );
	_bitmapsitems = bitmapsitems;
	wxString* choices;
	choices = new wxString[bitmapsitems.size()];
	for(int i = 0; i < bitmapsitems.size();i++)
	{
		choices[i] = _T("Color Function");
	}
	
	wxBitmapComboBox* bitmapcombo;
//EED	wxBitmapComboBox* bitmapcombo = new wxBitmapComboBox(this, -1, _T(""), wxDefaultPosition, wxDefaultSize, bitmapsitems.size(),choices);
	if (_bitmapcombo!=NULL)
	{
		_bitmapcombo->Clear();
		bitmapcombo=_bitmapcombo;
	} else {
		bitmapcombo = new wxBitmapComboBox(this, -1, _T(""));
	}
//	wxBitmapComboBox* bitmapcombo = new wxBitmapComboBox(this, -1, _T(""));
	bitmapcombo->SetSize(165,30);

	Connect(bitmapcombo->GetId(), wxEVT_COMMAND_COMBOBOX_SELECTED, (wxObjectEventFunction)&HistogramDialogComboBox::OnBitmapComboItemSelected);

	for(int i = 0; i < bitmapsitems.size(); i++)
	{
		bitmapcombo->Append(_T("ColorFunction"), bitmapsitems[i]->GetBitmap() );
//        bitmapcombo->SetItemBitmap(i, bitmapsitems[i]->GetBitmap());
	}
	BitmapComboItemSelect(0);
	return 	bitmapcombo;
}


void HistogramDialogComboBox::BitmapComboItemSelect(int value)
{
	HistogramDialogComboBoxItem* currentconfig;
	if(_bitmapcombo!=NULL)
	{
		_currentitem = value;
		_bitmapcombo->Select(value);
		if(_bitmapsitems.size()>_currentitem)
		{
			currentconfig		= _bitmapsitems[_currentitem];
			_greyvect			= currentconfig->getGreyVector();
			_redvect			= currentconfig->getRedVector();
			_greenvect			= currentconfig->getGreenVector();
			_bluevect			= currentconfig->getBlueVector();
			_greyvecttransfer	= currentconfig->getGreyVectorTransfer();
			_value				= currentconfig->getValueVector();
			wxCommandEvent newevent(wxEVT_COMMAND_COMBOBOX_SELECTED,this->GetId());
            ProcessEvent(newevent);
		} // if size
	} // _bitmapcombo
}


void HistogramDialogComboBox::OnBitmapComboItemSelected(wxCommandEvent& event)
{
	BitmapComboItemSelect(  event.GetInt() );
}

void HistogramDialogComboBox::OnLoadComboBoxData(std::vector<HistogramDialogComboBoxItem*>& itembitmaps, std::string filename)
{
	std::vector<double> redvect, greenvect, bluevect;
	std::vector<double> greyvect, greyvecttransfunct, value;

	redvect.clear();
	greenvect.clear();
	bluevect.clear();
	greyvect.clear();
	greyvecttransfunct.clear();
	value.clear();

	std::ifstream file;
	file.open(  (const char*) (filename.c_str()) );
	double gv=-1,gvtransfer=-1,intensity=-1,red=-1,gr=-1,bl=-1;
	int in=-1;

	//std::cout<<filename<<std::endl;
	itembitmaps.clear();

	if(file.is_open())
	{
		bool add = false;
		HistogramDialogComboBoxItem* item=NULL;
		while(!file.eof())
		{
			std::string line;
			std::getline(file,line);
			//std::cout<<line<<std::endl;
            if( (int)(line.find("<ComboBoxItem>")!=-1))
		{
			item = new HistogramDialogComboBoxItem();
		}else if((int)(line.find("<greyValue>"))!=-1) {
            int pos1=line.find(">");
			int pos2=line.find("<",pos1+1);
			std::string x=line.substr(pos1+1,pos2-pos1-1);
			gvtransfer=atof(x.c_str());
			greyvecttransfunct.push_back(gvtransfer);
		}else if((int)(line.find("<intensity>"))!=-1) {
            int pos1=line.find(">");
			int pos2=line.find("<",pos1+1);
			std::string x=line.substr(pos1+1,pos2-pos1-1);
			intensity=atof(x.c_str());
			value.push_back(intensity);
		}
		else if( (int)(line.find("<RGBgreyValue>"))!=-1)
		{
			int pos1=line.find(">");
			int pos2=line.find("<",pos1+1);
			std::string x=line.substr(pos1+1,pos2-pos1-1);
			gv=atof(x.c_str());
			greyvect.push_back(gv);
		}
		else if( (int)(line.find("<red>"))!=-1)
		{
			int pos1=line.find(">");
			int pos2=line.find("<",pos1+1);
			std::string x=line.substr(pos1+1,pos2-pos1-1);
			red=atof(x.c_str());
			redvect.push_back(red);
		}
		else if( (int)(line.find("<green>"))!=-1)
		{
			int pos1=line.find(">");
			int pos2=line.find("<",pos1+1);
			std::string x=line.substr(pos1+1,pos2-pos1-1);
			gr=atof(x.c_str());
			greenvect.push_back(gr);
		}
		else if( (int)(line.find("<blue>"))!=-1 )
		{
			int pos1=line.find(">");
			int pos2=line.find("<",pos1+1);
			std::string x=line.substr(pos1+1,pos2-pos1-1);
			bl=atof(x.c_str());
			bluevect.push_back(bl);

		}else if( (int)(line.find("</ComboBoxItem>"))!=-1 ) {

			item->SetColors(greyvect,redvect,greenvect,bluevect);
			item->SetTransferFunction(greyvecttransfunct,value);
			/*for(int i = 0; i < greyvecttransfunct.size();i++){
					std::cout<<"HistogramDialogComboBox::OnLoadComboBoxData("<<greyvecttransfunct[i]<<std::endl;
					std::cout<<value[i]<<std::endl;
			}
			for(int i = 0; i < greyvect.size();i++){
					std::cout<<"HistogramDialogComboBox::OnLoadComboBoxData("<<greyvect[i]<<std::endl;
					std::cout<<redvect[i]<<std::endl;
					std::cout<<greenvect[i]<<std::endl;
					std::cout<<bluevect[i]<<std::endl;
			}*/

			itembitmaps.push_back(item);

			greyvecttransfunct.clear();
			value.clear();
			greyvect.clear();
			redvect.clear();
			greenvect.clear();
			bluevect.clear();
		}
		line.clear();
	}
	file.close();
	//std::cout<<itembitmaps.size()<<std::endl;
     }
}

/**
**	Returns two vectors, the grey level of the point and its value, the value is between [0,1]
**/
void HistogramDialogComboBox::GetValuesPointsFunction(std::vector<double>& greylevel,std::vector<double>& value)
{
	for(int i = 0; i < _greyvecttransfer.size();i++) 
	{
		greylevel.push_back(_greyvecttransfer[i]*_maxgreyvalue);
		value.push_back(_value[i]);
	} // for i
}

/**
**	Returns two vectors, the grey level of the point and its value, the red, green
**	and blue value is between [0,1]
**/
void HistogramDialogComboBox::GetValuesColorPointsFunction(std::vector<double>& greylevel,
								std::vector<double>& red,
								std::vector<double>& green,
								std::vector<double>& blue)
{
	for(int i = 0; i < _greyvect.size();i++) 
	{
		greylevel.push_back(_greyvect[i]*_maxgreyvalue);
		red.push_back(_redvect[i]);
		green.push_back(_greenvect[i]);
		blue.push_back(_bluevect[i]);
	} // for i
}

