/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "HistogramDialogComboBoxItem.h"
#include <vector>

//-------------------------
//Constructor
//-------------------------
HistogramDialogComboBoxItem::HistogramDialogComboBoxItem()
{

	_bar_width = 30;
	_bar_height = 20;
	

	colorBar_Bitmap = new wxBitmap(_bar_width,	_bar_height);

}
HistogramDialogComboBoxItem::HistogramDialogComboBoxItem( int bar_width,int bar_height)
{

	_bar_width = bar_width;
	_bar_height = bar_height;

	//_maxgreyvalue = maxgreyvalue;

	colorBar_Bitmap = new wxBitmap(_bar_width,	_bar_height);

}
HistogramDialogComboBoxItem::~HistogramDialogComboBoxItem(){
	
	
}
void HistogramDialogComboBoxItem::SetColors(std::vector<double> greyvect, std::vector<double> redvect, std::vector<double> greenvect, std::vector<double> bluevect){

	_greyvect=greyvect;
	_redvect=redvect;
	_greenvect=greenvect;
	_bluevect=bluevect;

	wxMemoryDC temp_dc;
	temp_dc.SelectObject( *colorBar_Bitmap );		
	temp_dc.SetBrush(wxBrush( colourParent ,wxSOLID  ));
	temp_dc.SetPen(wxPen( colourParent,1,wxSOLID  ));
	
	temp_dc.DrawRectangle(0, 0, _bar_width,	_bar_height);
	temp_dc.SetPen(wxPen( wxColour(167,165,191),1,wxSOLID  ));
	temp_dc.DrawRectangle(0, 0, _bar_width, _bar_height);	

	double initial_r, initial_g, initial_b;	
	double next_r, next_g, next_b;
	double initialgreyv=0, nextgreyv=0;
	
	for (int i =0; i < _redvect.size(); i++){
		initialgreyv = nextgreyv;
		initial_r = _redvect[i]*255.0;		
		initial_g = _greenvect[i]*255.0;		
		initial_b = _bluevect[i]*255.0;		

		if(i < _redvect.size()-1){
			nextgreyv = _greyvect[i+1];
			next_r = _redvect[i+1]*255.0;
			next_g = _greenvect[i+1]*255.0;
			next_b = _bluevect[i+1]*255.0;            
		}else{
			nextgreyv = 1;	
			next_r = initial_r;
			next_g = initial_g;
			next_b = initial_b;
		}

		int ini_pixelX=_bar_width*initialgreyv;
		int end_pixelX=_bar_width*nextgreyv;		

		double m_scope_r = (double)(next_r-initial_r)/(end_pixelX-ini_pixelX);
		double m_scope_g = (double)(next_g-initial_g)/(end_pixelX-ini_pixelX);
		double m_scope_b = (double)(next_b-initial_b)/(end_pixelX-ini_pixelX);

		next_r = initial_r;
		next_g = initial_g;
		next_b = initial_b;

		for (int Xi =ini_pixelX; Xi<= end_pixelX; Xi++) 					
		{
			temp_dc.SetBrush(wxBrush( wxColour(next_r, next_g, next_b),wxSOLID  ));
			temp_dc.SetPen(wxPen( wxColour(next_r, next_g, next_b),1,wxSOLID  ));
		
			temp_dc.DrawLine(Xi, 0, Xi, _bar_height);		

			next_r = (int)(m_scope_r + next_r);
			next_g = (int)(m_scope_g + next_g);
			next_b = (int)(m_scope_b + next_b);							
		}
	}
}

wxBitmap HistogramDialogComboBoxItem::GetBitmap(){
	
	return *colorBar_Bitmap;
}
void HistogramDialogComboBoxItem::SetTransferFunction(std::vector<double> greyvect, std::vector<double> value){
    _greyvecttransfunct = greyvect;
	_value=value;
}
