/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*
 This class plots image's histograms in a plotter
*/

 //---------------------
 // Includes
 //----------------------
 #include "HistogramWidget.h"
 #include  "vtkImageCast.h"
 #include  <math.h>

// ----------------------------------------------------------------------------
// WX headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------

	#ifndef WX_PRECOMP
	#include <wx/wx.h>

	#endif
#include <wx/bitmap.h>
//----------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------

IMPLEMENT_CLASS(HistogramWidget, wxWindow)

//----------------------------------------------------------------------------
// Event Table
//----------------------------------------------------------------------------

BEGIN_EVENT_TABLE(HistogramWidget, wxWindow)
	EVT_SIZE  (HistogramWidget::OnSize)
END_EVENT_TABLE()
 //---------------------
 // Constructor
 //----------------------
//wxScrolledWindow(wxWindow* parent, wxWindowID id = -1, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = wxHSCROLL | wxVSCROLL, const wxString& name = "scrolledWindow")
//wxWindow(wxWindow* parent, wxWindowID id, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = 0, const wxString& name = wxPanelNameStr)
//pPlotterWindow( wxWindow *parent, wxWindowID id, const wxPoint &pos, const wxSize &size, int flag )
/*
HistogramWidget::HistogramWidget( wxWindow *parent, wxWindowID id, const wxPoint &pos, const wxSize &size, int flag):wxWindow(parent,id,pos,size,flag)
	{
	}
 */
	HistogramWidget::HistogramWidget( wxWindow *parent, wxWindowID id, const wxPoint &pos, const wxSize &size, int flag,vtkImageData* imageData,int type):
	wxPanel(parent,id,wxDefaultPosition,wxDefaultSize)
	{
		 SetBackgroundColour(wxColour(255,255,255));
		//histogram
		histogram= new pHistogram(imageData);

		
		//plotter
		plotter=new pPlotter(this, 400,350);
		
		//is a plotter of histograms
		plotter->setType(2);
		//setting the popMenu
		plotter->setPopUpMenu(true,true,true,true,true,true,false,false,false,false,false,false,false);
		histogramSize						= 0;
		idTransferenceFunction			= -1;
		idHistogram							= -1;
		transferenceFunctionHasColor	= true;
		transferenceFunctionHasPoints	= true;
		this->type=type;
		
		this->SetAutoLayout(true);
		this->Refresh();
        
		//drawing
		drawHistogram();
		drawTransferenceFunction();
	}

	HistogramWidget::HistogramWidget( wxWindow *parent, wxWindowID id)
		: wxPanel(parent,id){

			SetBackgroundColour(wxColour(255,255,255));
			histogram = NULL;	
			
			//plotter
			plotter=new pPlotter(this, 400,350);
			
			//is a plotter of histograms
			plotter->setType(2);
			//setting the popMenu
			plotter->setPopUpMenu(true,true,true,true,true,true,false,false,false,false,false,false,false);
			histogramSize						= 0;
			idTransferenceFunction			= -1;
			idHistogram							= -1;
			transferenceFunctionHasColor	= true;
			transferenceFunctionHasPoints	= true;
			this->type							= type;;
			this->SetAutoLayout(true);
			this->Refresh();
	}

	
	
	void HistogramWidget::initializeHistogram(vtkImageData* img){
		if(histogram ==NULL)
		{
			histogram= new pHistogram(img);
		}		
		//draw
		drawHistogram();
		drawTransferenceFunction();
	}

	HistogramWidget::~HistogramWidget()
	{
		delete histogram;
		delete plotter;

	}
	/*
	Draw the histogram in the plotter
	*/
	void HistogramWidget::drawHistogram()
	{
		//int xValues[MAX],yValues[MAX],extent[6];
		double* xValues;
		double* yValues;
		
		vtkImageData* histogramImageData=histogram->getHistogram();
		
		//size
		histogramSize=histogram->getSize();

		//plotting
		xValues=(double*)malloc(NUM_POINTS*sizeof(double));
		yValues=(double*)malloc(NUM_POINTS*sizeof(double));
		
		double* histogramPointer=(double*)histogramImageData->GetScalarPointer(0,0,0);
		int i;
		for(i=0; i< histogramSize; i++)
		{
			xValues[i]=i;
			if (histogramPointer[i]==0)
			{
				yValues[i]=0;
			} else {
				yValues[i]=log(histogramPointer[i])*10;
			} // histogramPointer 
		} // for i

		
		pGraphicalFunction* histogramFunction=plotter->getFunctionForVectors(xValues,histogramSize,yValues,histogramSize);
		
		if (histogramFunction)
		{
			histogramFunction->setEditable(false);
			//smooth function
			histogramFunction->setType(2);
			//it is an histogram
			histogramFunction->setmType(2);
			idHistogram=plotter->addFunction(histogramFunction);
			//for setting range the vision
			plotter->addFunctionToMove(histogramFunction);
			wxPen mypen1(*wxBLUE, 1, wxSOLID );
			mypen1.SetWidth(2);
			histogramFunction->SetPen( mypen1 );
		}
			
			free(xValues);
			free(yValues);
		
	}
	/*
	Draw the transference function in the plotter
	one  for default
	*/
	void HistogramWidget::drawTransferenceFunction()
	{
			double xValues[5],yValues[5];
			//xValues
			int maxValueGrey=histogram->getMaximumLevelOfGrey();
			xValues[0] = 0;
			xValues[1] = maxValueGrey/16;
			xValues[2] = maxValueGrey/8;
			xValues[3] = maxValueGrey/16+(maxValueGrey-maxValueGrey/2)/2;
			xValues[4] = maxValueGrey;
			
			//yValues
			yValues[0] = 0;
			yValues[1] = 25;
			yValues[2] = 100;
			yValues[3] = 25;
			yValues[4] = 0;
			
			pGraphicalFunction * tf = plotter ->getFunctionForVectors( xValues, 5, yValues, 5 ); 
			printf("EED %p HistogramWidget::drawTransferenceFunction %p\n", this , tf);		
			// Including and drawing the created function in the plotter
			if (tf)
			{
				tf->setType(1);
				//is the actual Function
				tf->setActual(true);
				//show points
				tf->SetShowPoints(true);
				idTransferenceFunction=plotter->addFunction( tf );
				if(type==1)
				{
					plotter->addFunctionToMove(tf);
				}
				wxPen mypen(*wxBLACK,0.5, wxSOLID  );
				mypen.SetWidth(2);
				tf->SetPen( mypen );
			} // if tf
	}

	/*
		if the user resize the window	
	*/
	void HistogramWidget::OnSize(wxSizeEvent &WXUNUSED(event))
	{
		int scrX,scrY;
		GetClientSize(&scrX,&scrY);
		plotter->SetSize(scrX,scrY);
		pGraphicalFunction* actual=plotter->getFunction(idTransferenceFunction);
		if(actual!=NULL)
		{
			actual->setScreens(scrX,scrY);
			actual->setScales();
		}
		
	}
	/*
		get number of points of the transference function
	*/
	int HistogramWidget::getSizeTransferenceFunction()
	{
		pGraphicalFunction* tf=plotter->getFunction(idTransferenceFunction);
		return tf->getSizePoints();

	}
	/*
		get a point of the transference function
	*/
	void HistogramWidget::getTransferenceFunctionPoint(int index,int& x,int& y)
	{
		pGraphicalFunction* tf=plotter->getFunction(idTransferenceFunction);
		if(tf!=NULL)
		{
			wxNode* pnode				= tf->GetPointAt(index);
			pFunctionPoint* point	= (pFunctionPoint*)pnode->GetData();
			x								= point->getRealX();
			y								= point->getRealY();
		}
	}
	/*
		get a point of the Histogram
		given the grey value
	*/
	int HistogramWidget::getHistogramPoint(int gValue)
	{
		return histogram->getHistogramPoint(gValue);
	}
	/*
		get number of points of the barColor
	*/
	int HistogramWidget::getSizeBarColor()
	{
		return	plotter->getColorPointsSize();
	}
	/*
		get a  color int the bqr color
	*/
	void HistogramWidget::getDataBarColorPoint(int index,int&x, int& red,int& green,int& blue)
	{
		double tmp 	= x;
		plotter->getBarColorDataAt(index,tmp,red,green,blue);
		x				= (int)tmp;
	}
	/*
	 Returns the  maximum value ot the histogram that is show to the user 
	*/
	float HistogramWidget::getMaxShowedPorcentage()
	{
		float  porcentageMaxX 						= plotter->getMaxShowedPorcentage();
		pGraphicalFunction* histogramFunction	= plotter->getFunction(idHistogram);
		int min											= histogramFunction->getMinX();
		float x											= porcentageMaxX*(histogramFunction->getMaxX()-min);
		return min + x;
	}
	/*
	 Returns the  minimum value ot the histogram that is show to the user 
	*/
	float HistogramWidget::getMinShowedPorcentage()
	{
		float  porcentageMinX						= plotter->getMinShowedPorcentage();
		pGraphicalFunction* histogramFunction	= plotter->getFunction(idHistogram);
		int min											= histogramFunction->getMinX();
		float x											= porcentageMinX*(histogramFunction->getMaxX()-min);
		return min + x;
	}
	/*
	 Returns the  minimum value ot the histogram that is show to the user 
	*/
	float HistogramWidget::getActualShowedPorcentage()
	{
		float  porcentageActualX					= plotter->getMinShowedPorcentage();
		pGraphicalFunction* histogramFunction	= plotter->getFunction(idHistogram);
		int min											= histogramFunction->getMinX();
		float x											= porcentageActualX*(histogramFunction->getMaxX()-min);
		return min + x;
	}
	//---------------------------------------
	// setting data in transferences function
	// and in bar color
	//----------------------------------------
	/*
	  Adds a point to the transference function
	*/
	bool  HistogramWidget::addPointToTransferenceFunction(double x, double y)
	{
		bool result=false;
		pGraphicalFunction* tf=plotter->getFunction(idTransferenceFunction);
//printf("EED %p HistogramWidget::addPointToTransferenceFunction tp%p x%f y%f %d\n",this, tf, x ,y, idTransferenceFunction);
		if (tf!=NULL) 
		{ 
			result=tf->AddPoint(x,y); 
		} // if tf
		
		return result;
	}
	/*
		add a color point to the histogram
		@param x the level of grey to which the color is assigned
		@param red the level of red for the color
		@param green the level of red for the color
		@param blue the level of red for the color
	*/
	bool  HistogramWidget::addColorPoint(double x,int red,int green, int blue)
	{
		return plotter->addColorPoint(x,red,green,blue);
	}
	 
	//------------------------
	//Erase data
	//------------------------
	/*
	 Erase all the points that are in the transference function
	*/

	void HistogramWidget::erasePointsTransferenceFunction(/*bool allPoints*/)
	{
		if(transferenceFunctionHasPoints)
		{
			// we have to erase the points
			pGraphicalFunction* tf=plotter->getFunction(idTransferenceFunction);
			if (tf!=NULL){
				int numOfPoints=tf->getSizePoints();
				int i=numOfPoints-1;//-2;
				while(i>=0)
				{
					tf->deletePointAt(i);
					i--;
				} // while
			} // if tf
		} // if transferenceFunctionHasPoints
		
	//we set for actual the histogram
		//plotter->setActual()
	}
	/*
	Erase the  color points in the plotter
	*/
	void HistogramWidget::eraseColorPoints()
	{
		plotter->eraseColorPoints();
	}
	//------------------
	//Updating plotter
	//------------------
	void HistogramWidget::updatePlotter()
	{
		plotter->update();
	}

	//-------------------
	// Getter and setters
	//-------------------

	void HistogramWidget::setTransferenceFunctionHasPoints(bool hasPoints)
	{
		transferenceFunctionHasPoints = hasPoints;
	}

	void HistogramWidget::setTransferenceFunctionHasColor(bool hasColorPoints)
	{
		transferenceFunctionHasPoints = hasColorPoints;
	}

	int HistogramWidget::getHistogramSize()
	{
		return histogramSize;
	}

	void HistogramWidget::setType(int type)
	{
		this->type = type;
	}

/**
**	Returns two vectors, the grey level of the point and its value, the value is between [0,1]
**/
	void HistogramWidget::GetValuesPointsFunction(std::vector<double>& greylevel,std::vector<double>& value)
	{
		plotter->GetValuesPointsFunction(greylevel,value,histogramSize);
	}

/**
**	Returns two vectors, the grey level of the point and its value, the red, green
**	and blue value is between [0,1]
**/
	void HistogramWidget::GetValuesColorPointsFunction(std::vector<double>& greylevel,
								std::vector<double>& red,
								std::vector<double>& green,
								std::vector<double>& blue)
	{
		plotter->GetValuesColorPointsFunction(greylevel,red,green,blue);
	}
