/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */



#ifndef __HISTOGRAMW__
#define __HISTOGRAMW__


// ----------------------------------------------------------------------------
// wx headers inclusion.
// For compilers that support precompilation, includes <wx/wx.h>.
// ----------------------------------------------------------------------------
#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include "marTypes.h"
#include "pPlotter.h"
#include "pFunctionPoint.h"
#include  "vtkImageData.h"
#include "pHistogram.h"
#include "pPlotterScaleY.h"
#include "pPlotterScaleX.h"

//#define MAX 500
#define NUM_POINTS 100
#define WINDOW_SIZE 10

class creaMaracasVisu_EXPORT HistogramWidget:public wxPanel
{
public:
	//---------------------
	// Constructor
	//----------------------

	//HistogramWidget( wxWindow *parent, wxWindowID id, const wxPoint &pos, const wxSize &size, int flag );
	
 
	HistogramWidget( wxWindow *parent, wxWindowID id, const wxPoint &pos, const wxSize &size, int flag,vtkImageData* imageData,int type);

	HistogramWidget( wxWindow *parent, wxWindowID id);
	
	~HistogramWidget();

	/*
	Draw the histogram in the plotter
	*/
	void drawHistogram();
	/*
	Draw the transference function in the plotter
	*/
	void drawTransferenceFunction();
	/*
		if the user resize the window	
	*/
	void OnSize( wxSizeEvent &WXUNUSED(event) );
	//---------------------------------------
	// Get Information from the widget
	//---------------------------------------
	/*
		get number of points of the transference function
	*/
	int getSizeTransferenceFunction();
	/*
		get number of points of the barColor
	*/
	int getSizeBarColor();
	/*
		get a point of the transference function
	*/
	void getTransferenceFunctionPoint(int index,int& x,int& y);
	/*
		get a  color int the bqr color
	*/
	void getDataBarColorPoint(int index,int&x, int& red,int& green,int& blue);
	/*
		get a point of the Histogram
		given the grey value
	*/
	int getHistogramPoint(int gValue);

	//--------------------
	// bar Information
	//---------------------
	/*
	 Get the porcentage of the positions of 
	 the min,max and actual in the bar range
	*/
	float getMaxShowedPorcentage();
	float getMinShowedPorcentage();	
	float getActualShowedPorcentage();	

	//---------------------------------------
	// setting data in transferences function
	// and in bar color
	//----------------------------------------
	/*
	  Adds a point to the transference function
	*/
	bool addPointToTransferenceFunction(double x, double y);
	/*
		add a color point to the histogram
		@param x the level of grey to which the color is assigned
		@param red the level of red for the color
		@param green the level of red for the color
		@param blue the level of red for the color
	*/
	bool addColorPoint(double x,int red,int green, int blue);
	//--------------------
	// plotter Information
	//---------------------
	void updatePlotter();
	
	//------------------------
	//Erase data
	//------------------------
	

	/*
	 Erase all the points that are in the transference function
	*/
	void erasePointsTransferenceFunction();
	/*
	Erase the  color points in the plotter
	*/
	void eraseColorPoints();

	//-------------------
	// Getter and setters
	//-------------------

	void setTransferenceFunctionHasPoints(bool hasPoints);
	void setTransferenceFunctionHasColor(bool hasColorPoints);
	int getHistogramSize();
	void setType(int type);

	/**
	**	Initialize the histogram 
	*/
	void initializeHistogram(vtkImageData* img);
	/**
	**	Returns two vectors, the grey level of the point and its value, the value is between [0,1]
	**/
	void GetValuesPointsFunction(std::vector<double>& greylevel,std::vector<double>& value);

	/**
	**	Returns two vectors, the grey level of the point and its value, the red, green
	**	and blue value is between [0,1]
	**/
	void GetValuesColorPointsFunction(std::vector<double>& greylevel,
									std::vector<double>& red,
									std::vector<double>& green,
									std::vector<double>& blue);


	
private:
	
	 pHistogram* 	histogram;
	 pPlotter* 		plotter;
	 int 			idTransferenceFunction;
	 int 			histogramSize;
	 int 			idHistogram;
	 /*
	  if the image has already a transference
	  function and color defines to that function
	  we have to draw it in the widget
	 */
	 bool transferenceFunctionHasPoints;
	 bool transferenceFunctionHasColor;
	 wxPanel* getControls();
	 /*
	 * type=1 with transference function for moving
	 * type=2 without transference function for moving
	 */
	 int type;	
	 
	 DECLARE_CLASS(HistogramWidget);

	 //----------------------------------------------------------------------------
	// wxWidget macro use declaration for handdling events
	//----------------------------------------------------------------------------
	DECLARE_EVENT_TABLE()
	
};
#endif


